/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.accessories.mikropack.devices;

import com.oceanoptics.omnidriver.accessories.mikropack.commands.Node;
import com.oceanoptics.omnidriver.accessories.mikropack.commands.getactualhomingstatus.GetActualHomingStatus;
import com.oceanoptics.omnidriver.accessories.mikropack.devices.MPDeviceBase;
import com.oceanoptics.omnidriver.accessories.mikropack.exceptions.TimeoutException;
import com.oceanoptics.unirs232.UniRS232;
import java.io.IOException;

public class MappingTable
extends MPDeviceBase {
    public final int X_150 = 1;
    public final int X_200 = 2;
    public final int Y_150 = 16;
    public final int Z_100 = 256;
    public final int X_ABSENT = 65532;
    public final int Y_ABSENT = 65519;
    public final int Z_ABSENT = 65279;
    private int axesConfiguration;
    private int[] maximumPosition;
    private int[] ticksPerMM;
    private String[] EEPROM;
    private Node[] nodes = new Node[4];
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/unirs232/UniRS232;)V\nreadCurrentPositionInMM,(I)D\ngetCurrentPositionInMM,(I)D\nmoveToMM,(ID)V\nmoveToInch,(ID)V\nmoveRelativeMM,(ID)V\nmoveRelativeInch,(ID)V\nmoveToMM,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;D)V\nmoveToInch,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;D)V\nmoveRelativeMM,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;D)V\nmoveRelativeInch,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;D)V\nmoveToMMAndWait,(ID)V\nmoveToInchAndWait,(ID)V\nmoveRelativeMMAndWait,(ID)V\nmoveRelativeInchAndWait,(ID)V\nmoveToMMAndWait,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;D)V\nmoveToInchAndWait,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;D)V\nmoveRelativeMMAndWait,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;D)V\nmoveRelativeInchAndWait,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;D)V\ngetPositionInMM,(I)D\ngetPositionInMM,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;)D\ngetPositionInInch,(I)D\ngetPositionInInch,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;)D\nsetAxesConfiguration,(I)V\nsetXConfiguration,(I)V\nsetYConfiguration,(I)V\nsetZConfiguration,(I)V\ngetXConfiguration,()Ljava/lang/String;\ngetYConfiguration,()Ljava/lang/String;\ngetZConfiguration,()Ljava/lang/String;\ngetAxesConfiguration,()Ljava/lang/String;\nxPresent,()Z\nyPresent,()Z\nzPresent,()Z\n";

    public MappingTable(UniRS232 serPort) throws IOException, TimeoutException {
        super(serPort);
        int i;
        int i2;
        this.nodes[0] = null;
        this.nodes[1] = new Node();
        this.nodes[2] = new Node();
        this.nodes[3] = new Node();
        this.nodes[1].setIndex(1);
        this.nodes[2].setIndex(2);
        this.nodes[3].setIndex(3);
        this.maximumPosition = new int[4];
        this.ticksPerMM = new int[4];
        for (i2 = 1; i2 < 4; ++i2) {
            try {
                int n = this.getNodeNumber(this.nodes[i2]);
                if (n != i2) {
                    throw new IOException("Node number did not match.");
                }
                System.err.println("node " + i2 + " is valid");
                continue;
            }
            catch (IOException e) {
                System.err.println("node " + i2 + " is invalid");
                this.nodes[i2] = null;
            }
        }
        this.maxSpeed = 1000;
        this.speedFactor = 90.0;
        for (i2 = 1; i2 < 4; ++i2) {
            if (this.nodes[i2] == null) continue;
            this.positiveLimit[this.nodes[i2].getIndex()] = this.getPositiveLimit(this.nodes[i2]);
            this.negativeLimit[this.nodes[i2].getIndex()] = this.getNegativeLimit(this.nodes[i2]);
            this.setSpeed(this.nodes[i2], this.maxSpeed);
            this.setResponseMode(this.nodes[i2], 1);
            this.notifyPositionEnable(this.nodes[i2]);
        }
        boolean homingDone = false;
        this.runHomingSequence(Node.ALL());
        while (!homingDone) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            homingDone = true;
            for (i = 1; i < 4; ++i) {
                if (this.nodes[i] == null) continue;
                GetActualHomingStatus.ActualHomingStatus homingStatus = this.getActualHomingStatus(this.nodes[i]);
                homingDone = homingDone && homingStatus.HL;
            }
        }
        for (i = 1; i < 4; ++i) {
            if (this.nodes[i] == null) continue;
            this.setHomePosition(this.nodes[i]);
            this.currentPosition[this.nodes[i].getIndex()] = this.getPosition(this.nodes[i]);
            this.ticksPerMM[this.nodes[i].getIndex()] = 1000;
        }
        this.setXConfiguration(2);
        this.setYConfiguration(16);
        this.setZConfiguration(256);
    }

    public double readCurrentPositionInMM(int axis) throws IOException {
        return this.getPosition(this.nodes[axis]) * this.ticksPerMM[this.nodes[axis].getIndex()];
    }

    public double getCurrentPositionInMM(int axis) {
        return this.currentPosition[axis] * this.ticksPerMM[this.nodes[axis].getIndex()];
    }

    public void moveToMM(int axis, double position) throws IOException, TimeoutException {
        this.moveNodeToMM(this.nodes[axis], position);
    }

    public void moveToInch(int axis, double position) throws IOException, TimeoutException {
        this.moveNodeToMM(this.nodes[axis], position / 25.4);
    }

    public void moveRelativeMM(int axis, double position) throws IOException, TimeoutException {
        this.moveNodeToMM(this.nodes[axis], (double)this.currentPosition[axis] + position);
    }

    public void moveRelativeInch(int axis, double position) throws IOException, TimeoutException {
        this.moveNodeToMM(this.nodes[axis], (double)this.currentPosition[axis] + position / 25.4);
    }

    public void moveToMM(Node n, double position) throws IOException, TimeoutException {
        this.moveNodeToMM(n, position);
    }

    public void moveToInch(Node n, double position) throws IOException, TimeoutException {
        this.moveNodeToMM(n, position / 25.4);
    }

    public void moveRelativeMM(Node n, double position) throws IOException, TimeoutException {
        this.moveNodeToMM(n, (double)this.currentPosition[n.getIndex()] + position);
    }

    public void moveRelativeInch(Node n, double position) throws IOException, TimeoutException {
        this.moveNodeToMM(n, (double)this.currentPosition[n.getIndex()] + position / 25.4);
    }

    public void moveToMMAndWait(int axis, double position) throws IOException, TimeoutException {
        this.moveNodeToMMAndWait(this.nodes[axis], position);
    }

    public void moveToInchAndWait(int axis, double position) throws IOException, TimeoutException {
        this.moveNodeToMMAndWait(this.nodes[axis], position / 25.4);
    }

    public void moveRelativeMMAndWait(int axis, double position) throws IOException, TimeoutException {
        this.moveNodeToMMAndWait(this.nodes[axis], (double)this.currentPosition[axis] + position);
    }

    public void moveRelativeInchAndWait(int axis, double position) throws IOException, TimeoutException {
        this.moveNodeToMMAndWait(this.nodes[axis], (double)this.currentPosition[axis] + position / 25.4);
    }

    public void moveToMMAndWait(Node n, double position) throws IOException, TimeoutException {
        this.moveNodeToMMAndWait(n, position);
    }

    public void moveToInchAndWait(Node n, double position) throws IOException, TimeoutException {
        this.moveNodeToMMAndWait(n, position / 25.4);
    }

    public void moveRelativeMMAndWait(Node n, double position) throws IOException, TimeoutException {
        this.moveNodeToMMAndWait(n, (double)this.currentPosition[n.getIndex()] + position);
    }

    public void moveRelativeInchAndWait(Node n, double position) throws IOException, TimeoutException {
        this.moveNodeToMMAndWait(n, (double)this.currentPosition[n.getIndex()] + position / 25.4);
    }

    private void moveNodeToMM(Node n, double position) throws IOException {
        int ticks = (int)(position * (double)this.ticksPerMM[n.getIndex()]);
        if (ticks < this.maximumPosition[n.getIndex()]) {
            this.loadAbsolutePosition(n, ticks);
            this.move(n);
            this.currentPosition[n.getIndex()] = ticks;
        }
    }

    private void moveNodeToMMAndWait(Node n, double position) throws IOException, TimeoutException {
        int ticks = (int)(position * (double)this.ticksPerMM[n.getIndex()]);
        if (ticks < this.maximumPosition[n.getIndex()]) {
            this.loadAbsolutePosition(n, ticks);
            this.moveAndWait(n);
            this.currentPosition[n.getIndex()] = ticks;
        }
    }

    public double getPositionInMM(int axis) throws IOException {
        return this.getPositionInMM(this.nodes[axis]);
    }

    public double getPositionInMM(Node n) throws IOException {
        return (double)this.getPosition(n) / 1000.0;
    }

    public double getPositionInInch(int axis) throws IOException {
        return this.getPositionInMM(this.nodes[axis]) / 25.4;
    }

    public double getPositionInInch(Node n) throws IOException {
        return this.getPositionInMM(n) / 25.4;
    }

    public void setAxesConfiguration(int config) {
        this.axesConfiguration = 0;
        this.setXConfiguration(config & 0xFFFF0003);
        this.setYConfiguration(config & 0xFFFF0010);
        this.setZConfiguration(config & 0xFFFF0100);
    }

    public void setXConfiguration(int config) {
        this.axesConfiguration &= 0xFFFC;
        if (config == 1) {
            this.axesConfiguration |= config;
            this.maximumPosition[1] = 150 * this.ticksPerMM[1];
        } else if (config == 2) {
            this.axesConfiguration |= config;
            this.maximumPosition[1] = 200 * this.ticksPerMM[1];
        } else if (config == 65532 || config == 0) {
            this.axesConfiguration &= 0xFFFC;
            this.maximumPosition[1] = 0;
        } else {
            throw new IllegalArgumentException("Invalid X Axis Value");
        }
    }

    public void setYConfiguration(int config) {
        this.axesConfiguration &= 0xFFEF;
        if (config == 16) {
            this.axesConfiguration |= config;
        } else if (config == 65519 || config == 0) {
            this.axesConfiguration &= 0xFFEF;
        } else {
            throw new IllegalArgumentException("Invalid Y Axis Value");
        }
    }

    public void setZConfiguration(int config) {
        this.axesConfiguration &= 0xFEFF;
        if (config == 256) {
            this.axesConfiguration |= config;
        } else if (config == 65279 || config == 0) {
            this.axesConfiguration &= 0xFEFF;
        } else {
            throw new IllegalArgumentException("Invalid Z Axis Value");
        }
    }

    public String getXConfiguration() {
        String retval = new String();
        retval = (this.axesConfiguration & 1) != 0 ? "X-150 " : ((this.axesConfiguration & 2) != 0 ? "X-200 " : "X-axis Absent ");
        return retval;
    }

    public String getYConfiguration() {
        String retval = new String();
        retval = (this.axesConfiguration & 0x10) != 0 ? "Y-150 " : "X-axis Absent ";
        return retval;
    }

    public String getZConfiguration() {
        String retval = new String();
        retval = (this.axesConfiguration & 0x100) != 0 ? "Z-100 " : "Z-axis Absent ";
        return retval;
    }

    public String getAxesConfiguration() {
        String retval = new String();
        retval = retval + this.getXConfiguration();
        retval = retval + this.getYConfiguration();
        retval = retval + this.getZConfiguration();
        return retval;
    }

    public boolean xPresent() {
        return (this.axesConfiguration & 0xFFFF0003) != 0;
    }

    public boolean yPresent() {
        return (this.axesConfiguration & 0xFFFF0010) != 0;
    }

    public boolean zPresent() {
        return (this.axesConfiguration & 0xFFFF0100) != 0;
    }
}

