/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.api.wrapper;

import com.oceanoptics.omnidriver.api.wrapper.Wrapper;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class Main {
    private static String __extern__ = "__extern__\n<init>,()V\nmain,([Ljava/lang/String;)V\nsaveSpectrumToFile,(Ljava/lang/String;[D)V\n";

    public static void main(String[] args) {
        Main.testTimeoutFeature();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSpectrumToFile(String pathname, double[] pixelArray) {
        PrintStream ps = null;
        try {
            ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(pathname)));
            int numberOfPixels = pixelArray.length;
            for (int index = 0; index < numberOfPixels; ++index) {
                ps.println(pixelArray[index]);
            }
            ps.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        finally {
            ps.close();
        }
    }

    private static void testTimeoutFeature() {
        Wrapper wrapper = new Wrapper();
        System.out.println("Test Timeout Feature");
        int numberOfSpectrometers = wrapper.openAllSpectrometers();
        System.out.println("Number of spectrometers detected = " + numberOfSpectrometers);
        if (numberOfSpectrometers == 0) {
            System.out.println("No attached spectrometers, exiting.");
            return;
        }
        int spectrometerIndex = 0;
        System.out.println("name: " + wrapper.getName(spectrometerIndex));
        System.out.println("serial number = " + wrapper.getSerialNumber(spectrometerIndex));
        System.out.println("FX2 firmware version = " + wrapper.getFirmwareVersion(spectrometerIndex));
        Main.performTimeoutTestCase(wrapper, spectrometerIndex, 5000, 10000, 1);
    }

    private static void performTimeoutTestCase(Wrapper wrapper, int spectrometerIndex, int timeoutMilliseconds, int integrationTime, int externalTriggerMode) {
        System.out.println();
        System.out.println("Test conditions: integrationTime:" + integrationTime + "  timeoutMilliseconds:" + timeoutMilliseconds + "  externalTriggerMode:" + externalTriggerMode);
        wrapper.setTimeout(spectrometerIndex, timeoutMilliseconds);
        wrapper.setIntegrationTime(spectrometerIndex, integrationTime);
        wrapper.setExternalTriggerMode(spectrometerIndex, externalTriggerMode);
        System.out.println("getSpectrum() called");
        wrapper.getSpectrum(spectrometerIndex);
        System.out.println("is timeout: " + wrapper.isTimeout(spectrometerIndex));
        wrapper.setExternalTriggerMode(spectrometerIndex, 0);
        System.out.println("getSpectrum() called, normal mode");
        wrapper.getSpectrum(spectrometerIndex);
        System.out.println("is timeout: " + wrapper.isTimeout(spectrometerIndex));
    }
}

