/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.interfaces.FPGA;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.FPGARegisters;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public abstract class FPGAImpl
extends USBFeature
implements FPGA {
    private static final short DATA_OUT = 1;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    public USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
    public USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\nsetFPGA,(BI)V\ngetFPGA,(B)I\ngetAllFPGA,()[I\n";

    public FPGAImpl(USBInterface usbInt) {
        super(usbInt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFPGA(byte reg, int value) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 106;
            this.out[1] = reg;
            this.out[2] = ByteRoutines.getLowByte((short)((short)value));
            this.out[3] = ByteRoutines.getHighByte((short)((short)value));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 4);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                this.logger.severe("Register not written. Please retry");
                e.printStackTrace();
            }
            this.logger.fine("Wrote " + value + " to register " + reg);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFPGA(byte reg) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                short filler = 0;
                this.out[0] = 107;
                this.out[1] = reg;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 3);
                this.logger.fine("Performed read on the FPGA register " + reg);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ByteRoutines.makeDWord((short)filler, (short)ByteRoutines.makeWord((byte)this.in[2], (byte)this.in[1]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAllFPGA() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                int[] value = new int[FPGARegisters.FPGA_REGISTERS.length];
                short filler = 0;
                for (int i = 0; i < FPGARegisters.FPGA_REGISTERS.length; ++i) {
                    this.out[0] = 107;
                    this.out[1] = FPGARegisters.FPGA_REGISTERS[i];
                    this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                    this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 3);
                    value[i] = ByteRoutines.makeDWord((short)filler, (short)ByteRoutines.makeWord((byte)this.in[2], (byte)this.in[1]));
                }
                this.logger.fine("Read the values from all of the FPGA registers.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return value;
            }
        }
    }
}

