/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features;

import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.uniusb.UniUSB;
import java.io.IOException;
import java.util.logging.Logger;

public class USBImpl
implements USBInterface {
    protected long deviceID = -1L;
    protected boolean valid;
    protected UniUSB usb;
    private Logger logger = Logger.getLogger("Spectrometer");
    byte[] in = new byte[1024];
    byte[] out = new byte[1024];
    private static String __extern__ = "__extern__\n<init>,()V\ngetInputBuffer,()[B\ngetOutputBuffer,()[B\nincreaseInputBufferSize,(I)V\nincreaseOutputBufferSize,(I)V\nsetTimeout,(Lcom/oceanoptics/uniusb/USBEndpointDescriptor;I)I\nbulkIn,(Lcom/oceanoptics/uniusb/USBEndpointDescriptor;[BI)V\nbulkOut,(Lcom/oceanoptics/uniusb/USBEndpointDescriptor;[BI)V\nreadUSBStringDescriptor,(I)Ljava/lang/String;\nopenDevice,(III)V\ncloseDevice,()V\ntoString,()Ljava/lang/String;\ngetUSBStringDescriptor,(I)Ljava/lang/String;\nisUSB2Mode,()Z\n";

    public USBImpl() {
        this.usb = new UniUSB();
    }

    public byte[] getInputBuffer() {
        return this.in;
    }

    public byte[] getOutputBuffer() {
        return this.out;
    }

    public void increaseInputBufferSize(int size) {
        this.in = new byte[size];
    }

    public void increaseOutputBufferSize(int size) {
        this.out = new byte[size];
    }

    public int setTimeout(USBEndpointDescriptor endPointDescriptor, int timeoutMilliseconds) throws IOException {
        if (!this.valid) {
            throw new IOException("Invalid device descriptor (call openDevice() first)");
        }
        this.logger.finest("USBImpl.setTimeout()");
        return this.usb.setTimeout(this.deviceID, endPointDescriptor, timeoutMilliseconds);
    }

    public void bulkIn(USBEndpointDescriptor endPointDescriptor, byte[] data, int length) throws IOException {
        if (!this.valid) {
            throw new IOException("Invalid device descriptor (call openDevice() first)");
        }
        this.logger.finest("Bulk in.");
        this.usb.bulkIn(this.deviceID, endPointDescriptor, data, length);
    }

    public void bulkOut(USBEndpointDescriptor endPointDescriptor, byte[] data, int length) throws IOException {
        if (!this.valid) {
            throw new IOException("Invalid device descriptor (call openDevice() first)");
        }
        this.logger.finest("Bulk out.");
        this.usb.bulkOut(this.deviceID, endPointDescriptor, data, length);
    }

    public String readUSBStringDescriptor(int num) throws IOException {
        if (!this.valid) {
            throw new IOException("Invalid device descriptor (call openDevice() first)");
        }
        this.logger.finest("Getting USB string descriptor...");
        return this.usb.getUSBStringDescriptor(this.deviceID, num);
    }

    public void openDevice(int vendorID, int prodID, int index) throws IOException {
        this.deviceID = this.usb.openDevice(vendorID, prodID, index);
        this.valid = true;
    }

    public void closeDevice() throws IOException {
        if (!this.valid) {
            throw new IOException("Invalid device descriptor (call openDevice() first)");
        }
        this.usb.closeDevice(this.deviceID);
        this.deviceID = -1L;
    }

    public String toString() {
        return new String("USB Device index " + this.deviceID + "(" + (this.valid ? "valid" : "invalid") + ")");
    }

    public String getUSBStringDescriptor(int index) throws IOException {
        if (!this.valid) {
            throw new IOException("Invalid device descriptor (call openDevice() first)");
        }
        return this.usb.getUSBStringDescriptor(this.deviceID, index);
    }

    public boolean isUSB2Mode() {
        return this.usb.isUSB2Mode();
    }
}

