/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.analogin;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.analogin.AnalogInGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class AnalogInImpl
extends USBFeature
implements AnalogInGUIProvider {
    private final double COUNTS_PER_VOLT = (Math.pow(2.0, 13.0) - 1.0) / 5.0;
    private static final short DATA_OUT = 1;
    private static final short LOW_SPEED_DATA_IN = 129;
    public USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
    public USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    protected String featurePath = "analogin.AnalogInPanel";
    private static final short MAX_PACKET_SIZE = 512;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetVoltageIn,()D\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public AnalogInImpl(USBInterface usbInt) {
        super(usbInt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getVoltageIn() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                int value = -1;
                this.out[0] = 105;
                this.out[1] = 16;
                this.out[2] = 2;
                this.out[3] = 1;
                this.out[4] = 1;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 5);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.logger.severe("PSoC read error.");
                    e.printStackTrace();
                }
                this.out[0] = 104;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 2);
                value = ByteRoutines.makeWord((byte)this.in[0], (byte)this.in[1]);
                this.logger.fine("Performed ADC read on the PSoC.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return (double)value / this.COUNTS_PER_VOLT;
            }
        }
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

