/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.analogout;

import com.oceanoptics.omnidriver.features.analogout.AnalogOutImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class AnalogOutImpl_ADC1000
extends AnalogOutImpl {
    private Integer lastCounts = null;
    private boolean dacPresent = false;
    private int firmware = 0;
    private boolean firmwareValid = false;
    private int numDACPins = 0;
    private int MIN_COUNTS = 0;
    private int MAX_COUNTS = 4095;
    private int COUNTS_STEP = 1;
    private final int DAC_INFO_SLOT = 43;
    protected String featurePath = "analogout.AnalogOutPanel";
    private double COUNTS_PER_VOLT = (double)this.MAX_COUNTS / 5.0;
    private static final short DATA_OUT = 2;
    private static final short LOW_SPEED_DATA_IN = 135;
    private static final short MAX_PACKET_SIZE = 64;
    public USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
    public USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 135, 2, 64, 0);
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;II)V\nisFirmwareValid,()Z\nisDACPresent,()Z\nsetDACCounts,(II)V\nreadDACCounts,(I)I\nanalogOutCountsToVolts,(I)D\ngetDACCounts,(I)Ljava/lang/Integer;\ngetDACMinimum,()I\ngetDACMaximum,()I\ngetDACIncrement,()I\ngetDACPins,()I\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public AnalogOutImpl_ADC1000(USBInterface usbInt, int fw, int pins) {
        super(usbInt);
        this.firmware = fw;
        this.numDACPins = pins;
        try {
            this.firmwareValid = this.isFirmwareValid();
            this.dacPresent = this.isDACPresent();
            this.initDAC();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isFirmwareValid() {
        if (this.firmware < 1001000) {
            this.logger.severe("Firmware must be at least 1.01.0");
            this.firmwareValid = false;
        } else {
            this.firmwareValid = true;
        }
        return this.firmwareValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDACPresent() throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            if (this.firmwareValid && !this.dacPresent) {
                this.dacPresent = this.preInitDACCheck();
                if (!this.dacPresent) {
                    this.dacPresent = this.postInitDACCheck();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.dacPresent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean preInitDACCheck() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = 81;
                this.out[1] = 0;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 3);
                int result = ByteRoutines.signedByteToUnsignedByte((byte)this.in[1]);
                if (result == 240) {
                    this.persistDAC();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postInitDACCheck() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = 5;
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)43));
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                if (1 == this.in[2]) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDAC() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                if (this.firmwareValid && this.dacPresent) {
                    this.out[0] = 80;
                    this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                    this.lastCounts = new Integer(this.readDACCounts(0));
                }
                this.lastCounts = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDACCounts(int counts, int channel) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            if (this.isChannelValid(channel) && this.dacPresent) {
                this.out[0] = 82;
                this.out[1] = (byte)channel;
                this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)counts));
                this.out[3] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)counts));
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 4);
                this.logger.fine("DAC " + channel + " set to " + counts);
                this.lastCounts = new Integer(counts);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readDACCounts(int channel) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                if (this.isChannelValid(channel) && this.dacPresent) {
                    this.out[0] = 81;
                    this.out[1] = (byte)channel;
                    this.usb.bulkOut(this.lowSpeedInEndPoint, this.out, 2);
                    this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 3);
                    int i = ByteRoutines.makeDWord((short)ByteRoutines.getHighByte((short)ByteRoutines.byteToShort((byte)this.in[1])), (short)ByteRoutines.getLowByte((short)ByteRoutines.byteToShort((byte)this.in[2]))) & 0xFFFF0FFF;
                    this.logger.fine("DAC " + channel + ": " + i);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return i;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return -1;
        }
    }

    private boolean isChannelValid(int channel) {
        return channel >= 0 && channel <= this.numDACPins - 1;
    }

    public double analogOutCountsToVolts(int counts) {
        return (double)counts / this.COUNTS_PER_VOLT;
    }

    public Integer getDACCounts(int channel) {
        if (this.isChannelValid(channel) && this.dacPresent) {
            try {
                this.lastCounts = new Integer(this.readDACCounts(channel));
            }
            catch (IOException e) {
                e.printStackTrace();
                this.lastCounts = null;
            }
        }
        return this.lastCounts;
    }

    public int getDACMinimum() {
        return this.MIN_COUNTS;
    }

    public int getDACMaximum() {
        return this.MAX_COUNTS;
    }

    public int getDACIncrement() {
        return this.COUNTS_STEP;
    }

    public int getDACPins() {
        return this.numDACPins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistDAC() throws IOException {
        byte[] dac = new byte[15];
        dac[0] = 1;
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 6;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)43));
            for (int i = 0; i < dac.length; ++i) {
                this.out[2 + i] = dac[i];
            }
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 17);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                this.logger.severe("EEPROM write might not have completed. Please verify.");
                throw new IOException("EEPROM write might not have completed. Please verify.");
            }
            return;
        }
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

