/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.autonulling;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingConfiguration;
import com.oceanoptics.omnidriver.features.autonulling.AutonullingGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class AutonullingImpl
extends USBFeature
implements AutonullingGUIProvider {
    private int scanStatus = 0;
    private int scanValue = 0;
    private AutonullingConfiguration configuration = null;
    protected String featurePath = "autonulling.AutonullingPanel";
    private static final short DATA_OUT = 1;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    public USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
    public USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\nreadAutonullingConfigurationFromSpectrometer,()Lcom/oceanoptics/omnidriver/features/autonulling/AutonullingConfiguration;\ngetAutonullingScanStatus,()I\ngetAutonullingScanValue,()I\ngetAutonullingConfiguration,()Lcom/oceanoptics/omnidriver/features/autonulling/AutonullingConfiguration;\nsetAutonullingConfiguration,(Lcom/oceanoptics/omnidriver/features/autonulling/AutonullingConfiguration;)V\nwriteAutonullingConfigurationToSpectrometer,()V\nsetAutonullingScanStatus,(I)V\nsetAutonullingScanValue,(I)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public AutonullingImpl(USBInterface usbInt) {
        super(usbInt);
        this.configuration = new AutonullingConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutonullingConfiguration readAutonullingConfigurationFromSpectrometer() throws IOException {
        AutonullingConfiguration cfg = new AutonullingConfiguration();
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = 5;
                this.out[1] = 17;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                cfg.setEnabled(this.in[2]);
                cfg.setTemperatureCompensationEnabled(this.in[3]);
                cfg.setDarkValue(ByteRoutines.makeWord((byte)this.in[5], (byte)this.in[4]));
                long temp = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)this.in[7], (byte)this.in[6]);
                cfg.setSaturationValue(temp);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return cfg;
        }
    }

    public int getAutonullingScanStatus() {
        return this.scanStatus;
    }

    public int getAutonullingScanValue() {
        return this.scanValue;
    }

    public AutonullingConfiguration getAutonullingConfiguration() {
        return this.configuration;
    }

    public void setAutonullingConfiguration(AutonullingConfiguration configuration) {
        this.configuration = configuration;
    }

    public void writeAutonullingConfigurationToSpectrometer() throws IOException {
    }

    public void setAutonullingScanStatus(int value) {
        this.scanStatus = value;
    }

    public void setAutonullingScanValue(int value) {
        this.scanValue = value;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

