/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.badpixelremoval;

import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.sts.STS;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class BadPixelRemovalImpl_STS
extends BadPixelRemovalImpl {
    protected STS spectrometer;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/sts/STS;Lcom/oceanoptics/omnidriver/interfaces/USBInterface;I)V\ngetBadPixelsFromSpectrometer,()[I\nsetBadPixelsToSpectrometer,()V\n";

    public BadPixelRemovalImpl_STS(STS sts, USBInterface usbInt, int numberOfPixels) {
        super(usbInt, numberOfPixels);
        this.spectrometer = sts;
        try {
            this.badPixels = this.getBadPixelsFromSpectrometer();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public int[] getBadPixelsFromSpectrometer() throws IOException {
        byte[] data = this.spectrometer.queryDevice(1597440, null);
        if (null == data) {
            this.numberOfBadPixels = 0;
            return new int[0];
        }
        int[] retval = new int[data.length / 2];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = ByteRoutines.makeWord((byte)data[i * 2 + 1], (byte)data[i * 2]);
        }
        this.numberOfBadPixels = retval.length;
        return retval;
    }

    public void setBadPixelsToSpectrometer() throws IOException {
        int[] badPix = this.getBadPixels();
        if (null == badPix) {
            badPix = new int[]{};
        }
        byte[] payload = new byte[badPix.length * 2];
        for (int i = 0; i < badPix.length; ++i) {
            payload[i * 2] = (byte)(badPix[i] & 0xFF);
            payload[i * 2 + 1] = (byte)(badPix[i] >> 8 & 0xFF);
        }
        boolean success = this.spectrometer.sendCommandToDevice(1597456, payload);
        if (!success) {
            throw new IOException("Failed to read back ACK.");
        }
    }
}

