/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.continuousstrobe;

import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl;
import com.oceanoptics.omnidriver.interfaces.MasterClockDivisorListener;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import java.io.IOException;

public class ContinuousStrobeImpl_FPGA
extends ContinuousStrobeImpl
implements ContinuousStrobeGUIProvider,
MasterClockDivisorListener {
    private final int MAX_DELAY = 64000000;
    private final int MIN_DELAY = 1;
    private int delayIncrement = 1;
    private double countsPerMicros = 48.0;
    private Integer delay = null;
    private Integer baseClock = null;
    protected String featurePath = "continuousstrobe.ContinuousStrobePanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetContinuousStrobeDelayIncrement,(I)I\ngetContinuousStrobeDelayMaximum,()I\ngetContinuousStrobeDelayMinimum,()I\ngetContinuousStrobeDelay,()Ljava/lang/Integer;\nsetContinuousStrobeDelay,(I)V\ncontinuousStrobeCountsToMicros,(I)D\nmasterClockChanged,(J)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public ContinuousStrobeImpl_FPGA(USBInterface usbInt) throws IOException {
        super(usbInt);
        this.init();
    }

    private void init() throws IOException {
        this.delay = new Integer(this.getFPGA((byte)8));
        this.baseClock = new Integer(this.getFPGA((byte)12));
    }

    public int getContinuousStrobeDelayIncrement(int magnitude) {
        this.updateDelayIncrement(magnitude);
        return this.delayIncrement;
    }

    public int getContinuousStrobeDelayMaximum() {
        return this.MAX_DELAY;
    }

    public int getContinuousStrobeDelayMinimum() {
        return this.MIN_DELAY;
    }

    public Integer getContinuousStrobeDelay() {
        if (null == this.delay || null == this.baseClock) {
            return null;
        }
        return new Integer(this.delay * (this.baseClock + 1) / 48);
    }

    private void updateDelayIncrement(long magnitude) {
        int bits = (int)Math.floor(Math.log(magnitude) / Math.log(2.0)) + 1;
        this.delayIncrement = bits < 17 ? 1 : 1000;
    }

    public void setContinuousStrobeDelay(int delayMicros) throws IOException {
        int timerValue = 48;
        int baseClockValue = 0;
        int bits = (int)Math.floor(Math.log(delayMicros) / Math.log(2.0)) + 1;
        this.updateDelayIncrement(delayMicros);
        if (bits < 17) {
            baseClockValue = delayMicros - 1;
        } else if (bits <= 26) {
            timerValue = 48000;
            baseClockValue = delayMicros / 1000 - 1;
        } else {
            throw new IllegalArgumentException("Input strobe delay too large (" + delayMicros + " > 64000000)");
        }
        this.setFPGA((byte)8, timerValue);
        this.setFPGA((byte)12, baseClockValue);
        this.delay = new Integer(timerValue);
        this.baseClock = new Integer(baseClockValue);
    }

    public double continuousStrobeCountsToMicros(int counts) {
        return (double)counts / this.countsPerMicros;
    }

    public void masterClockChanged(long newValue) {
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

