/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.externaltriggerdelay;

import com.oceanoptics.omnidriver.features.FPGAImpl;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayGUIProvider;
import com.oceanoptics.omnidriver.interfaces.MasterClockDivisorListener;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import java.io.IOException;

public class ExternalTriggerDelayImpl
extends FPGAImpl
implements ExternalTriggerDelayGUIProvider,
MasterClockDivisorListener {
    private Integer triggerDelay = null;
    private final int MIN_TRIGGER_DELAY = 0;
    private final int MAX_TRIGGER_DELAY = 65535;
    private final int TRIGGER_DELAY_INCREMENT = 1;
    private double countsPerMicros = 48.0;
    protected String featurePath = "externaltriggerdelay.ExternalTriggerDelayPanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ntriggerDelayCountsToMicroseconds,(I)D\ngetExternalTriggerDelayIncrement,()I\ngetExternalTriggerDelayMaximum,()I\ngetExternalTriggerDelayMinimum,()I\ngetExternalTriggerDelay,()Ljava/lang/Integer;\nsetExternalTriggerDelay,(I)V\nmasterClockChanged,(J)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public ExternalTriggerDelayImpl(USBInterface usbInt) {
        super(usbInt);
    }

    public double triggerDelayCountsToMicroseconds(int counts) {
        return (double)counts / this.countsPerMicros;
    }

    public int getExternalTriggerDelayIncrement() {
        return this.TRIGGER_DELAY_INCREMENT;
    }

    public int getExternalTriggerDelayMaximum() {
        return this.MAX_TRIGGER_DELAY;
    }

    public int getExternalTriggerDelayMinimum() {
        return this.MIN_TRIGGER_DELAY;
    }

    public Integer getExternalTriggerDelay() {
        return this.triggerDelay;
    }

    public void setExternalTriggerDelay(int value) throws IOException {
        if (value > 65535 || value < 0) {
            this.logger.severe("Hardware trigger delay must be between 0-65535");
            throw new IllegalArgumentException("Hardware trigger delay must be between 0-65535");
        }
        this.setFPGA((byte)40, value);
        this.logger.fine("Hardware trigger delay set to " + value);
        this.triggerDelay = new Integer(value);
    }

    private void init() throws IOException {
        int td = this.getFPGA((byte)40);
        this.triggerDelay = new Integer(td);
    }

    public void masterClockChanged(long newValue) {
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

