/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.gpio;

import com.oceanoptics.omnidriver.features.FPGAImpl;
import com.oceanoptics.omnidriver.features.gpio.GPIOGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import java.io.IOException;
import java.util.BitSet;

public class GPIOImpl
extends FPGAImpl
implements GPIOGUIProvider {
    protected String featurePath = "gpio.GPIOPanel";
    private int numberOfPins = 0;
    private int bitmask = 0;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;I)V\ngetTotalGPIOBits,()I\ngetDirectionBits,()Ljava/util/BitSet;\ngetMuxBits,()Ljava/util/BitSet;\ngetValueBits,()Ljava/util/BitSet;\ngetValueBit,(I)I\ngetNumberOfPins,()I\nsetMuxAllBits,(Ljava/util/BitSet;)V\nsetValueAllBits,(Ljava/util/BitSet;)V\nsetDirectionAllBits,(Ljava/util/BitSet;)V\nsetDirectionBit,(IZ)V\nsetDirectionBitmask,(S)V\nsetMuxBit,(IZ)V\nsetMuxBitmask,(S)V\nsetValueBit,(IZ)V\nsetValueBitmask,(S)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public GPIOImpl(USBInterface usbInt, int numPins) {
        super(usbInt);
        this.numberOfPins = numPins;
        for (int i = 0; i < numPins; ++i) {
            this.bitmask |= 1 << i;
        }
    }

    public int getTotalGPIOBits() {
        return this.numberOfPins;
    }

    public BitSet getDirectionBits() throws IOException {
        short bits = this.formatGPIO(this.getFPGA((byte)80));
        return this.createBitSet(bits, this.numberOfPins);
    }

    public BitSet getMuxBits() throws IOException {
        short bits = this.formatGPIO(this.getFPGA((byte)72));
        return this.createBitSet(bits, this.numberOfPins);
    }

    public BitSet getValueBits() throws IOException {
        short bits = this.formatGPIO(this.getFPGA((byte)84));
        return this.createBitSet(bits, this.numberOfPins);
    }

    public int getValueBit(int bitNumber) throws IOException {
        BitSet bitset = this.getValueBits();
        return bitset.get(bitNumber) ? 1 : 0;
    }

    public int getNumberOfPins() {
        return this.numberOfPins;
    }

    private void writeBits(byte dest, short value) throws IOException {
        if (value > (1 << this.numberOfPins) - 1 || value < 0) {
            this.logger.severe("GPIO register must be between 0-" + ((1 << this.numberOfPins) - 1));
            throw new IllegalArgumentException("GPIO register must be between 0-" + ((1 << this.numberOfPins) - 1));
        }
        this.setFPGA(dest, this.formatGPIO(value));
    }

    private void writeBit(int bit, boolean value, byte register) throws IOException {
        short vector = this.formatGPIO(this.getFPGA(register));
        vector = false == value ? (short)(vector & ~(1 << bit)) : (short)(vector | 1 << bit);
        this.setFPGA(register, vector);
    }

    public void setMuxAllBits(BitSet bitSet) throws IOException {
        short value = this.bitSetToShort(bitSet);
        this.writeBits((byte)72, this.formatGPIO(value));
        this.logger.fine("GPIO mux set to: " + value);
    }

    public void setValueAllBits(BitSet bitSet) throws IOException {
        short value = this.bitSetToShort(bitSet);
        this.writeBits((byte)84, this.formatGPIO(value));
        this.logger.fine("GPIO value set to: " + value);
    }

    public void setDirectionAllBits(BitSet bitSet) throws IOException {
        short value = this.bitSetToShort(bitSet);
        this.writeBits((byte)80, this.formatGPIO(value));
        this.logger.fine("GPIO directions have been set to " + value);
    }

    public void setDirectionBit(int bit, boolean value) throws IOException {
        this.writeBit(bit, value, (byte)80);
        this.logger.fine("GPIO direction " + bit + " has been set to " + value);
    }

    public void setDirectionBitmask(short value) throws IOException {
        this.writeBits((byte)80, this.formatGPIO(value));
        this.logger.fine("GPIO directions have been set to " + value);
    }

    public void setMuxBit(int bit, boolean value) throws IOException {
        this.writeBit(bit, value, (byte)72);
        this.logger.fine("GPIO mux " + bit + " has been set to " + value);
    }

    public void setMuxBitmask(short value) throws IOException {
        this.writeBits((byte)72, this.formatGPIO(value));
        this.logger.fine("GPIO mux set to: " + value);
    }

    public void setValueBit(int bit, boolean value) throws IOException {
        this.writeBit(bit, value, (byte)84);
        this.logger.fine("GPIO value " + bit + " has been set to " + value);
    }

    public void setValueBitmask(short value) throws IOException {
        this.writeBits((byte)84, this.formatGPIO(value));
        this.logger.fine("GPIO value set to: " + value);
    }

    private short formatGPIO(int gpio) {
        return (short)(gpio & this.bitmask);
    }

    private BitSet createBitSet(short bits, int length) {
        BitSet bs = new BitSet(length);
        for (int i = 0; i < length; ++i) {
            bs.set(i, (bits & 1 << i) > 0);
        }
        return bs;
    }

    private short bitSetToShort(BitSet bs) {
        short retval = 0;
        if (bs.size() > 16) {
            throw new IllegalArgumentException("BitSet too large for 16 bit field (" + bs.size() + " > 16)");
        }
        for (int i = 0; i < bs.size(); ++i) {
            if (!bs.get(i)) continue;
            retval = (short)(retval | 1 << i);
        }
        return retval;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

