/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.gpio;

import com.oceanoptics.omnidriver.features.gpio.GPIOImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.sts.OceanBinaryProtocolMessage;
import com.oceanoptics.omnidriver.spectrometer.sts.STS;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.util.BitSet;

public class GPIOImpl_STS
extends GPIOImpl {
    private static final int NUMBER_OF_GPIO = 4;
    private int bitmask;
    protected STS spectrometer;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/sts/STS;Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetValueBits,()Ljava/util/BitSet;\ngetValueBit,(I)I\nsetValueAllBits,(Ljava/util/BitSet;)V\nsetValueBitmask,(S)V\nsetValueBit,(IZ)V\ngetDirectionBits,()Ljava/util/BitSet;\nsetDirectionAllBits,(Ljava/util/BitSet;)V\nsetDirectionBitmask,(S)V\nsetDirectionBit,(IZ)V\ngetMuxBits,()Ljava/util/BitSet;\ngetNumberOfPins,()I\nsetMuxAllBits,(Ljava/util/BitSet;)V\nsetMuxBitmask,(S)V\nsetMuxBit,(IZ)V\ngetTotalGPIOBits,()I\n";

    public GPIOImpl_STS(STS sts, USBInterface usbInt) {
        super(usbInt, 4);
        this.spectrometer = sts;
        this.bitmask = 0;
        for (int i = 0; i < 4; ++i) {
            this.bitmask |= 1 << i;
        }
    }

    protected short formatGPIO(short gpio) {
        return (short)(gpio & this.bitmask);
    }

    private static BitSet createBitSet(short bits, int length) {
        BitSet bs = new BitSet(length);
        for (int i = 0; i < length; ++i) {
            bs.set(i, (bits & 1 << i) > 0);
        }
        return bs;
    }

    private static short bitSetToShort(BitSet bs) {
        short retval = 0;
        if (bs.size() > 16) {
            throw new IllegalArgumentException("BitSet too large for 16 bit field (" + bs.size() + " > 16)");
        }
        for (int i = 0; i < bs.size(); ++i) {
            if (!bs.get(i)) continue;
            retval = (short)(retval | 1 << i);
        }
        return retval;
    }

    private short readValueBits() throws IOException {
        byte[] data = this.spectrometer.queryDevice(0x200300, null);
        if (null == data || data.length < 1) {
            return 0;
        }
        return ByteRoutines.makeWord((byte)0, (byte)data[0]);
    }

    private short readDirectionBits() throws IOException {
        byte[] data = this.spectrometer.queryDevice(0x200100, null);
        if (null == data || data.length < 1) {
            return 0;
        }
        return ByteRoutines.makeWord((byte)0, (byte)data[0]);
    }

    public BitSet getValueBits() throws IOException {
        return GPIOImpl_STS.createBitSet(this.readValueBits(), 4);
    }

    public int getValueBit(int bitNumber) throws IOException {
        BitSet bitset = this.getValueBits();
        return bitset.get(bitNumber) ? 1 : 0;
    }

    public void setValueAllBits(BitSet bitSet) throws IOException {
        short value = GPIOImpl_STS.bitSetToShort(bitSet);
        this.setValueBitmask(value);
    }

    public void setValueBitmask(short value) throws IOException {
        byte[] payload = new byte[8];
        payload[0] = ByteRoutines.getLowByte((short)value);
        payload[1] = ByteRoutines.getHighByte((short)value);
        payload[4] = ByteRoutines.getLowByte((short)((short)this.bitmask));
        payload[5] = ByteRoutines.getHighByte((short)((short)this.bitmask));
        boolean success = this.spectrometer.sendCommandToDevice(2097936, payload);
        if (!success) {
            throw new IOException("Failed to set GPIO value bits.");
        }
    }

    public void setValueBit(int bit, boolean value) throws IOException {
        short current = this.readValueBits();
        current = true == value ? (short)(current | 1 << bit) : (short)(current & ~(1 << bit));
        this.setValueBitmask(current);
    }

    public BitSet getDirectionBits() throws IOException {
        return GPIOImpl_STS.createBitSet(this.readDirectionBits(), 4);
    }

    public void setDirectionAllBits(BitSet bitSet) throws IOException {
        OceanBinaryProtocolMessage request = new OceanBinaryProtocolMessage();
        request.setMessageType(0x200100);
        short value = GPIOImpl_STS.bitSetToShort(bitSet);
        this.setDirectionBitmask(value);
    }

    public void setDirectionBitmask(short value) throws IOException {
        byte[] payload = new byte[8];
        payload[0] = ByteRoutines.getLowByte((short)value);
        payload[1] = ByteRoutines.getHighByte((short)value);
        payload[4] = ByteRoutines.getLowByte((short)((short)this.bitmask));
        payload[5] = ByteRoutines.getHighByte((short)((short)this.bitmask));
        boolean success = this.spectrometer.sendCommandToDevice(0x200110, payload);
        if (!success) {
            throw new IOException("Failed to set GPIO output enables.");
        }
    }

    public void setDirectionBit(int bit, boolean value) throws IOException {
        short current = this.readDirectionBits();
        current = true == value ? (short)(current | 1 << bit) : (short)(current & ~(1 << bit));
        this.setDirectionBitmask(current);
    }

    public BitSet getMuxBits() throws IOException {
        return GPIOImpl_STS.createBitSet((short)0, 4);
    }

    public int getNumberOfPins() {
        return 4;
    }

    public void setMuxAllBits(BitSet bitSet) throws IOException {
    }

    public void setMuxBitmask(short bitmask) throws IOException {
    }

    public void setMuxBit(int bit, boolean value) throws IOException {
    }

    public int getTotalGPIOBits() {
        return 4;
    }
}

