/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.i2cbus;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.sha.SHAConstants;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import java.io.IOException;
import java.util.Vector;

public class I2CBusImpl_SHA
extends USBFeature
implements I2CBusGUIProvider {
    private int[][] rawIntData;
    protected String featurePath = "i2cbus.I2CPanel";
    private SHAConstants consts;
    private Spectrometer spectrometer;
    private static final short DATA_OUT = 1;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    public USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
    public USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\ngetI2CBytes,(BB)[B\nsetI2CBytes,(BB[B)I\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public I2CBusImpl_SHA(USBInterface usbInt, Spectrometer spectrometer) {
        super(usbInt);
        this.spectrometer = spectrometer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getI2CBytes(byte address, byte numBytes) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                numBytes = address > 61 ? (byte)60 : (byte)(address - 1);
                byte[] i2C = new byte[numBytes];
                this.out[0] = 96;
                this.out[1] = address;
                this.out[2] = address;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, address + 3);
                if (this.in[1] == address) {
                    for (int i = 4; i < numBytes + 4; ++i) {
                        i2C[i - 4] = this.in[i];
                    }
                } else {
                    this.logger.warning("I2C: invalid I2C address.");
                }
                this.logger.fine("Performed a read on the I2C pins.");
                // ** MonitorExit[var4_4] (shouldn't be in output)
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return i2C;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setI2CBytes(byte address, byte numBytes, byte[] i2C) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                String result = "";
                this.out[0] = 97;
                this.out[1] = address;
                this.out[2] = numBytes;
                for (int i = 3; i < numBytes + 3; ++i) {
                    this.out[i] = i2C[i - 3];
                }
                this.usb.bulkOut(this.dataOutEndPoint, this.out, numBytes + 3);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 1);
                switch (this.in[0]) {
                    case 0: {
                        result = "I2C bus idle";
                        break;
                    }
                    case 1: {
                        result = "I2C bus Sending Data";
                        break;
                    }
                    case 2: {
                        result = "I2C bus Receiving Data";
                        break;
                    }
                    case 3: {
                        result = "I2C bus Receiving first byte of string";
                        break;
                    }
                    case 5: {
                        result = "I2C bus in waiting for STOP condition";
                        break;
                    }
                    case 6: {
                        result = "I2C experienced Bit Error";
                        break;
                    }
                    case 7: {
                        result = "I2C experienced a Not Acknowledge (NAK) Condition";
                        break;
                    }
                    case 8: {
                        result = "I2C experienced successful transfer";
                        break;
                    }
                    case 9: {
                        result = "I2C bus timed out";
                        break;
                    }
                    default: {
                        result = "Error in writing to the I2C bus";
                    }
                }
                this.logger.fine("Set I2C: " + result);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return this.in[0];
            }
        }
    }

    public String[] getFeatureGUIClassnames() {
        Vector<String> features = new Vector<String>();
        features.add(this.panelPath + "." + this.featurePath);
        return features.toArray(new String[0]);
    }
}

