/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.irradiancecalibrationfactor;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public abstract class IrradianceCalibrationFactorImpl
extends USBFeature
implements IrradianceCalibrationFactorGUIProvider {
    protected String featurePath = "irradiancecalibrationfactor.IrradianceCalibrationFactorPanel";
    public USBEndpointDescriptor dataOutEndPoint = null;
    public USBEndpointDescriptor lowSpeedInEndPoint = null;
    private static final int BLOCK_TRANSFER_SIZE = 60;
    protected int numberOfPixels;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;I)V\ngetIrradianceCalibrationFactors,()[D\nsetIrradianceCalibrationFactors,([D)V\nhasCollectionArea,()Z\ngetCollectionArea,()D\nsetCollectionArea,(D)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public IrradianceCalibrationFactorImpl(USBInterface usbInt, int pixelCount) {
        super(usbInt);
        this.numberOfPixels = pixelCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getIrradianceCalibrationFactors() throws IOException {
        int bytesLeft = this.numberOfPixels * 4;
        double[] retval = new double[this.numberOfPixels];
        int factorIndex = 0;
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                for (int addr = 0; bytesLeft > 0 && addr < 65476; addr += 60, bytesLeft -= 60) {
                    byte[] b = new byte[60];
                    this.out[0] = 109;
                    this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)addr));
                    this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)addr));
                    this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
                    this.usb.bulkIn(this.lowSpeedInEndPoint, b, 60);
                    for (int i = 0; i < b.length && factorIndex < retval.length; i += 4, ++factorIndex) {
                        int temp = ByteRoutines.makeDWord((byte)b[i], (byte)b[i + 1], (byte)b[i + 2], (byte)b[i + 3]);
                        float value = Float.intBitsToFloat(temp);
                        retval[factorIndex] = value;
                    }
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIrradianceCalibrationFactors(double[] data) throws IOException {
        if (null == data || data.length == 0) {
            return;
        }
        byte[] byArray = this.out;
        synchronized (this.out) {
            int factorIndex = 0;
            for (int addr = 0; addr < 65476 && factorIndex < data.length; addr += 60) {
                byte[] b = new byte[63];
                b[0] = 110;
                b[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)addr));
                b[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)addr));
                for (int i = 0; i < 60 && factorIndex < data.length; i += 4, ++factorIndex) {
                    int temp = Float.floatToIntBits((float)data[factorIndex]);
                    b[i + 3] = (byte)(temp >> 24 & 0xFF);
                    b[i + 4] = (byte)(temp >> 16 & 0xFF);
                    b[i + 5] = (byte)(temp >> 8 & 0xFF);
                    b[i + 6] = (byte)(temp & 0xFF);
                }
                this.usb.bulkOut(this.dataOutEndPoint, b, 63);
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException e) {
                    this.logger.severe("EEPROM write might not have completed. Please verify.");
                    throw new IOException("EEPROM write might not have completed. Please verify.");
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean hasCollectionArea() {
        return false;
    }

    public double getCollectionArea() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCollectionArea(double area) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

