/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.nonlinearitycorrection;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import java.io.IOException;

public class NonlinearityCorrectionImpl
extends USBFeature
implements NonlinearityCorrectionGUIProvider {
    private Spectrometer spectrometer = null;
    private int numChannels = 0;
    private Coefficients[] coefficients = null;
    protected String featurePath = "nonlinearitycorrection.NonlinearityCorrectionPanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public NonlinearityCorrectionImpl(USBInterface usbInt, Spectrometer s) {
        super(usbInt);
        this.spectrometer = s;
        this.numChannels = this.spectrometer.getNumberOfChannels();
        this.coefficients = new Coefficients[this.numChannels];
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        for (int i = 0; i < this.numChannels; ++i) {
            if (channels != null && null != channels[i]) {
                try {
                    this.spectrometer.getCoefficientsFromSpectrometer();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.coefficients[i] = new Coefficients(channels[i].getCoefficients());
                continue;
            }
            if (null != this.coefficients[i]) continue;
            this.coefficients[i] = new Coefficients(this.getDisabledChannelsCoefficients(i));
        }
        return this.coefficients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] c) throws IOException {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.setNonlinearityCoefficients(c);
                for (int i = 0; i < this.numChannels; ++i) {
                    if (channels != null && null != channels[i]) {
                        channels[i].setNonlinearityCoefficients();
                        channels[i].setSpectrometerChannelInfoCoefficients(c[i]);
                        continue;
                    }
                    this.setDisabledChannelsCoefficients(i, c[i]);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return;
        }
    }

    public Coefficients[] getNonlinearityCoefficients() {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        Coefficients[] c = new Coefficients[this.numChannels];
        for (int i = 0; i < this.numChannels; ++i) {
            c[i] = channels != null && null != channels[i] ? channels[i].getCoefficients() : this.coefficients[i];
        }
        return c;
    }

    public void setNonlinearityCoefficients(Coefficients[] c) {
        Coefficients[] temp = new Coefficients[c.length];
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        for (int i = 0; i < c.length; ++i) {
            temp[i] = new Coefficients(c[i]);
            if (channels != null && null != channels[i]) {
                channels[i].setCoefficients(temp[i]);
                channels[i].setSpectrometerChannelInfoCoefficients(temp[i]);
                continue;
            }
            this.coefficients[i] = temp[i];
        }
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int channelIndex) {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        if (channelIndex >= channels.length) {
            return null;
        }
        double[] nl = channels == null ? this.coefficients[channelIndex].getNlCoefficients() : (null == channels[channelIndex] ? this.coefficients[channelIndex].getNlCoefficients() : channels[channelIndex].getCoefficients().getNlCoefficients());
        return nl;
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int channelIndex) {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        if (channelIndex >= channels.length) {
            return;
        }
        if (channels != null && null != channels[channelIndex]) {
            channels[channelIndex].getCoefficients().setNlCoefficients(nl);
            channels[channelIndex].setSpectrometerChannelInfoCoefficients(channels[channelIndex].getCoefficients());
        } else {
            this.coefficients[channelIndex].setNlCoefficients(nl);
        }
    }

    private Coefficients getDisabledChannelsCoefficients(int channelIndex) {
        Coefficients c = new Coefficients();
        try {
            try {
                c.setNlCoef0(Double.parseDouble(this.spectrometer.getInfo(6)));
                c.setNlCoef1(Double.parseDouble(this.spectrometer.getInfo(7)));
                c.setNlCoef2(Double.parseDouble(this.spectrometer.getInfo(8)));
                c.setNlCoef3(Double.parseDouble(this.spectrometer.getInfo(9)));
                c.setNlCoef4(Double.parseDouble(this.spectrometer.getInfo(10)));
                c.setNlCoef5(Double.parseDouble(this.spectrometer.getInfo(11)));
                c.setNlCoef6(Double.parseDouble(this.spectrometer.getInfo(12)));
                c.setNlCoef7(Double.parseDouble(this.spectrometer.getInfo(13)));
                c.setNlOrder(Integer.parseInt(this.spectrometer.getInfo(14)));
            }
            catch (NumberFormatException nfe) {
                this.logger.warning("ERROR: cannot read nonlinearity coefficients from spectrometer. Setting to zero.");
                c.setNlCoef0(0.0);
                c.setNlCoef1(0.0);
                c.setNlCoef2(0.0);
                c.setNlCoef3(0.0);
                c.setNlCoef4(0.0);
                c.setNlCoef5(0.0);
                c.setNlCoef6(0.0);
                c.setNlCoef7(0.0);
                c.setNlOrder(0);
            }
        }
        catch (IOException io) {
            this.logger.warning("Error getting disabled channel's coefficients.");
        }
        this.coefficients[channelIndex] = c;
        return c;
    }

    private void setDisabledChannelsCoefficients(int channelIndex, Coefficients c) {
        try {
            this.spectrometer.setInfo(6, Double.toString(c.getNlCoef0()));
            this.spectrometer.setInfo(7, Double.toString(c.getNlCoef1()));
            this.spectrometer.setInfo(8, Double.toString(c.getNlCoef2()));
            this.spectrometer.setInfo(9, Double.toString(c.getNlCoef3()));
            this.spectrometer.setInfo(10, Double.toString(c.getNlCoef4()));
            this.spectrometer.setInfo(11, Double.toString(c.getNlCoef5()));
            this.spectrometer.setInfo(12, Double.toString(c.getNlCoef6()));
            this.spectrometer.setInfo(13, Double.toString(c.getNlCoef7()));
            this.spectrometer.setInfo(14, Integer.toString(c.getNlOrder()));
        }
        catch (IOException io) {
            this.logger.warning("Error writing disabled channel's coefficients.");
        }
        this.coefficients[channelIndex] = c;
    }

    private SpectrometerChannel[] getChannels() {
        return this.spectrometer.getChannels();
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

