/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.saturationthreshold;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.saturationthreshold.SaturationThresholdGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class SaturationThresholdImpl
extends USBFeature
implements SaturationThresholdGUIProvider {
    protected final int MAYA_SATURATION_THRESHOLD_SLOT = 17;
    private int saturationThreshold = -1;
    private boolean isSaturationThresholdLoaded = false;
    private USBSpectrometer spectrometer = null;
    protected String featurePath = "saturationthreshold.SaturationThresholdPanel";
    private static final short DATA_OUT = 1;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    public USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
    public USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/USBSpectrometer;Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetSaturationThreshold,()I\nsetSaturationThreshold,(ILjava/lang/String;)V\nreadSaturationThresholdFromSpectrometer,()I\nwriteSaturationThresholdToSpectrometer,(Ljava/lang/String;)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public SaturationThresholdImpl(USBSpectrometer parentSpectrometer, USBInterface usbInt) {
        super(usbInt);
        this.spectrometer = parentSpectrometer;
        this.saturationThreshold = -1;
        this.isSaturationThresholdLoaded = false;
    }

    public int getSaturationThreshold() {
        if (!this.isSaturationThresholdLoaded) {
            try {
                this.saturationThreshold = this.readSaturationThresholdFromSpectrometer();
                this.isSaturationThresholdLoaded = true;
            }
            catch (IOException exception) {
                this.saturationThreshold = this.spectrometer.getMaxIntensity();
                this.isSaturationThresholdLoaded = false;
            }
        }
        return this.saturationThreshold;
    }

    public void setSaturationThreshold(int newSaturationThreshold, String key) {
        if (key.compareTo("wpT379hLw") != 0) {
            return;
        }
        this.saturationThreshold = newSaturationThreshold;
        try {
            this.writeSaturationThresholdToSpectrometer(key);
        }
        catch (IOException exception) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readSaturationThresholdFromSpectrometer() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = 5;
                this.out[1] = 17;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                this.saturationThreshold = ByteRoutines.makeWord((byte)this.in[3], (byte)this.in[2]);
                this.saturationThreshold &= 0xFFFF;
                if (this.saturationThreshold <= 32768 || this.saturationThreshold > this.spectrometer.getMaxIntensity()) {
                    this.saturationThreshold = this.spectrometer.getMaxIntensity();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return this.saturationThreshold;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSaturationThresholdToSpectrometer(String key) throws IOException {
        if (key.compareTo("wpT379hLw") != 0) {
            return;
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = 6;
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)17));
                this.out[2] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)this.saturationThreshold));
                this.out[3] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)this.saturationThreshold));
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 17);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    this.logger.severe("EEPROM write might not have completed. Please verify.");
                    throw new IOException("EEPROM write might not have completed. Please verify.");
                }
            }
            return;
        }
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

