/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.straylightcorrection;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import java.io.IOException;

public class StrayLightCorrectionImpl
extends USBFeature
implements StrayLightCorrectionGUIProvider {
    private Spectrometer spectrometer = null;
    private Coefficients[] coefficients = null;
    private int numChannels = 0;
    protected String featurePath = "straylightcorrection.StrayLightCorrectionPanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLight,(I)D\ngetStrayLightSlope,(I)D\nsetStrayLight,(DI)V\nsetStrayLight,(DDI)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public StrayLightCorrectionImpl(USBInterface usbInt, Spectrometer s) {
        super(usbInt);
        this.spectrometer = s;
        this.numChannels = this.spectrometer.getNumberOfChannels();
        this.coefficients = new Coefficients[this.numChannels];
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        for (int i = 0; i < this.numChannels; ++i) {
            if (channels != null && null != channels[i]) {
                this.coefficients[i] = new Coefficients(channels[i].getCoefficients());
                continue;
            }
            if (null != this.coefficients[i]) continue;
            this.coefficients[i] = new Coefficients(this.getDisabledChannelsCoefficients(i));
        }
        return this.coefficients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] c) throws IOException {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.setStrayLightCorrectionCoefficient(c);
                for (int i = 0; i < this.numChannels; ++i) {
                    if (channels != null && null != channels[i]) {
                        channels[i].setStrayLightCorrection();
                        channels[i].setSpectrometerChannelInfoCoefficients(c[i]);
                        continue;
                    }
                    this.setDisabledChannelsCoefficients(i, c[i]);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return;
        }
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.coefficients;
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] c) {
        Coefficients[] temp = new Coefficients[c.length];
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        for (int i = 0; i < c.length; ++i) {
            temp[i] = new Coefficients(c[i]);
            if (channels != null && null != channels[i]) {
                channels[i].setCoefficients(temp[i]);
                channels[i].setSpectrometerChannelInfoCoefficients(temp[i]);
                continue;
            }
            this.coefficients[i] = temp[i];
        }
    }

    public double getStrayLight(int channel) {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        double sl = channels != null && null != channels[channel] ? channels[channel].getCoefficients().getStrayLight() : this.coefficients[channel].getStrayLight();
        return sl;
    }

    public double getStrayLightSlope(int channel) {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        double sl = channels != null && null != channels[channel] ? channels[channel].getCoefficients().getStrayLightSlope() : this.coefficients[channel].getStrayLightSlope();
        return sl;
    }

    public void setStrayLight(double sl, int channel) {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        if (channels != null && null != channels[channel]) {
            channels[channel].getCoefficients().setStrayLight(sl);
            channels[channel].setSpectrometerChannelInfoCoefficients(channels[channel].getCoefficients());
        } else {
            this.coefficients[channel].setStrayLight(sl);
        }
    }

    public void setStrayLight(double intercept, double slope, int channel) {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        if (channels != null && null != channels[channel]) {
            channels[channel].getCoefficients().setStrayLight(intercept, slope);
            channels[channel].setSpectrometerChannelInfoCoefficients(channels[channel].getCoefficients());
        } else {
            this.coefficients[channel].setStrayLight(intercept, slope);
        }
    }

    private Coefficients getDisabledChannelsCoefficients(int channelIndex) {
        Coefficients c = new Coefficients();
        try {
            try {
                c.setStrayLight(Double.parseDouble(this.spectrometer.getInfo(5)));
            }
            catch (NumberFormatException nfe) {
                this.logger.info("ERROR: cannot read stray light coefficient from spectrometer. Setting to zero.");
                this.logger.info("Value was [" + this.spectrometer.getInfo(5) + "]");
                c.setStrayLight(0.0);
            }
        }
        catch (IOException io) {
            this.logger.warning("Error getting disabled channel's coefficients.");
        }
        this.coefficients[channelIndex] = c;
        return c;
    }

    private void setDisabledChannelsCoefficients(int channelIndex, Coefficients c) {
        try {
            this.spectrometer.setInfo(5, Double.toString(c.getStrayLight()));
        }
        catch (IOException io) {
            this.logger.warning("Error writing disabled channel's coefficients.");
        }
        this.coefficients[channelIndex] = c;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

