/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.thermoelectric;

import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricImpl_QE65000;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class ThermoElectricImpl_NIRQuest
extends ThermoElectricImpl_QE65000 {
    private int saturationIntensity;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetSaturationIntensity,()I\nsetSaturationIntensity,(ILjava/lang/String;)Z\nsetDetectorSetPointCelsius,(D)V\n";

    public ThermoElectricImpl_NIRQuest(USBInterface usbInt) throws IOException {
        super(usbInt);
    }

    public int getSaturationIntensity() {
        return this.saturationIntensity;
    }

    public boolean setSaturationIntensity(int newSaturationIntensity, String key) {
        if (key.compareTo("wpT379hLw") != 0) {
            return false;
        }
        this.saturationIntensity = newSaturationIntensity;
        try {
            this.persistTECState();
        }
        catch (IOException exception) {
            return false;
        }
        return true;
    }

    public void setDetectorSetPointCelsius(double tempCelsius) throws IOException {
        boolean tecEnabledInitially = this.getTECEnable();
        if (tecEnabledInitially) {
            this.setTECEnable(false, false);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        super.setDetectorSetPointCelsius(tempCelsius);
        this.setFanEnable(true);
        if (tecEnabledInitially) {
            this.setTECEnable(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTECState() throws IOException {
        byte[] tecState = new byte[15];
        this.saturationIntensity = -1;
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = 5;
                this.out[1] = 17;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                if (this.in[2] != 0 && this.in[2] != 1 || this.in[3] != 0 && this.in[3] != 1) {
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                for (int i = 2; i < 17; ++i) {
                    tecState[i - 2] = this.in[i];
                }
                // ** MonitorExit[var3_5] (shouldn't be in output)
            }
            {
                try {
                    this.tecEnabled = new Boolean((tecState[0] & 1) != 0);
                    this.fanEnabled = new Boolean((tecState[1] & 1) != 0);
                    double sp = ByteRoutines.makeWord((byte)tecState[3], (byte)tecState[2]);
                    if (sp != 0.0) {
                        sp /= 10.0;
                    }
                    this.setPoint = new Double(sp);
                    this.setTECEnable(this.tecEnabled);
                    this.setFanEnable(this.fanEnabled);
                    this.saturationIntensity = ByteRoutines.makeDWord((byte)tecState[7], (byte)tecState[6], (byte)tecState[5], (byte)tecState[4]);
                    if (this.saturationIntensity <= 0 || this.saturationIntensity > 65535) {
                        this.saturationIntensity = 65535;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistTECState() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.out[0] = 5;
                this.out[1] = 17;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                for (int jj = 0; jj < 17; ++jj) {
                    this.out[jj] = this.in[jj];
                }
                short sp = (short)(this.setPoint * 10.0);
                this.out[0] = 6;
                this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)17));
                this.out[2] = this.tecEnabled != false ? (byte)1 : 0;
                this.out[3] = this.fanEnabled != false ? (byte)1 : 0;
                this.out[4] = ByteRoutines.getLowByte((short)sp);
                this.out[5] = ByteRoutines.getHighByte((short)sp);
                this.out[6] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)this.saturationIntensity));
                this.out[7] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)this.saturationIntensity));
                this.out[8] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)this.saturationIntensity));
                this.out[9] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)this.saturationIntensity));
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 17);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    this.logger.severe("EEPROM write might not have completed. Please verify.");
                    throw new IOException("EEPROM write might not have completed. Please verify.");
                }
            }
            return;
        }
    }
}

