/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.uvvislightsource;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.uvvislightsource.UV_VIS_LightSourceGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import java.io.IOException;

public abstract class UV_VIS_LightSourceImpl
extends USBFeature
implements UV_VIS_LightSourceGUIProvider {
    protected USBEndpointDescriptor dataOutEndPoint = null;
    protected USBEndpointDescriptor lowSpeedInEndPoint = null;
    private final int MIN_INTENSITY = 0;
    private final int MAX_INTENSITY = 63;
    private final int INTENSITY_STEP = 1;
    protected String featurePath = "uvvislightsource.UV_VIS_LightSourcePanel";
    protected static final byte POT_VISINTENSITY = 0;
    protected static final byte POT_UVINTENSITY = 1;
    protected static final byte POT_VISPOWER = 2;
    protected static final byte POT_BOTHPOWER = 3;
    protected static final byte POT_MAX = 63;
    protected static final byte POT_MIN = 0;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\nsetLampOn,(Z)V\nisLampOn,()Z\nisVisLampOn,()Z\nsetVisLampOn,(Z)V\ngetVisLampIntensity,()S\nsetVisLampIntensity,(S)V\nsetUVLampIntensity,(S)V\ngetUVLampIntensity,()S\nsetPowerUpPOTValues,()V\ngetPOTValues,()[B\nsetPOTValue,(II)V\ngetLampIntensityMinimum,()I\ngetLampIntensityMaximum,()I\ngetLampIntensityIncrement,()I\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public UV_VIS_LightSourceImpl(USBInterface usbInt) {
        super(usbInt);
    }

    public void setLampOn(boolean lampOn) throws IOException {
        if (lampOn) {
            this.setPOTValue(3, 63);
        } else {
            this.setPOTValue(3, 0);
        }
    }

    public boolean isLampOn() throws IOException {
        byte[] potValues = this.getPOTValues();
        return potValues[3] == 0;
    }

    public boolean isVisLampOn() throws IOException {
        byte[] potValues = this.getPOTValues();
        return potValues[2] == 0;
    }

    public void setVisLampOn(boolean lampOn) throws IOException {
        if (lampOn) {
            this.setPOTValue(2, 63);
        } else {
            this.setPOTValue(2, 0);
        }
    }

    public short getVisLampIntensity() throws IOException {
        byte[] potValues = this.getPOTValues();
        return potValues[0];
    }

    public void setVisLampIntensity(short intens) throws IOException {
        if (intens > 63) {
            intens = (short)63;
        }
        if (intens < 0) {
            intens = 0;
        }
        this.setPOTValue(0, intens);
    }

    public void setUVLampIntensity(short intens) throws IOException {
        if (intens > 63) {
            intens = (short)63;
        }
        if (intens < 0) {
            intens = 0;
        }
        this.setPOTValue(1, intens);
    }

    public short getUVLampIntensity() throws IOException {
        byte[] potValues = this.getPOTValues();
        return potValues[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPowerUpPOTValues() throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 65;
            this.out[1] = 1;
            this.out[2] = -128;
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            try {
                Thread.sleep(350L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("Set power-up pot values.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPOTValues() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                byte[] values = new byte[4];
                this.out[0] = 66;
                this.out[1] = 0;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                this.usb.bulkIn(this.lowSpeedInEndPoint, values, 4);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return values;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPOTValue(int pot, int value) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            if (pot > 0 || pot < 3) {
                this.out[0] = 64;
                this.out[1] = (byte)pot;
                this.out[2] = (byte)value;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                throw new IllegalArgumentException("Invaild POT value. Must be between 0-3.");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public int getLampIntensityMinimum() {
        return 0;
    }

    public int getLampIntensityMaximum() {
        return 63;
    }

    public int getLampIntensityIncrement() {
        return 1;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

