/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.wavelengthcalibration;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import java.io.IOException;

public class WavelengthCalibrationImpl
extends USBFeature
implements WavelengthCalibrationGUIProvider {
    private Spectrometer spectrometer = null;
    private Coefficients[] coefficients = null;
    private int numChannels = 0;
    protected String featurePath = "wavelengthcalibration.WavelengthCalibrationPanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public WavelengthCalibrationImpl(USBInterface usbInt, Spectrometer s) {
        super(usbInt);
        this.spectrometer = s;
        this.numChannels = this.spectrometer.getNumberOfChannels();
        this.coefficients = new Coefficients[this.numChannels];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] c) throws IOException {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.setWavelengthCalibrationCoefficients(c);
                for (int i = 0; i < this.numChannels; ++i) {
                    if (channels != null && null != channels[i]) {
                        channels[i].setWavelengthCalibration();
                        channels[i].setSpectrometerChannelInfoCoefficients(c[i]);
                        continue;
                    }
                    this.setDisabledChannelsCoefficients(i, c[i]);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
            return;
        }
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        for (int i = 0; i < this.numChannels; ++i) {
            if (channels != null && null != channels[i]) {
                try {
                    this.spectrometer.getCoefficientsFromSpectrometer();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.coefficients[i] = new Coefficients(channels[i].getCoefficients());
                continue;
            }
            if (null != this.coefficients[i]) continue;
            this.coefficients[i] = new Coefficients(this.getDisabledChannelsCoefficients(i));
        }
        return this.coefficients;
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] c) {
        Coefficients[] temp = new Coefficients[c.length];
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        for (int i = 0; i < c.length; ++i) {
            temp[i] = new Coefficients(c[i]);
            if (channels != null && null != channels[i]) {
                channels[i].setCoefficients(temp[i]);
                channels[i].setSpectrometerChannelInfoCoefficients(temp[i]);
                continue;
            }
            this.coefficients[i] = temp[i];
        }
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        Coefficients[] c = new Coefficients[this.numChannels];
        for (int i = 0; i < this.numChannels; ++i) {
            c[i] = channels != null && null != channels[i] ? channels[i].getCoefficients() : this.coefficients[i];
        }
        return c;
    }

    public double[] getWavelengths(int channel) {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        double[] wl = channels != null && null != channels[channel] ? channels[channel].getCoefficients().getWlCoefficients() : this.coefficients[channel].getWlCoefficients();
        return wl;
    }

    public void setWavelengths(double[] wl, int channel) {
        SpectrometerChannel[] channels = this.spectrometer.getChannels();
        if (channels != null && null != channels[channel]) {
            channels[channel].getCoefficients().setWlCoefficients(wl);
            channels[channel].setSpectrometerChannelInfoCoefficients(channels[channel].getCoefficients());
        } else {
            this.coefficients[channel].setWlCoefficients(wl);
        }
    }

    private Coefficients getDisabledChannelsCoefficients(int channelIndex) {
        Coefficients c = new Coefficients();
        int multiplier = 0;
        if (1 < this.numChannels) {
            multiplier = 1 + channelIndex * 4;
        }
        try {
            try {
                c.setWlIntercept(Double.parseDouble(this.spectrometer.getInfo(1 + multiplier)));
                c.setWlFirst(Double.parseDouble(this.spectrometer.getInfo(2 + multiplier)));
                c.setWlSecond(Double.parseDouble(this.spectrometer.getInfo(3 + multiplier)));
                c.setWlThird(Double.parseDouble(this.spectrometer.getInfo(4 + multiplier)));
            }
            catch (NumberFormatException nfe) {
                c.setWlIntercept(0.0);
                c.setWlFirst(1.0);
                c.setWlSecond(0.0);
                c.setWlThird(0.0);
                this.logger.warning("ERROR: " + nfe.getMessage());
                this.logger.warning("ERROR: cannot read wavelength coefficients from spectrometer. Setting to pixel indices.");
                this.logger.warning("Intercept was [" + this.spectrometer.getInfo(1 + multiplier) + "]");
                this.logger.warning("First was [" + this.spectrometer.getInfo(2 + multiplier) + "]");
                this.logger.warning("Second was [" + this.spectrometer.getInfo(3 + multiplier) + "]");
                this.logger.warning("Third was [" + this.spectrometer.getInfo(4 + multiplier) + "]");
            }
        }
        catch (IOException io) {
            this.logger.warning("Error getting disabled channel's coefficients.");
        }
        this.coefficients[channelIndex] = c;
        return c;
    }

    private void setDisabledChannelsCoefficients(int channelIndex, Coefficients c) {
        int multiplier = 0;
        if (1 < this.numChannels) {
            multiplier = 1 + channelIndex * 4;
        }
        try {
            this.spectrometer.setInfo(1 + multiplier, Double.toString(c.getWlIntercept()));
            this.spectrometer.setInfo(2 + multiplier, Double.toString(c.getWlFirst()));
            this.spectrometer.setInfo(3 + multiplier, Double.toString(c.getWlSecond()));
            this.spectrometer.setInfo(4 + multiplier, Double.toString(c.getWlThird()));
        }
        catch (IOException io) {
            this.logger.warning("Error writing disabled channel's coefficients.");
        }
        this.coefficients[channelIndex] = c;
    }

    private SpectrometerChannel[] getChannels() {
        return this.spectrometer.getChannels();
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

