/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.hr2000;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImplNonFPGA;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBus;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusGUIProvider;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImpl;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImplNonFPGA;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImpl;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImplNonFPGA;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.version.Version;
import com.oceanoptics.omnidriver.features.version.VersionGUIProvider;
import com.oceanoptics.omnidriver.features.version.VersionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionListener;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBEndpointDevice;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.File;
import java.io.IOException;

public class HR2000
extends USBSpectrometer
implements I2CBus,
PlugInProvider,
HardwareTrigger,
NonlinearityCorrectionProvider,
WavelengthCalibrationProvider,
StrayLightCorrection,
Version,
USBEndpointDevice {
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private PlugInProvider plugInProvider;
    private I2CBusGUIProvider i2c;
    private HardwareTriggerImpl hardwareTrigger;
    private NonlinearityCorrectionGUIProvider nonlinearity;
    private WavelengthCalibrationImpl wavelength;
    private StrayLightCorrectionGUIProvider straylight;
    private VersionGUIProvider version;
    private static final short DATA_OUT = 2;
    private static final short HIGH_SPEED_DATA_IN = 130;
    private static final short UNUSED_DATA_OUT = 7;
    private static final short LOW_SPEED_DATA_IN = 135;
    private static final short MAX_PACKET_SIZE = 64;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(I)V\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\nallowWriteToEEPROM,(II)Z\nopenSpectrometer,(I)V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetActualIntegrationTime,()I\nsetI2CBytes,(BB[B)I\ngetI2CBytes,(BB)[B\nisPlugInDetected,(I)Z\ngetPlugIns,()[Lcom/oceanoptics/omnidriver/plugin/SpectrometerPlugIn;\ngetNumberOfPlugIns,()I\ninitializePlugIns,()[B\ndetectPlugIns,()V\nsetExternalTriggerMode,(I)V\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\ngetExternalTriggerMode,()Ljava/lang/Integer;\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\nisAdvancedVersion,()Z\nuploadFirmware,(Ljava/io/File;J)V\nuploadFPGA,(Ljava/io/File;J)V\naddAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\nremoveAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\n";

    public HR2000() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HR2000(int i) throws IOException {
        this.setEndpoints();
        this.openSpectrometer(i);
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 130, 2, 64, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 7, 2, 64, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 135, 2, 64, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 0: {
                return this.dataOutEndPoint;
            }
            case 1: {
                return this.highSpeedInEndPoint1;
            }
            case 2: {
                return this.highSpeedInEndPoint2;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    public boolean allowWriteToEEPROM(int privilegeLevel, int slot) {
        if (slot < 0) {
            return false;
        }
        if (privilegeLevel == 0) {
            return true;
        }
        if (privilegeLevel == 1) {
            if (slot == 0) {
                return false;
            }
            if (slot == 17 || slot == 18 || slot == 19) {
                return true;
            }
            return slot <= 14;
        }
        return false;
    }

    public void openSpectrometer(int index) throws IOException {
        this.integrationTimeMinimum = 3000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1000;
        this.numberOfCCDPixels = 2048;
        this.numberOfDarkCCDPixels = 24;
        this.maxIntensity = 4095;
        this.pipeSize = this.numberOfCCDPixels * 2 + 1;
        this.rawData = new byte[this.pipeSize];
        this.benchSlot = 15;
        this.spectrometerConfigSlot = 16;
        this.productID = 4106;
        this.usb.openDevice(this.vendorID, this.productID, index);
        this.deviceIndex = index;
        this.initialize();
        this.readSpectrum();
        this.getFirmwareVersion();
        this.channels = new SpectrometerChannel[1];
        this.channels[this.channelIndex] = new SpectrometerChannel(this, new Coefficients(), this.channelIndex);
        this.logger.fine("HR2000 has been opened at index " + index);
        this.initFeatures(this.usb);
        this.finishConstruction();
        this.configuration = new Configuration(this);
    }

    private void initFeatures(USBInterface usb) throws IOException {
        this.i2c = new I2CBusImplNonFPGA(usb);
        this.plugInProvider = new PlugInProviderImplNonFPGA(usb, this);
        this.hardwareTrigger = new HardwareTriggerImplNonFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1), new ExternalTriggerMode(3)});
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.straylight = new StrayLightCorrectionImpl(usb, this);
        this.version = new VersionImpl(usb, this);
        this.featureMap.put(PlugInProviderImpl.class, (PlugInProviderImpl)this.plugInProvider);
        this.featureMap.put(I2CBusImpl.class, (I2CBusImpl)this.i2c);
        this.featureMap.put(HardwareTriggerImpl.class, this.hardwareTrigger);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.featureMap.put(WavelengthCalibrationImpl.class, this.wavelength);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.straylight);
        this.featureMap.put(VersionImpl.class, (VersionImpl)this.version);
    }

    public GUIProvider[] getGUIFeatures() {
        GUIProvider[] features = new GUIProvider[]{this.wavelength, this.straylight, this.nonlinearity, this.i2c, this.version};
        return features;
    }

    protected Spectrum formatData(byte[] data, Spectrum spectrum) throws IOException {
        this.logger.finest("Formatting spectrum...");
        spectrum.setSaturated(false);
        double[] spectrumArray = spectrum.getSpectrum();
        byte zero = 0;
        if (data[this.numberOfCCDPixels * 2] != 105) {
            this.logger.severe("Lost synchronization");
            throw new IOException("Lost synchronization");
        }
        for (int i = spectrumArray.length - 1; i >= 0; --i) {
            int LSBPacket = i >> 6;
            int MSBPacket = LSBPacket + 1;
            byte MSB = data[(MSBPacket << 6) + i];
            byte LSB = data[(LSBPacket << 6) + i];
            int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB) & 0xFFF;
            if (pixel >= this.maxIntensity) {
                spectrum.setSaturated(true);
            }
            spectrumArray[i] = pixel;
        }
        return spectrum;
    }

    public int getActualIntegrationTime() {
        return super.getActualIntegrationTime() * 1024 / 1000;
    }

    public int setI2CBytes(byte address, byte numBytes, byte[] message) throws IOException {
        if (this.firmwareVersionNumber < this.makeVersionNumber(1, 10, 0)) {
            this.logger.severe("Firmware must be greater than 1.10.00");
            throw new UnsupportedOperationException("Firmware must be greater than 1.10.00");
        }
        return this.i2c.setI2CBytes(address, numBytes, message);
    }

    public byte[] getI2CBytes(byte address, byte numBytes) throws IOException {
        if (this.firmwareVersionNumber < this.makeVersionNumber(1, 10, 0)) {
            this.logger.severe("Firmware must be greater than 1.10.00");
            throw new UnsupportedOperationException("Firmware must be greater than 1.10.00");
        }
        return this.i2c.getI2CBytes(address, numBytes);
    }

    public boolean isPlugInDetected(int id) throws IOException {
        return this.plugInProvider.isPlugInDetected(id);
    }

    public SpectrometerPlugIn[] getPlugIns() throws IOException {
        return this.plugInProvider.getPlugIns();
    }

    public int getNumberOfPlugIns() throws IOException {
        return this.plugInProvider.getNumberOfPlugIns();
    }

    public byte[] initializePlugIns() throws IOException {
        return this.plugInProvider.initializePlugIns();
    }

    public void detectPlugIns() throws IOException {
        this.plugInProvider.detectPlugIns();
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public boolean isAdvancedVersion() {
        return this instanceof AdvancedVersion;
    }

    public void uploadFirmware(File file, long fileSize) throws IOException {
        this.version.uploadFirmware(file, fileSize);
    }

    public void uploadFPGA(File file, long fileSize) throws IOException {
        this.version.uploadFPGA(file, fileSize);
    }

    public void addAcquisitionListener(AcquisitionListener listener) {
        this.version.addAcquisitionListener(listener);
    }

    public void removeAcquisitionListener(AcquisitionListener listener) {
        this.version.removeAcquisitionListener(listener);
    }
}

