/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.jaz;

import com.oceanoptics.utilities.ByteRoutines;

public class DispatchProtocolMessage {
    protected static final byte startByte = 2;
    protected byte flags;
    protected short checksum;
    protected long from;
    protected long to;
    protected long messageType;
    protected long regarding;
    protected long sequenceNumber;
    protected long sequelPointer;
    protected long bytesRemaining;
    protected byte[] payload = new byte[0];
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,([B)V\ntoByteStream,()[B\nparseByteStream,([B)I\ngetBytesRemaining,()J\ngetChecksum,()S\ngetFlags,()B\ngetFrom,()J\ngetMessageType,()J\ngetPayload,()[B\ngetRegarding,()J\ngetSequelPointer,()J\ngetSequenceNumber,()J\ngetTo,()J\nsetBytesRemaining,(J)V\nsetFlags,(B)V\nsetFrom,(J)V\nsetMessageType,(J)V\nsetPayload,([B)V\nsetRegarding,(J)V\nsetSequelPointer,(J)V\nsetSequenceNumber,(J)V\nsetTo,(J)V\ntoString,()Ljava/lang/String;\n";

    public DispatchProtocolMessage() {
    }

    public DispatchProtocolMessage(byte[] message) {
        this.parseByteStream(message);
    }

    public byte[] toByteStream() {
        int offset = 0;
        byte[] retval = new byte[32 + this.payload.length];
        retval[offset++] = 2;
        retval[offset++] = this.flags;
        retval[offset++] = ByteRoutines.getLowByte((short)this.checksum);
        retval[offset++] = ByteRoutines.getHighByte((short)this.checksum);
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)((int)this.from)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)((int)this.from)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)((int)this.from)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)((int)this.from)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)((int)this.to)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)((int)this.to)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)((int)this.to)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)((int)this.to)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)((int)this.messageType)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)((int)this.messageType)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)((int)this.messageType)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)((int)this.messageType)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)((int)this.regarding)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)((int)this.regarding)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)((int)this.regarding)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)((int)this.regarding)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)((int)this.sequenceNumber)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)((int)this.sequenceNumber)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)((int)this.sequenceNumber)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)((int)this.sequenceNumber)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)((int)this.sequelPointer)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)((int)this.sequelPointer)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)((int)this.sequelPointer)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)((int)this.sequelPointer)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)((int)this.bytesRemaining)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)((int)this.bytesRemaining)));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)((int)this.bytesRemaining)));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)((int)this.bytesRemaining)));
        int i = 0;
        while (i < this.payload.length) {
            retval[offset] = this.payload[i];
            ++i;
            ++offset;
        }
        return retval;
    }

    public int parseByteStream(byte[] message) {
        block4: {
            block3: {
                if (null == message || message.length < 32) break block3;
                if (2 == message[0]) break block4;
            }
            throw new IllegalArgumentException("Could not parse header.");
        }
        this.flags = message[1];
        this.checksum = ByteRoutines.makeWord((byte)message[3], (byte)message[2]);
        this.from = ByteRoutines.makeDWord((byte)message[7], (byte)message[6], (byte)message[5], (byte)message[4]);
        this.to = ByteRoutines.makeDWord((byte)message[11], (byte)message[10], (byte)message[9], (byte)message[8]);
        this.messageType = ByteRoutines.makeDWord((byte)message[15], (byte)message[14], (byte)message[13], (byte)message[12]);
        this.regarding = ByteRoutines.makeDWord((byte)message[19], (byte)message[18], (byte)message[17], (byte)message[16]);
        this.sequenceNumber = ByteRoutines.makeDWord((byte)message[23], (byte)message[22], (byte)message[21], (byte)message[20]);
        this.sequelPointer = ByteRoutines.makeDWord((byte)message[27], (byte)message[26], (byte)message[25], (byte)message[24]);
        this.bytesRemaining = ByteRoutines.makeDWord((byte)message[31], (byte)message[30], (byte)message[29], (byte)message[28]);
        this.payload = new byte[(int)this.bytesRemaining];
        for (int i = 0; i < this.payload.length; ++i) {
            this.payload[i] = message[i + 32];
        }
        return 32 + this.payload.length;
    }

    public long getBytesRemaining() {
        return this.bytesRemaining;
    }

    public short getChecksum() {
        return this.checksum;
    }

    public byte getFlags() {
        return this.flags;
    }

    public long getFrom() {
        return this.from;
    }

    public long getMessageType() {
        return this.messageType;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public long getRegarding() {
        return this.regarding;
    }

    public long getSequelPointer() {
        return this.sequelPointer;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getTo() {
        return this.to;
    }

    public void setBytesRemaining(long bytesRemaining) {
        this.bytesRemaining = bytesRemaining;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public void setFrom(long from) {
        this.from = from;
    }

    public void setMessageType(long messageType) {
        this.messageType = messageType;
    }

    public void setPayload(byte[] data) {
        if (null == data || 0 == data.length) {
            this.setBytesRemaining(0L);
            this.payload = new byte[0];
        } else {
            this.setBytesRemaining(data.length);
            byte[] pl = new byte[data.length];
            for (int i = 0; i < pl.length; ++i) {
                pl[i] = data[i];
            }
            this.payload = pl;
        }
    }

    public void setRegarding(long regarding) {
        this.regarding = regarding;
    }

    public void setSequelPointer(long sequelPointer) {
        this.sequelPointer = sequelPointer;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setTo(long to) {
        this.to = to;
    }

    public String toString() {
        String retval = new String();
        retval = retval + "startByte: " + 2 + ", from: " + this.from + ", to: " + this.to + ", message type: " + this.messageType + ", bytes remaining: " + this.bytesRemaining;
        retval = retval + "\nPayload:\n";
        for (int i = 0; i < this.payload.length; ++i) {
            if (i % 16 == 0) {
                retval = retval + "0x" + Integer.toHexString(i) + ":\t";
            }
            retval = retval + Integer.toHexString(this.payload[i] & 0xFF) + " ";
            if ((i + 1) % 16 != 0) continue;
            retval = retval + "\n";
        }
        return retval;
    }
}

