/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.mmsraman.features.calibration;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.features.calibration.CalibrationGUIProvider;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.MMSRamanCalibration;
import com.oceanoptics.omnidriver.spectrometer.mmsraman.ramanspectrometer.MMSRamanSpectrometer;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class CalibrationImpl
extends USBFeature
implements CalibrationGUIProvider {
    private MMSRamanCalibration calibration;
    private MMSRamanSpectrometer spectrometer;
    private byte schemaOut = 1;
    private byte schemaIn = 1;
    protected String featurePath = "mmsraman.calibration.CalibrationPanel";
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRamanSpectrometer;)V\nreadCalibrationFromSpectrometer,()V\nwriteCalibrationToSpectrometer,(Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRamanCalibration;)V\ngetCalibration,()Lcom/oceanoptics/omnidriver/spectrometer/mmsraman/ramanspectrometer/MMSRamanCalibration;\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public CalibrationImpl(USBInterface usbInt, MMSRamanSpectrometer spec) throws IOException {
        super(usbInt);
        this.spectrometer = spec;
        this.calibration = new MMSRamanCalibration();
        this.readCalibrationFromSpectrometer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCalibrationFromSpectrometer() throws IOException {
        if (this.spectrometer.getFirmwareVersionNumber() >= 3030) {
            this.schemaOut = (byte)2;
            this.schemaIn = (byte)2;
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                byte[] in = this.spectrometer.process((byte)5, this.schemaOut, this.schemaIn);
                int numberOfMaskIndices = ByteRoutines.makeWordLE((byte)in[64], (byte)in[65]);
                this.calibration.setMaskRatio(ByteRoutines.makeWordLE((byte)in[66], (byte)in[67]));
                this.calibration.setMaskFlipped(in[68]);
                this.calibration.setSpectraFlipped(in[69] == 1);
                int[] maskIndices = new int[numberOfMaskIndices];
                int position = 70;
                for (int i = 0; i < numberOfMaskIndices; ++i) {
                    maskIndices[i] = ByteRoutines.makeDWordLE((byte)in[position], (byte)in[position + 1], (byte)in[position + 2], (byte)in[position + 3]);
                    position += 4;
                }
                this.calibration.setMaskIndices(maskIndices);
                int numberOfXAlignments = ByteRoutines.makeWordLE((byte)in[position], (byte)in[position + 1]);
                position += 2;
                int[] maskXAlign = new int[numberOfXAlignments];
                for (int i = 0; i < numberOfXAlignments; ++i) {
                    maskXAlign[i] = ByteRoutines.makeWordLE((byte)in[position], (byte)in[position + 1]);
                    position += 2;
                }
                this.calibration.setMaskXAlignmentAdjustments(maskXAlign);
                int numberOfYAlignments = ByteRoutines.makeWordLE((byte)in[position], (byte)in[position + 1]);
                position += 2;
                int[] maskYAlign = new int[numberOfYAlignments];
                for (int i = 0; i < numberOfYAlignments; ++i) {
                    maskYAlign[i] = ByteRoutines.makeWord((byte)in[position], (byte)in[position + 1]);
                    position += 2;
                }
                this.calibration.setMaskYAlignmentAdjustments(maskYAlign);
                this.calibration.setSourcePeaks(ByteRoutines.makeWordLE((byte)in[position], (byte)in[position + 1]));
                position += 2;
                int[] shifts = new int[numberOfMaskIndices];
                for (int i = 0; i < numberOfMaskIndices; ++i) {
                    shifts[i] = ByteRoutines.makeDWordLE((short)in[position], (short)in[position + 1]);
                    position += 2;
                }
                this.calibration.setShifts(shifts);
                this.calibration.setPolynomialOrder(ByteRoutines.makeDWordLE((byte)in[position], (byte)in[position + 1], (byte)in[position + 2], (byte)in[position + 3]));
                int entries = ByteRoutines.makeDWordLE((byte)in[position += 4], (byte)in[position + 1], (byte)in[position + 2], (byte)in[position + 3]);
                position += 4;
                float[] pixels = new float[entries];
                for (int i = 0; i < entries; ++i) {
                    pixels[i] = Float.intBitsToFloat(ByteRoutines.makeDWordLE((byte)in[position], (byte)in[position + 1], (byte)in[position + 2], (byte)in[position + 3]));
                    position += 4;
                }
                this.calibration.setObservedPixels(pixels);
                float[] wavelengths = new float[entries];
                for (int i = 0; i < entries; ++i) {
                    wavelengths[i] = Float.intBitsToFloat(ByteRoutines.makeDWordLE((byte)in[position], (byte)in[position + 1], (byte)in[position + 2], (byte)in[position + 3]));
                    position += 4;
                }
                this.calibration.setActualWavelengths(wavelengths);
                this.calibration.setNumberOfDeadPixelColumnsLeft(ByteRoutines.makeWordLE((byte)in[position], (byte)in[position + 1]));
                this.calibration.setNumberOfDeadPixelColumnsRight(ByteRoutines.makeWordLE((byte)in[position += 2], (byte)in[position + 1]));
                int nameLength = ByteRoutines.makeDWordLE((short)in[position += 2], (short)in[position + 1]);
                position += 2;
                String name = "";
                for (int i = 0; i < nameLength; ++i) {
                    name = name + (char)in[position++];
                }
                this.calibration.setName(this.spectrometer.trimTrailingNulls(name));
                int maskLength = ByteRoutines.makeDWordLE((short)in[position], (short)in[position + 1]);
                position += 2;
                String mask = "";
                for (int i = 0; i < maskLength; ++i) {
                    mask = mask + (char)in[position++];
                }
                this.calibration.setMask(this.spectrometer.trimTrailingNulls(mask));
                int sSSize = ByteRoutines.makeDWordLE((short)in[position], (short)in[position + 1]);
                position += 2;
                String spectralSource = "";
                for (int i = 0; i < sSSize; ++i) {
                    spectralSource = spectralSource + (char)in[position++];
                }
                this.calibration.setSpectralSource(this.spectrometer.trimTrailingNulls(spectralSource));
                int snSize = ByteRoutines.makeDWordLE((short)in[position], (short)in[position + 1]);
                position += 2;
                String sn = "";
                for (int i = 0; i < snSize; ++i) {
                    sn = sn + (char)in[position++];
                }
                this.calibration.setSerialNumber(this.spectrometer.trimTrailingNulls(sn));
                this.logger.fine("Successfully read in Spectrometer Calibration.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCalibrationToSpectrometer(MMSRamanCalibration cal) throws IOException {
        int i;
        if (this.spectrometer.getFirmwareVersionNumber() >= 3030) {
            this.schemaOut = (byte)2;
            this.schemaIn = (byte)2;
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        data.write(ByteRoutines.getLowByte((short)((short)cal.getMaskIndices().length)));
        data.write(ByteRoutines.getHighByte((short)((short)cal.getMaskIndices().length)));
        data.write(ByteRoutines.getLowByte((short)((short)cal.getMaskRatio())));
        data.write(ByteRoutines.getHighByte((short)((short)cal.getMaskRatio())));
        data.write((byte)cal.getMaskFlipped());
        data.write(cal.isSpectraFlipped() ? 1 : 0);
        int[] mi = cal.getMaskIndices();
        for (int i2 = 0; i2 < mi.length; ++i2) {
            data.write(ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)mi[i2])));
            data.write(ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)mi[i2])));
            data.write(ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)mi[i2])));
            data.write(ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)mi[i2])));
        }
        int[] x = cal.getMaskXAlignmentAdjustments();
        data.write(ByteRoutines.getLowByte((short)((short)x.length)));
        data.write(ByteRoutines.getHighByte((short)((short)x.length)));
        for (int i3 = 0; i3 < x.length; ++i3) {
            data.write(ByteRoutines.getLowByte((short)((short)x[i3])));
            data.write(ByteRoutines.getHighByte((short)((short)x[i3])));
        }
        int[] y = cal.getMaskYAlignmentAdjustments();
        data.write(ByteRoutines.getLowByte((short)((short)y.length)));
        data.write(ByteRoutines.getHighByte((short)((short)y.length)));
        for (int i4 = 0; i4 < y.length; ++i4) {
            data.write(ByteRoutines.getLowByte((short)((short)y[i4])));
            data.write(ByteRoutines.getHighByte((short)((short)y[i4])));
        }
        data.write(ByteRoutines.getLowByte((short)((short)cal.getSourcePeaks())));
        data.write(ByteRoutines.getHighByte((short)((short)cal.getSourcePeaks())));
        int[] shifts = cal.getShifts();
        for (int i5 = 0; i5 < shifts.length; ++i5) {
            data.write(ByteRoutines.getLowByte((short)((short)shifts[i5])));
            data.write(ByteRoutines.getHighByte((short)((short)shifts[i5])));
        }
        data.write(ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)cal.getPolynomialOrder())));
        data.write(ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)cal.getPolynomialOrder())));
        data.write(ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)cal.getPolynomialOrder())));
        data.write(ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)cal.getPolynomialOrder())));
        float[] pixels = cal.getObservedPixels();
        float[] wavelengths = cal.getActualWavelengths();
        data.write(ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)pixels.length)));
        data.write(ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)pixels.length)));
        data.write(ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)pixels.length)));
        data.write(ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)pixels.length)));
        for (i = 0; i < pixels.length; ++i) {
            data.write(ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)Float.floatToIntBits(pixels[i]))));
            data.write(ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)Float.floatToIntBits(pixels[i]))));
            data.write(ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)Float.floatToIntBits(pixels[i]))));
            data.write(ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)Float.floatToIntBits(pixels[i]))));
        }
        for (i = 0; i < wavelengths.length; ++i) {
            data.write(ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)Float.floatToIntBits(wavelengths[i]))));
            data.write(ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)Float.floatToIntBits(wavelengths[i]))));
            data.write(ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)Float.floatToIntBits(wavelengths[i]))));
            data.write(ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)Float.floatToIntBits(wavelengths[i]))));
        }
        data.write(ByteRoutines.getLowByte((short)((short)cal.getNumberOfDeadPixelColumnsLeft())));
        data.write(ByteRoutines.getHighByte((short)((short)cal.getNumberOfDeadPixelColumnsLeft())));
        data.write(ByteRoutines.getLowByte((short)((short)cal.getNumberOfDeadPixelColumnsRight())));
        data.write(ByteRoutines.getHighByte((short)((short)cal.getNumberOfDeadPixelColumnsRight())));
        byte[] name = cal.getName().getBytes();
        data.write(ByteRoutines.getLowByte((short)((short)(name.length + 1))));
        data.write(ByteRoutines.getHighByte((short)((short)(name.length + 1))));
        int nullTerminator = 0;
        for (int i6 = 0; i6 < name.length; ++i6) {
            data.write(name[i6]);
        }
        data.write(nullTerminator);
        byte[] mask = cal.getMask().getBytes();
        data.write(ByteRoutines.getLowByte((short)((short)(mask.length + 1))));
        data.write(ByteRoutines.getHighByte((short)((short)(mask.length + 1))));
        for (int i7 = 0; i7 < mask.length; ++i7) {
            data.write(mask[i7]);
        }
        data.write(nullTerminator);
        byte[] source = cal.getSpectralSource().getBytes();
        data.write(ByteRoutines.getLowByte((short)((short)(source.length + 1))));
        data.write(ByteRoutines.getHighByte((short)((short)(source.length + 1))));
        for (int i8 = 0; i8 < source.length; ++i8) {
            data.write(source[i8]);
        }
        data.write(nullTerminator);
        byte[] sn = cal.getSerialNumber().getBytes();
        data.write(ByteRoutines.getLowByte((short)((short)(sn.length + 1))));
        data.write(ByteRoutines.getHighByte((short)((short)sn.length)));
        for (int i9 = 0; i9 < sn.length; ++i9) {
            data.write(sn[i9]);
        }
        data.write(nullTerminator);
        byte[] dataArray = data.toByteArray();
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                for (int i10 = 6; i10 < 64; ++i10) {
                    this.out[i10] = 0;
                }
                this.spectrometer.process((byte)6, dataArray.length + 64, dataArray, this.schemaOut, this.schemaIn);
                // ** MonitorExit[var16_25] (shouldn't be in output)
            }
            {
                this.logger.fine("Successfully uploaded Spectrometer Calibration.");
                return;
            }
        }
    }

    public MMSRamanCalibration getCalibration() {
        return this.calibration;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

