/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.nirquest;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.features.advancedintegrationclock.AdvancedIntegrationClock;
import com.oceanoptics.omnidriver.features.advancedintegrationclock.AdvancedIntegrationClockImpl;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersionImpl;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemoval;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalGUIProvider;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalImpl;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalImpl_NIRQuest;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperature;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureGUIProvider;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureImpl;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureImpl_QE65000;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobe;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl_FPGA;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayGUIProvider;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayImpl;
import com.oceanoptics.omnidriver.features.gpio.GPIO;
import com.oceanoptics.omnidriver.features.gpio.GPIOGUIProvider;
import com.oceanoptics.omnidriver.features.gpio.GPIOImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImplFPGA;
import com.oceanoptics.omnidriver.features.highgainmode.HighGainMode;
import com.oceanoptics.omnidriver.features.highgainmode.HighGainModeGUIProvider;
import com.oceanoptics.omnidriver.features.highgainmode.HighGainModeImpl;
import com.oceanoptics.omnidriver.features.highgainmode.HighGainModeImpl_NIRQuest;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBus;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusGUIProvider;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImpl;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImplFPGA;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactor;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorGUIProvider;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImpl;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImplFPGA;
import com.oceanoptics.omnidriver.features.masterclockdivisor.MasterClockDivisor;
import com.oceanoptics.omnidriver.features.masterclockdivisor.MasterClockDivisorImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImpl;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImplFPGA;
import com.oceanoptics.omnidriver.features.shutterclock.ShutterClock;
import com.oceanoptics.omnidriver.features.shutterclock.ShutterClockImpl;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobe;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeImpl;
import com.oceanoptics.omnidriver.features.spibus.SPIBus;
import com.oceanoptics.omnidriver.features.spibus.SPIBusGUIProvider;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImpl;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImplFPGA;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectric;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricGUIProvider;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricImpl;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricImpl_NIRQuest;
import com.oceanoptics.omnidriver.features.version.Version;
import com.oceanoptics.omnidriver.features.version.VersionGUIProvider;
import com.oceanoptics.omnidriver.features.version.VersionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionListener;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBEndpointDevice;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;

public abstract class NIRQuest
extends USBSpectrometer
implements PlugInProvider,
I2CBus,
SPIBus,
AdvancedVersion,
ContinuousStrobe,
AdvancedIntegrationClock,
HardwareTrigger,
ShutterClock,
SingleStrobe,
GPIO,
BoardTemperature,
ThermoElectric,
IrradianceCalibrationFactor,
MasterClockDivisor,
NonlinearityCorrectionProvider,
WavelengthCalibrationProvider,
StrayLightCorrection,
BadPixelRemoval,
Version,
HighGainMode,
USBEndpointDevice {
    protected int saturationIntensity;
    protected PlugInProvider plugInProvider;
    protected AdvancedVersion advancedVersion;
    protected AdvancedIntegrationClock advancedIntegrationClock;
    protected ShutterClock shutterClock;
    protected MasterClockDivisor masterClockDivisor;
    protected StrayLightCorrectionGUIProvider straylight;
    protected I2CBusGUIProvider i2cBus;
    protected SPIBusGUIProvider spiBus;
    protected GPIOGUIProvider gpio;
    protected SingleStrobeGUIProvider singleStrobe;
    protected HardwareTriggerImpl hardwareTrigger;
    protected ContinuousStrobeGUIProvider continuousStrobe;
    protected BoardTemperatureGUIProvider boardTemperature;
    protected IrradianceCalibrationFactorGUIProvider irradianceCalibrationFactor;
    protected ThermoElectricGUIProvider tec;
    protected ExternalTriggerDelayGUIProvider triggerDelay = null;
    protected NonlinearityCorrectionGUIProvider nonlinearity;
    protected WavelengthCalibrationGUIProvider wavelength;
    protected VersionGUIProvider version;
    protected BadPixelRemovalGUIProvider badPixelRemoval = null;
    protected HighGainModeGUIProvider highGainMode = null;
    private int NUMBER_GPIO_PINS = 10;
    private static final short DATA_OUT = 1;
    private static final short HIGH_SPEED_DATA_IN_1 = 130;
    private static final short HIGH_SPEED_DATA_IN_2 = 134;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    private static String __extern__ = "__extern__\n<init>,()V\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetSaturationIntensity,()I\nsetSaturationIntensity,(ILjava/lang/String;)Z\nsetStrobeDelay,(I)V\ngetActualIntegrationTime,()I\ngetPlugIns,()[Lcom/oceanoptics/omnidriver/plugin/SpectrometerPlugIn;\ngetNumberOfPlugIns,()I\nisPlugInDetected,(I)Z\ninitializePlugIns,()[B\ndetectPlugIns,()V\nsetI2CBytes,(BB[B)I\ngetI2CBytes,(BB)[B\ngetSPIBytes,([BI)[B\ngetPSOCVersion,()Ljava/lang/String;\ngetFPGAFirmwareVersion,()Ljava/lang/String;\ncontinuousStrobeCountsToMicros,(I)D\nsetContinuousStrobeDelay,(I)V\ngetContinuousStrobeDelay,()Ljava/lang/Integer;\ngetContinuousStrobeDelayMinimum,()I\ngetContinuousStrobeDelayMaximum,()I\ngetContinuousStrobeDelayIncrement,(I)I\nsetAdvancedIntegrationTime,(J)V\ngetIntegrationTimeBaseClock,()I\ngetIntegrationClockTimer,()I\ngetAdvancedIntegrationTimeMinimum,()J\ngetAdvancedIntegrationTimeMaximum,()J\ngetAdvancedIntegrationTimeIncrement,()J\nsetExternalTriggerMode,(I)V\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\ngetExternalTriggerMode,()Ljava/lang/Integer;\nsetExternalTriggerDelay,(I)V\ntriggerDelayCountsToMicroseconds,(I)D\ngetExternalTriggerDelay,()Ljava/lang/Integer;\ngetExternalTriggerDelayMinimum,()I\ngetExternalTriggerDelayMaximum,()I\ngetExternalTriggerDelayIncrement,()I\nsetShutterClock,(I)V\ngetShutterClock,()I\nsetSingleStrobeLow,(I)V\nsetSingleStrobeHigh,(I)V\ngetSingleStrobeCountsToMicros,(I)D\ngetSingleStrobeLow,()I\ngetSingleStrobeHigh,()I\ngetSingleStrobeMinimum,()I\ngetSingleStrobeMaximum,()I\ngetSingleStrobeIncrement,()I\nsetDirectionAllBits,(Ljava/util/BitSet;)V\nsetMuxAllBits,(Ljava/util/BitSet;)V\nsetValueAllBits,(Ljava/util/BitSet;)V\nsetDirectionBitmask,(S)V\nsetMuxBitmask,(S)V\nsetValueBitmask,(S)V\nsetDirectionBit,(IZ)V\nsetMuxBit,(IZ)V\nsetValueBit,(IZ)V\ngetTotalGPIOBits,()I\ngetDirectionBits,()Ljava/util/BitSet;\ngetMuxBits,()Ljava/util/BitSet;\ngetValueBits,()Ljava/util/BitSet;\ngetValueBit,(I)I\ngetNumberOfPins,()I\ngetBoardTemperatureCelsius,()D\ngetIrradianceCalibrationFactors,()[D\nsetIrradianceCalibrationFactors,([D)V\ngetCollectionArea,()D\nhasCollectionArea,()Z\nsetCollectionArea,(D)V\nsetMasterClockDivisor,(I)V\ngetMasterClockDivisor,()I\ngetTECEnable,()Ljava/lang/Boolean;\nsetTECEnable,(Z)V\ngetFanEnable,()Ljava/lang/Boolean;\nsetFanEnable,(Z)V\ngetDetectorTemperatureCelsius,()D\ngetDetectorTemperatureSetPointCelsius,()D\ngetDetectorSetPointCelsius,()Ljava/lang/Double;\nsetDetectorSetPointCelsius,(D)V\ngetSetPointMinimumCelsius,()D\ngetSetPointMaximumCelsius,()D\ngetSetPointIncrementCelsius,()D\nisSaveTECStateEnabled,()Z\nsaveTECState,()V\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\ngetBadPixels,()[I\nsetBadPixels,([I)V\nremoveBadPixels,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetNumberOfBadPixels,()I\ngetAllPixels,()[I\nsetBadPixelsToSpectrometer,()V\ngetBadPixelsFromSpectrometer,()[I\nsetHighGain,(Z)V\nsetHighGainDefault,(Z)V\ngetHighGainDefault,()Z\nhasHighGainDefault,()Z\nisAdvancedVersion,()Z\nuploadFirmware,(Ljava/io/File;J)V\nuploadFPGA,(Ljava/io/File;J)V\naddAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\nremoveAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\n";

    public NIRQuest() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 130, 2, 512, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 134, 2, 512, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 0: {
                return this.dataOutEndPoint;
            }
            case 1: {
                return this.highSpeedInEndPoint1;
            }
            case 2: {
                return this.highSpeedInEndPoint2;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    protected void initFeatures(USBInterface usb) throws IOException {
        this.plugInProvider = new PlugInProviderImplFPGA(usb, this);
        this.advancedVersion = new AdvancedVersionImpl(usb);
        this.advancedIntegrationClock = new AdvancedIntegrationClockImpl(usb);
        this.shutterClock = new ShutterClockImpl(usb);
        this.masterClockDivisor = new MasterClockDivisorImpl(usb);
        this.i2cBus = new I2CBusImplFPGA(usb);
        this.spiBus = new SPIBusImplFPGA(usb);
        this.gpio = new GPIOImpl(usb, this.NUMBER_GPIO_PINS);
        this.singleStrobe = new SingleStrobeImpl(usb);
        this.hardwareTrigger = new HardwareTriggerImplFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(3)});
        this.continuousStrobe = new ContinuousStrobeImpl_FPGA(usb);
        this.boardTemperature = new BoardTemperatureImpl_QE65000(usb);
        this.irradianceCalibrationFactor = new IrradianceCalibrationFactorImplFPGA(usb, this.numberOfCCDPixels);
        this.triggerDelay = new ExternalTriggerDelayImpl(usb);
        this.tec = new ThermoElectricImpl_NIRQuest(usb);
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.straylight = new StrayLightCorrectionImpl(usb, this);
        this.version = new VersionImpl(usb, this);
        this.badPixelRemoval = new BadPixelRemovalImpl_NIRQuest(usb, this.numberOfCCDPixels);
        this.highGainMode = new HighGainModeImpl_NIRQuest(usb, this);
        this.featureMap.put(PlugInProviderImpl.class, (PlugInProviderImpl)this.plugInProvider);
        this.featureMap.put(AdvancedVersionImpl.class, (AdvancedVersionImpl)this.advancedVersion);
        this.featureMap.put(AdvancedIntegrationClockImpl.class, (AdvancedIntegrationClockImpl)this.advancedIntegrationClock);
        this.featureMap.put(ShutterClockImpl.class, (ShutterClockImpl)this.shutterClock);
        this.featureMap.put(MasterClockDivisorImpl.class, (MasterClockDivisorImpl)this.masterClockDivisor);
        this.featureMap.put(I2CBusImpl.class, (I2CBusImpl)this.i2cBus);
        this.featureMap.put(SPIBusImpl.class, (SPIBusImpl)this.spiBus);
        this.featureMap.put(GPIOImpl.class, (GPIOImpl)this.gpio);
        this.featureMap.put(SingleStrobeImpl.class, (SingleStrobeImpl)this.singleStrobe);
        this.featureMap.put(HardwareTriggerImpl.class, this.hardwareTrigger);
        this.featureMap.put(ContinuousStrobeImpl.class, (ContinuousStrobeImpl)this.continuousStrobe);
        this.featureMap.put(BoardTemperatureImpl.class, (BoardTemperatureImpl)this.boardTemperature);
        this.featureMap.put(IrradianceCalibrationFactorImpl.class, (IrradianceCalibrationFactorImpl)this.irradianceCalibrationFactor);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.straylight);
        this.featureMap.put(VersionImpl.class, (VersionImpl)this.version);
        this.featureMap.put(BadPixelRemovalImpl.class, (BadPixelRemovalImpl)this.badPixelRemoval);
        this.featureMap.put(HighGainModeImpl.class, (HighGainModeImpl)this.highGainMode);
        this.featureMap.put(ThermoElectricImpl.class, (ThermoElectricImpl)this.tec);
        this.featureMap.put(ExternalTriggerDelayImpl.class, (ExternalTriggerDelayImpl)this.triggerDelay);
    }

    public GUIProvider[] getGUIFeatures() {
        return new GUIProvider[]{this.wavelength, this.straylight, this.nonlinearity, this.singleStrobe, this.continuousStrobe, this.i2cBus, this.spiBus, this.gpio, this.boardTemperature, this.tec, this.triggerDelay, this.irradianceCalibrationFactor, this.badPixelRemoval, this.highGainMode, this.version};
    }

    public int getSaturationIntensity() {
        return this.tec.getSaturationIntensity();
    }

    public boolean setSaturationIntensity(int newSaturationIntensity, String key) {
        return this.tec.setSaturationIntensity(newSaturationIntensity, key);
    }

    protected Spectrum formatData(byte[] data, Spectrum doubleSpectrum) throws IOException {
        byte zero = 0;
        double[] spectrum = doubleSpectrum.getSpectrum();
        this.logger.finest("Formatting data");
        doubleSpectrum.setSaturated(false);
        if (data[this.pipeSize - 1] != 105) {
            this.logger.severe("Lost synchroniztion");
            throw new IOException("Lost synchronization");
        }
        double scalingFactor = (double)this.maxIntensity / (double)this.saturationIntensity;
        for (int i = 0; i < this.numberOfCCDPixels; ++i) {
            double processedPixel;
            byte MSB = data[i * 2 + 1];
            byte LSB = data[i * 2];
            int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB) ^ 0x8000;
            if (pixel >= this.saturationIntensity) {
                doubleSpectrum.setSaturated(true);
                pixel = this.saturationIntensity;
            }
            spectrum[i] = processedPixel = (processedPixel = (double)pixel * scalingFactor) > (double)this.maxIntensity ? (double)this.maxIntensity : processedPixel;
        }
        this.badPixelRemoval.removeBadPixels(doubleSpectrum);
        return doubleSpectrum;
    }

    public void setStrobeDelay(int delay) throws IOException {
        this.setContinuousStrobeDelay(delay);
    }

    public int getActualIntegrationTime() {
        return super.getActualIntegrationTime();
    }

    public SpectrometerPlugIn[] getPlugIns() throws IOException {
        return this.plugInProvider.getPlugIns();
    }

    public int getNumberOfPlugIns() throws IOException {
        return this.plugInProvider.getNumberOfPlugIns();
    }

    public boolean isPlugInDetected(int id) throws IOException {
        return this.plugInProvider.isPlugInDetected(id);
    }

    public byte[] initializePlugIns() throws IOException {
        return this.plugInProvider.initializePlugIns();
    }

    public void detectPlugIns() throws IOException {
        this.plugInProvider.detectPlugIns();
    }

    public int setI2CBytes(byte address, byte numBytes, byte[] i2C) throws IOException {
        return this.i2cBus.setI2CBytes(address, numBytes, i2C);
    }

    public byte[] getI2CBytes(byte address, byte numBytes) throws IOException {
        return this.i2cBus.getI2CBytes(address, numBytes);
    }

    public byte[] getSPIBytes(byte[] message, int length) throws IOException {
        return this.spiBus.getSPIBytes(message, length);
    }

    public String getPSOCVersion() throws IOException {
        return this.advancedVersion.getPSOCVersion();
    }

    public String getFPGAFirmwareVersion() throws IOException {
        return this.advancedVersion.getFPGAFirmwareVersion();
    }

    public double continuousStrobeCountsToMicros(int counts) {
        return this.continuousStrobe.continuousStrobeCountsToMicros(counts);
    }

    public void setContinuousStrobeDelay(int delayMicros) throws IOException {
        this.continuousStrobe.setContinuousStrobeDelay(delayMicros);
    }

    public Integer getContinuousStrobeDelay() {
        return this.continuousStrobe.getContinuousStrobeDelay();
    }

    public int getContinuousStrobeDelayMinimum() {
        return this.continuousStrobe.getContinuousStrobeDelayMinimum();
    }

    public int getContinuousStrobeDelayMaximum() {
        return this.continuousStrobe.getContinuousStrobeDelayMaximum();
    }

    public int getContinuousStrobeDelayIncrement(int magnitude) {
        return this.continuousStrobe.getContinuousStrobeDelayIncrement(magnitude);
    }

    public void setAdvancedIntegrationTime(long delayMicros) throws IOException {
        this.advancedIntegrationClock.setAdvancedIntegrationTime(delayMicros);
    }

    public int getIntegrationTimeBaseClock() throws IOException {
        return this.advancedIntegrationClock.getIntegrationTimeBaseClock();
    }

    public int getIntegrationClockTimer() throws IOException {
        return this.advancedIntegrationClock.getIntegrationClockTimer();
    }

    public long getAdvancedIntegrationTimeMinimum() {
        return this.advancedIntegrationClock.getAdvancedIntegrationTimeMinimum();
    }

    public long getAdvancedIntegrationTimeMaximum() {
        return this.advancedIntegrationClock.getAdvancedIntegrationTimeMaximum();
    }

    public long getAdvancedIntegrationTimeIncrement() {
        return this.advancedIntegrationClock.getAdvancedIntegrationTimeIncrement();
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public void setExternalTriggerDelay(int counts) throws IOException {
        this.triggerDelay.setExternalTriggerDelay(counts);
    }

    public double triggerDelayCountsToMicroseconds(int counts) {
        return this.triggerDelay.triggerDelayCountsToMicroseconds(counts);
    }

    public Integer getExternalTriggerDelay() {
        return this.triggerDelay.getExternalTriggerDelay();
    }

    public int getExternalTriggerDelayMinimum() {
        return this.triggerDelay.getExternalTriggerDelayMinimum();
    }

    public int getExternalTriggerDelayMaximum() {
        return this.triggerDelay.getExternalTriggerDelayMaximum();
    }

    public int getExternalTriggerDelayIncrement() {
        return this.triggerDelay.getExternalTriggerDelayIncrement();
    }

    public void setShutterClock(int value) throws IOException {
        this.shutterClock.setShutterClock(value);
    }

    public int getShutterClock() throws IOException {
        return this.shutterClock.getShutterClock();
    }

    public void setSingleStrobeLow(int value) throws IOException {
        this.singleStrobe.setSingleStrobeLow(value);
    }

    public void setSingleStrobeHigh(int value) throws IOException {
        this.singleStrobe.setSingleStrobeHigh(value);
    }

    public double getSingleStrobeCountsToMicros(int counts) {
        return this.singleStrobe.getSingleStrobeCountsToMicros(counts);
    }

    public int getSingleStrobeLow() throws IOException {
        return this.singleStrobe.getSingleStrobeLow();
    }

    public int getSingleStrobeHigh() throws IOException {
        return this.singleStrobe.getSingleStrobeHigh();
    }

    public int getSingleStrobeMinimum() {
        return this.singleStrobe.getSingleStrobeMinimum();
    }

    public int getSingleStrobeMaximum() {
        return this.singleStrobe.getSingleStrobeMaximum();
    }

    public int getSingleStrobeIncrement() {
        return this.singleStrobe.getSingleStrobeIncrement();
    }

    public void setDirectionAllBits(BitSet bitSet) throws IOException {
        this.gpio.setDirectionAllBits(bitSet);
    }

    public void setMuxAllBits(BitSet bitSet) throws IOException {
        this.gpio.setMuxAllBits(bitSet);
    }

    public void setValueAllBits(BitSet bitSet) throws IOException {
        this.gpio.setValueAllBits(bitSet);
    }

    public void setDirectionBitmask(short bitmask) throws IOException {
        this.gpio.setDirectionBitmask(bitmask);
    }

    public void setMuxBitmask(short bitmask) throws IOException {
        this.gpio.setMuxBitmask(bitmask);
    }

    public void setValueBitmask(short bitmask) throws IOException {
        this.gpio.setValueBitmask(bitmask);
    }

    public void setDirectionBit(int bit, boolean value) throws IOException {
        this.gpio.setDirectionBit(bit, value);
    }

    public void setMuxBit(int bit, boolean value) throws IOException {
        this.gpio.setMuxBit(bit, value);
    }

    public void setValueBit(int bit, boolean value) throws IOException {
        this.gpio.setValueBit(bit, value);
    }

    public int getTotalGPIOBits() {
        return this.gpio.getTotalGPIOBits();
    }

    public BitSet getDirectionBits() throws IOException {
        return this.gpio.getDirectionBits();
    }

    public BitSet getMuxBits() throws IOException {
        return this.gpio.getMuxBits();
    }

    public BitSet getValueBits() throws IOException {
        return this.gpio.getValueBits();
    }

    public int getValueBit(int bitNumber) throws IOException {
        return this.gpio.getValueBit(bitNumber);
    }

    public int getNumberOfPins() {
        return this.gpio.getNumberOfPins();
    }

    public double getBoardTemperatureCelsius() throws IOException {
        return this.boardTemperature.getBoardTemperatureCelsius();
    }

    public double[] getIrradianceCalibrationFactors() throws IOException {
        return this.irradianceCalibrationFactor.getIrradianceCalibrationFactors();
    }

    public void setIrradianceCalibrationFactors(double[] data) throws IOException {
        this.irradianceCalibrationFactor.setIrradianceCalibrationFactors(data);
    }

    public double getCollectionArea() throws IOException {
        return this.irradianceCalibrationFactor.getCollectionArea();
    }

    public boolean hasCollectionArea() {
        return this.irradianceCalibrationFactor.hasCollectionArea();
    }

    public void setCollectionArea(double area) throws IOException {
        this.irradianceCalibrationFactor.setCollectionArea(area);
    }

    public void setMasterClockDivisor(int value) throws IOException {
        this.masterClockDivisor.setMasterClockDivisor(value);
    }

    public int getMasterClockDivisor() throws IOException {
        return this.masterClockDivisor.getMasterClockDivisor();
    }

    public Boolean getTECEnable() {
        return this.tec.getTECEnable();
    }

    public void setTECEnable(boolean enable) throws IOException {
        this.tec.setTECEnable(enable);
    }

    public Boolean getFanEnable() {
        return this.tec.getFanEnable();
    }

    public void setFanEnable(boolean enable) throws IOException {
        this.tec.setFanEnable(enable);
    }

    public double getDetectorTemperatureCelsius() throws IOException {
        return this.tec.getDetectorTemperatureCelsius();
    }

    public double getDetectorTemperatureSetPointCelsius() throws IOException {
        return this.tec.getDetectorTemperatureSetPointCelsius();
    }

    public Double getDetectorSetPointCelsius() {
        return this.tec.getDetectorSetPointCelsius();
    }

    public void setDetectorSetPointCelsius(double point) throws IOException {
        this.tec.setDetectorSetPointCelsius(point);
    }

    public double getSetPointMinimumCelsius() {
        return this.tec.getSetPointMinimumCelsius();
    }

    public double getSetPointMaximumCelsius() {
        return this.tec.getSetPointMaximumCelsius();
    }

    public double getSetPointIncrementCelsius() {
        return this.tec.getSetPointIncrementCelsius();
    }

    public boolean isSaveTECStateEnabled() {
        return this.tec.isSaveTECStateEnabled();
    }

    public void saveTECState() throws IOException {
        this.tec.saveTECState();
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public int[] getBadPixels() throws IOException {
        return this.badPixelRemoval.getBadPixels();
    }

    public void setBadPixels(int[] pixels) throws IOException {
        this.badPixelRemoval.setBadPixels(pixels);
    }

    public Spectrum removeBadPixels(Spectrum spectrum) throws IOException {
        return this.badPixelRemoval.removeBadPixels(spectrum);
    }

    public int getNumberOfBadPixels() {
        return this.badPixelRemoval.getNumberOfBadPixels();
    }

    public int[] getAllPixels() {
        return this.badPixelRemoval.getAllPixels();
    }

    public void setBadPixelsToSpectrometer() throws IOException {
        this.badPixelRemoval.setBadPixelsToSpectrometer();
    }

    public int[] getBadPixelsFromSpectrometer() throws IOException {
        return this.badPixelRemoval.getBadPixelsFromSpectrometer();
    }

    public void setHighGain(boolean gain) throws IOException {
        this.highGainMode.setHighGain(gain);
    }

    public void setHighGainDefault(boolean gain) throws IOException {
        this.highGainMode.setHighGainDefault(gain);
    }

    public boolean getHighGainDefault() throws IOException {
        return this.highGainMode.getHighGainDefault();
    }

    public boolean hasHighGainDefault() {
        return this.highGainMode.hasHighGainDefault();
    }

    public boolean isAdvancedVersion() {
        return this instanceof AdvancedVersion;
    }

    public void uploadFirmware(File file, long fileSize) throws IOException {
        this.version.uploadFirmware(file, fileSize);
    }

    public void uploadFPGA(File file, long fileSize) throws IOException {
        this.version.uploadFPGA(file, fileSize);
    }

    public void addAcquisitionListener(AcquisitionListener listener) {
        this.version.addAcquisitionListener(listener);
    }

    public void removeAcquisitionListener(AcquisitionListener listener) {
        this.version.removeAcquisitionListener(listener);
    }
}

