/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.sas;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImplNonFPGA;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.statusprovider.StatusProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.version.Version;
import com.oceanoptics.omnidriver.features.version.VersionGUIProvider;
import com.oceanoptics.omnidriver.features.version.VersionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionListener;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBEndpointDevice;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Configuration;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerStatus;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.sas.SASChannel;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.File;
import java.io.IOException;

public class SAS
extends USBSpectrometer
implements StatusProvider,
HardwareTrigger,
NonlinearityCorrectionProvider,
StrayLightCorrection,
WavelengthCalibrationProvider,
Version,
USBEndpointDevice {
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private HardwareTriggerImpl hardwareTrigger;
    private WavelengthCalibrationGUIProvider wavelength;
    private StrayLightCorrectionGUIProvider straylight;
    private NonlinearityCorrectionGUIProvider nonlinearity;
    private VersionGUIProvider version;
    private static final short DATA_OUT = 2;
    private static final short HIGH_SPEED_DATA_IN = 130;
    private static final short UNUSED_DATA_OUT = 7;
    private static final short LOW_SPEED_DATA_IN = 135;
    private static final short MAX_PACKET_SIZE = 64;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(I)V\nsetEndpoints,()V\ngetEndpoint,(I)Lcom/oceanoptics/uniusb/USBEndpointDescriptor;\nopenSpectrometer,(I)V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\ngetSpectrum,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetSpectrum,()Lcom/oceanoptics/omnidriver/spectra/Spectrum;\ngetStatus,()Lcom/oceanoptics/omnidriver/spectrometer/SpectrometerStatus;\nreadIntegrationTime,()I\ntoString,()Ljava/lang/String;\nsetExternalTriggerMode,(I)V\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\ngetExternalTriggerMode,()Ljava/lang/Integer;\nreadNonlinearityCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteNonlinearityCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetNonlinearityCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetNonlinearityCoefficientsSingleChannel,(I)[D\nsetNonlinearityCoefficientsSingleChannel,([DI)V\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetWavelengths,(I)[D\nsetWavelengths,([DI)V\nreadStrayLightCorrectionCoefficientFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nwriteStrayLightCoefficientToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetStrayLightCorrectionCoefficient,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetStrayLightCorrectionCoefficient,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetStrayLight,(DI)V\ngetStrayLight,(I)D\nisAdvancedVersion,()Z\nuploadFirmware,(Ljava/io/File;J)V\nuploadFPGA,(Ljava/io/File;J)V\naddAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\nremoveAcquisitionListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionListener;)V\n";

    public SAS() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SAS(int i) throws IOException {
        this.setEndpoints();
        this.openSpectrometer(i);
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 130, 2, 64, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 7, 2, 64, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 135, 2, 64, 0);
    }

    public USBEndpointDescriptor getEndpoint(int endPoint) throws IllegalArgumentException {
        switch (endPoint) {
            case 0: {
                return this.dataOutEndPoint;
            }
            case 1: {
                return this.highSpeedInEndPoint1;
            }
            case 2: {
                return this.highSpeedInEndPoint2;
            }
            case 3: {
                return this.lowSpeedInEndPoint;
            }
        }
        throw new IllegalArgumentException("End Point number invalid.");
    }

    public void openSpectrometer(int index) throws IOException {
        this.integrationTimeMinimum = 6000;
        this.integrationTimeMaximum = 65535000;
        this.integrationTimeIncrement = 1000;
        this.integrationTimeBase = 1000;
        this.numberOfCCDPixels = 512;
        this.numberOfDarkCCDPixels = 0;
        this.maxIntensity = 4095;
        this.pipeSize = this.numberOfCCDPixels * 4 + 1;
        this.rawData = new byte[this.pipeSize];
        this.spectrometerConfigSlot = 14;
        this.productID = 4102;
        this.usb.openDevice(this.vendorID, this.productID, index);
        this.deviceIndex = index;
        this.initialize();
        this.getFirmwareVersion();
        this.channels = new SpectrometerChannel[1];
        this.channels[this.channelIndex] = new SASChannel(this, new Coefficients(), this.channelIndex);
        this.logger.fine("SAS has been opened at index " + index);
        this.initFeatures(this.usb);
        this.finishConstruction();
        this.configuration = new Configuration(this);
    }

    private void initFeatures(USBInterface usb) throws IOException {
        this.hardwareTrigger = new HardwareTriggerImplNonFPGA(usb, new ExternalTriggerMode[]{new ExternalTriggerMode(0), new ExternalTriggerMode(1)});
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.straylight = new StrayLightCorrectionImpl(usb, this);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.version = new VersionImpl(usb, this);
        this.featureMap.put(HardwareTriggerImpl.class, this.hardwareTrigger);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.straylight);
        this.featureMap.put(VersionImpl.class, (VersionImpl)this.version);
    }

    public GUIProvider[] getGUIFeatures() {
        return new GUIProvider[]{this.wavelength, this.straylight, this.nonlinearity, this.version};
    }

    protected Spectrum formatData(byte[] data, Spectrum spectrum) throws IOException {
        this.logger.finest("Formatting spectrum...");
        spectrum.setSaturated(false);
        double[] spectrumArray = spectrum.getSpectrum();
        byte zero = 0;
        if (data[1024] != 105) {
            this.logger.severe("Lost synchronization");
            throw new IOException("Lost synchronization");
        }
        for (int i = spectrumArray.length - 1; i >= 0; --i) {
            int LSBPacket = i >> 6;
            int MSBPacket = LSBPacket + 1;
            byte MSB = data[(MSBPacket << 6) + i];
            byte LSB = data[(LSBPacket << 6) + i];
            int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB);
            if (pixel >= this.maxIntensity) {
                spectrum.setSaturated(true);
            }
            spectrumArray[i] = pixel;
        }
        return spectrum;
    }

    public Spectrum getSpectrum(Spectrum spectrum) throws IOException {
        this.timeoutOccurredFlag = false;
        try {
            Spectrum cdsSpectrum = new Spectrum(512, 0);
            cdsSpectrum = super.getSpectrum(cdsSpectrum);
            double[] cspec = cdsSpectrum.getSpectrum();
            double[] tspec = new double[256];
            int j = 0;
            for (int i = 0; i < 256; ++i) {
                tspec[i] = cspec[j] - cspec[j + 1];
                j = 2;
            }
            spectrum.setSpectrum(tspec);
        }
        catch (IOException exception) {
            this.timeoutOccurredFlag = this.determineWhetherTimeoutOccurred(exception);
            throw exception;
        }
        return spectrum;
    }

    public Spectrum getSpectrum() throws IOException {
        Spectrum spectrum = new Spectrum(this.numberOfCCDPixels, 0);
        return this.getSpectrum(spectrum);
    }

    public SpectrometerStatus getStatus() throws IOException {
        byte[] sb = super.getStatusArray();
        this.logger.finest("SAS Status.");
        SpectrometerStatus stat = new SpectrometerStatus();
        stat.numPixels = ByteRoutines.makeWord((byte)sb[0], (byte)sb[1]);
        stat.integrationTime = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)sb[2], (byte)sb[3]);
        stat.lampEnabled = sb[4] != 0;
        stat.externalTriggerMode = sb[5];
        stat.takingScan = sb[6] != 0;
        stat.timerSwap = sb[7];
        stat.dataReady = sb[8] != 0;
        stat.failed = sb[9] != 0;
        return stat;
    }

    public int readIntegrationTime() throws IOException {
        SpectrometerStatus stat = this.getStatus();
        return stat.integrationTime;
    }

    public String toString() {
        try {
            return super.toString() + "\n" + this.getStatus();
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public Coefficients[] readNonlinearityCoefficientsFromSpectrometer() {
        return this.nonlinearity.readNonlinearityCoefficientsFromSpectrometer();
    }

    public void writeNonlinearityCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.nonlinearity.writeNonlinearityCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getNonlinearityCoefficients() {
        return this.nonlinearity.getNonlinearityCoefficients();
    }

    public void setNonlinearityCoefficients(Coefficients[] coefficients) {
        this.nonlinearity.setNonlinearityCoefficients(coefficients);
    }

    public double[] getNonlinearityCoefficientsSingleChannel(int index) {
        return this.nonlinearity.getNonlinearityCoefficientsSingleChannel(index);
    }

    public void setNonlinearityCoefficientsSingleChannel(double[] nl, int index) {
        this.nonlinearity.setNonlinearityCoefficientsSingleChannel(nl, index);
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public void setWavelengths(double[] wl, int index) {
        this.wavelength.setWavelengths(wl, index);
    }

    public Coefficients[] readStrayLightCorrectionCoefficientFromSpectrometer() {
        return this.straylight.readStrayLightCorrectionCoefficientFromSpectrometer();
    }

    public void writeStrayLightCoefficientToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.straylight.writeStrayLightCoefficientToSpectrometer(coefficients);
    }

    public void setStrayLightCorrectionCoefficient(Coefficients[] coefficients) {
        this.straylight.setStrayLightCorrectionCoefficient(coefficients);
    }

    public Coefficients[] getStrayLightCorrectionCoefficient() {
        return this.straylight.getStrayLightCorrectionCoefficient();
    }

    public void setStrayLight(double strayLight, int index) {
        this.straylight.setStrayLight(strayLight, index);
    }

    public double getStrayLight(int index) {
        return this.straylight.getStrayLight(index);
    }

    public boolean isAdvancedVersion() {
        return this instanceof AdvancedVersion;
    }

    public void uploadFirmware(File file, long fileSize) throws IOException {
        this.version.uploadFirmware(file, fileSize);
    }

    public void uploadFPGA(File file, long fileSize) throws IOException {
        this.version.uploadFPGA(file, fileSize);
    }

    public void addAcquisitionListener(AcquisitionListener listener) {
        this.version.addAcquisitionListener(listener);
    }

    public void removeAcquisitionListener(AcquisitionListener listener) {
        this.version.removeAcquisitionListener(listener);
    }
}

