/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.sas;

import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import java.io.IOException;

public class SASChannel
extends SpectrometerChannel {
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;I)V\ngetCoefficientsFromSpectrometer,()V\nsetCoefficients,()V\nsetWavelengthCalibration,()V\ngetEndingWavelength,()D\n";

    public SASChannel(Spectrometer spectrometer, Coefficients coefficients, int channel) throws IOException {
        super(spectrometer, coefficients, 0);
    }

    protected void setPixels() {
        this.numberOfPixels = 256;
        this.numberOfDarkPixels = 0;
    }

    public void getCoefficientsFromSpectrometer() throws IOException {
        try {
            this.coefficients.setWlIntercept(Double.parseDouble(this.spectrometer.getInfo(1 + this.channelIndex * 4)));
            this.coefficients.setWlFirst(Double.parseDouble(this.spectrometer.getInfo(2 + this.channelIndex * 4)));
            this.coefficients.setWlSecond(Double.parseDouble(this.spectrometer.getInfo(3 + this.channelIndex * 4)));
        }
        catch (NumberFormatException nfe) {
            this.coefficients.setWlIntercept(0.0);
            this.coefficients.setWlFirst(1.0);
            this.coefficients.setWlSecond(0.0);
            this.logger.warning("ERROR: " + nfe.getMessage());
            this.logger.warning("ERROR: cannot read wavelength coefficients from spectrometer. Setting to pixel indices.");
            this.logger.warning("Intercept was [" + this.spectrometer.getInfo(1) + "]");
            this.logger.warning("First was [" + this.spectrometer.getInfo(2) + "]");
            this.logger.warning("Second was [" + this.spectrometer.getInfo(3) + "]");
        }
    }

    public void setCoefficients() throws IOException {
        this.setWavelengthCalibration();
    }

    public void setWavelengthCalibration() throws IOException {
        this.spectrometer.setInfo(1 + this.channelIndex * 4, Double.toString(this.coefficients.getWlIntercept()));
        this.spectrometer.setInfo(2 + this.channelIndex * 4, Double.toString(this.coefficients.getWlFirst()));
        this.spectrometer.setInfo(3 + this.channelIndex * 4, Double.toString(this.coefficients.getWlSecond()));
    }

    public double getEndingWavelength() {
        return this.getWavelength(this.getNumberOfPixels() - 1);
    }
}

