/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.sts;

import com.oceanoptics.utilities.ByteRoutines;

public class OceanBinaryProtocolMessage {
    protected static final byte[] header = new byte[]{-63, -64};
    protected short protocolVersion;
    protected short flags;
    protected short errorNumber;
    protected int messageType;
    protected int regarding;
    protected byte checksumType;
    protected byte immediateDataLength;
    protected byte[] immediateData;
    protected int bytesRemaining;
    protected byte[] payload = null;
    protected byte[] checksum = new byte[16];
    protected static final byte[] footer = new byte[]{-59, -60, -61, -62};
    public static final int RESPONSE_FLAG = 1;
    public static final int ACK_FLAG = 2;
    public static final int ACK_REQUESTED_FLAG = 4;
    public static final int NACK_FLAG = 8;
    public static final int EXCEPTION_FLAG = 16;
    private static String __extern__ = "__extern__\n<init>,()V\ntoByteStream,()[B\nparseHeaderFromByteStream,([B)Lcom/oceanoptics/omnidriver/spectrometer/sts/OceanBinaryProtocolMessage;\nparseByteStream,([B)Lcom/oceanoptics/omnidriver/spectrometer/sts/OceanBinaryProtocolMessage;\ngetData,()[B\ngetBytesRemaining,()I\ngetChecksumType,()B\ngetErrno,()S\ngetFlags,()S\ngetImmediateData,()[B\ngetImmediateDataLength,()B\ngetMessageType,()I\ngetPayload,()[B\ngetProtocolVersion,()S\ngetRegarding,()I\nsetBytesRemaining,(I)V\nsetChecksumType,(B)V\nsetErrorNumber,(S)V\nsetFlags,(S)V\nsetAckRequestedFlag,()V\nisNackFlagSet,()Z\nisAckFlagSet,()Z\nsetImmediateData,([B)V\nsetImmediateDataLength,(B)V\nsetMessageType,(I)V\nsetPayload,([B)V\nsetProtocolVersion,(S)V\nsetRegarding,(I)V\n";

    public OceanBinaryProtocolMessage() {
        this.setPayload(null);
        this.setImmediateData(null);
    }

    public byte[] toByteStream() {
        int i;
        int i2;
        int offset = 0;
        int length = 64;
        if (null != this.payload) {
            length += this.payload.length;
        }
        byte[] retval = new byte[length];
        for (i2 = 0; i2 < header.length; ++i2) {
            retval[offset++] = header[i2];
        }
        retval[offset++] = ByteRoutines.getLowByte((short)this.protocolVersion);
        retval[offset++] = ByteRoutines.getHighByte((short)this.protocolVersion);
        retval[offset++] = ByteRoutines.getLowByte((short)this.flags);
        retval[offset++] = ByteRoutines.getHighByte((short)this.flags);
        retval[offset++] = ByteRoutines.getLowByte((short)this.errorNumber);
        retval[offset++] = ByteRoutines.getHighByte((short)this.errorNumber);
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)this.messageType));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)this.messageType));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)this.messageType));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)this.messageType));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)this.regarding));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)this.regarding));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)this.regarding));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)this.regarding));
        for (i2 = 0; i2 < 6; ++i2) {
            retval[offset++] = 0;
        }
        retval[offset++] = this.checksumType;
        retval[offset++] = this.immediateDataLength;
        int immediateCopied = 0;
        if (null != this.immediateData) {
            for (i = 0; i < 16 && i < this.immediateData.length; ++i) {
                retval[offset++] = this.immediateData[i];
                ++immediateCopied;
            }
        }
        for (i = immediateCopied; i < 16; ++i) {
            retval[offset++] = 0;
        }
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)this.bytesRemaining));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)this.bytesRemaining));
        retval[offset++] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)this.bytesRemaining));
        retval[offset++] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)this.bytesRemaining));
        if (null != this.payload) {
            for (i = 0; i < this.payload.length; ++i) {
                retval[offset++] = this.payload[i];
            }
        }
        for (i = 0; i < 16; ++i) {
            retval[offset++] = 0;
        }
        for (i = 0; i < footer.length; ++i) {
            retval[offset++] = footer[i];
        }
        return retval;
    }

    public static OceanBinaryProtocolMessage parseHeaderFromByteStream(byte[] message) {
        OceanBinaryProtocolMessage retval = new OceanBinaryProtocolMessage();
        if (header[0] != message[0] || header[1] != message[1]) {
            throw new IllegalArgumentException("Could not find message header");
        }
        retval.protocolVersion = ByteRoutines.makeWord((byte)message[3], (byte)message[2]);
        retval.flags = ByteRoutines.makeWord((byte)message[5], (byte)message[4]);
        retval.errorNumber = ByteRoutines.makeWord((byte)message[7], (byte)message[6]);
        retval.messageType = ByteRoutines.makeDWord((byte)message[11], (byte)message[10], (byte)message[9], (byte)message[8]);
        retval.regarding = ByteRoutines.makeDWord((byte)message[15], (byte)message[14], (byte)message[13], (byte)message[12]);
        retval.checksumType = message[22];
        retval.immediateDataLength = message[23];
        retval.immediateData = new byte[retval.immediateDataLength];
        for (int i = 0; i < retval.immediateData.length; ++i) {
            retval.immediateData[i] = message[i + 24];
        }
        retval.bytesRemaining = ByteRoutines.makeDWord((byte)message[43], (byte)message[42], (byte)message[41], (byte)message[40]);
        if (retval.bytesRemaining < retval.checksum.length + footer.length) {
            throw new IllegalArgumentException("Invalid bytes remaining field (" + retval.bytesRemaining + ")");
        }
        return retval;
    }

    public static OceanBinaryProtocolMessage parseByteStream(byte[] message) {
        int i;
        OceanBinaryProtocolMessage retval = OceanBinaryProtocolMessage.parseHeaderFromByteStream(message);
        retval.payload = new byte[retval.bytesRemaining - retval.checksum.length - footer.length];
        int offset = 44;
        for (i = 0; i < retval.payload.length; ++i) {
            retval.payload[i] = message[offset++];
        }
        for (i = 0; i < retval.checksum.length; ++i) {
            retval.checksum[i] = message[offset++];
        }
        for (i = 0; i < footer.length; ++i) {
            if (footer[i] == message[offset++]) continue;
            throw new IllegalArgumentException("Could not find message footer");
        }
        return retval;
    }

    public byte[] getData() {
        if (null != this.immediateData && 0 != this.immediateDataLength) {
            return this.immediateData;
        }
        if (null != this.payload && this.checksum.length + footer.length < this.bytesRemaining) {
            return this.payload;
        }
        return new byte[0];
    }

    public int getBytesRemaining() {
        return this.bytesRemaining;
    }

    public byte getChecksumType() {
        return this.checksumType;
    }

    public short getErrno() {
        return this.errorNumber;
    }

    public short getFlags() {
        return this.flags;
    }

    public byte[] getImmediateData() {
        return this.immediateData;
    }

    public byte getImmediateDataLength() {
        return this.immediateDataLength;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getRegarding() {
        return this.regarding;
    }

    public void setBytesRemaining(int bytesRemaining) {
        this.bytesRemaining = bytesRemaining;
    }

    public void setChecksumType(byte checksumType) {
        this.checksumType = checksumType;
    }

    public void setErrorNumber(short errorNumber) {
        this.errorNumber = errorNumber;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public void setAckRequestedFlag() {
        this.flags = (short)(this.flags | 4);
    }

    public boolean isNackFlagSet() {
        return (this.flags & 8) != 0;
    }

    public boolean isAckFlagSet() {
        return (this.flags & 2) != 0;
    }

    public void setImmediateData(byte[] immediateData) {
        this.immediateData = immediateData;
        if (null != immediateData) {
            this.immediateDataLength = immediateData.length <= 16 ? (byte)immediateData.length : (byte)16;
            this.setPayload(null);
        } else {
            this.immediateDataLength = 0;
        }
    }

    public void setImmediateDataLength(byte immediateDataLength) {
        this.immediateDataLength = immediateDataLength;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
        if (null != payload) {
            this.bytesRemaining = payload.length + this.checksum.length + footer.length;
            if (payload.length > 0) {
                this.setImmediateData(null);
            }
        } else {
            this.bytesRemaining = this.checksum.length + footer.length;
        }
    }

    public void setProtocolVersion(short protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setRegarding(int regarding) {
        this.regarding = regarding;
    }

    public static class MessageTypes {
        public static final int OBP_GET_FW_VERSION = 144;
        public static final int OBP_GET_SERIAL_NUMBER = 256;
        public static final int OBP_SET_SERIAL_NUMBER = 272;
        public static final int OBP_GET_SPECTRUM_NOW = 0x101000;
        public static final int OBP_SET_ITIME_USEC = 0x110010;
        public static final int OBP_SET_TRIG_MODE = 0x110110;
        public static final int OBP_SET_LAMP_ENABLE = 0x110410;
        public static final int OBP_SET_TRIG_DELAY_USEC = 0x110510;
        public static final int OBP_SET_SHUTTER = 0x110610;
        public static final int OBP_GET_WL_COEFF = 0x180101;
        public static final int OBP_SET_WL_COEFF = 0x180111;
        public static final int OBP_GET_NL_COEFF = 0x181101;
        public static final int OBP_SET_NL_COEFF = 0x181111;
        public static final int OBP_GET_IRRAD_CAL_ALL = 1581057;
        public static final int OBP_GET_IRRAD_CAL_COLL_AREA = 1581059;
        public static final int OBP_SET_IRRAD_CAL_ALL = 1581073;
        public static final int OBP_SET_IRRAD_CAL_COLL_AREA = 1581075;
        public static final int OBP_GET_STRAY_COEFF = 1585409;
        public static final int OBP_SET_STRAY_COEFF = 0x183111;
        public static final int OBP_GET_HOT_PIXEL_INDICES = 1597440;
        public static final int OBP_SET_HOT_PIXEL_INDICES = 1597456;
        public static final int OBP_GET_BENCH_ID = 0x1B0000;
        public static final int OBP_SET_BENCH_ID = 0x1B0010;
        public static final int OBP_GET_BENCH_SERIAL_NUMBER = 0x1B0100;
        public static final int OBP_SET_BENCH_SERIAL_NUMBER = 0x1B0110;
        public static final int OBP_GET_SLIT_WIDTH_MICRONS = 1769984;
        public static final int OBP_SET_SLIT_WIDTH_MICRONS = 1770000;
        public static final int OBP_GET_FIBER_DIAMETER_MICRONS = 1770240;
        public static final int OBP_SET_FIBER_DIAMETER_MICRONS = 1770256;
        public static final int OBP_GET_GRATING = 1770496;
        public static final int OBP_SET_GRATING = 1770512;
        public static final int OBP_GET_FILTER = 1770752;
        public static final int OBP_SET_FILTER = 1770768;
        public static final int OBP_GET_COATING = 1771008;
        public static final int OBP_SET_COATING = 1771024;
        public static final int OBP_GET_GPIO_OUTPUT_ENABLE = 0x200100;
        public static final int OBP_SET_GPIO_OUTPUT_ENABLE = 0x200110;
        public static final int OBP_GET_GPIO_VALUE = 0x200300;
        public static final int OBP_SET_GPIO_VALUE = 2097936;
        public static final int OBP_SET_SINGLE_STROBE_DELAY = 0x300010;
        public static final int OBP_SET_SINGLE_STROBE_WIDTH = 0x300011;
        public static final int OBP_SET_SINGLE_STROBE_ENABLE = 3145746;
        public static final int OBP_SET_CONT_STROBE_PERIOD = 0x310010;
        public static final int OBP_SET_CONT_STROBE_ENABLE = 0x310011;
        public static final int OBP_GET_TEMPERATURE = 0x400001;
    }
}

