/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.spectrometer.sts;

import com.oceanoptics.omnidriver.constants.ExternalTriggerMode;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemoval;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalGUIProvider;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalImpl;
import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalImpl_STS;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperature;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureGUIProvider;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureImpl;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureImpl_STS;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobe;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl_STS;
import com.oceanoptics.omnidriver.features.detectortemperature.DetectorTemperature;
import com.oceanoptics.omnidriver.features.detectortemperature.DetectorTemperatureGUIProvider;
import com.oceanoptics.omnidriver.features.detectortemperature.DetectorTemperatureImpl;
import com.oceanoptics.omnidriver.features.detectortemperature.DetectorTemperatureImpl_STS;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelay;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayGUIProvider;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayImpl;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayImpl_STS;
import com.oceanoptics.omnidriver.features.gpio.GPIO;
import com.oceanoptics.omnidriver.features.gpio.GPIOGUIProvider;
import com.oceanoptics.omnidriver.features.gpio.GPIOImpl;
import com.oceanoptics.omnidriver.features.gpio.GPIOImpl_STS;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTrigger;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl;
import com.oceanoptics.omnidriver.features.hardwaretrigger.HardwareTriggerImpl_STS;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactor;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorGUIProvider;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImpl;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImpl_STS;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobe;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeGUIProvider;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeImpl;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeImpl_STS;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionGUIProvider;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationGUIProvider;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerChannel;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.sts.OceanBinaryProtocolMessage;
import com.oceanoptics.omnidriver.spectrometer.sts.STSConfiguration;
import com.oceanoptics.omnidriver.spectrometer.sts.STSTriggerMode;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;

public class STS
extends USBSpectrometer
implements WavelengthCalibrationProvider,
SingleStrobe,
ContinuousStrobe,
GPIO,
ExternalTriggerDelay,
HardwareTrigger,
BoardTemperature,
DetectorTemperature,
BadPixelRemoval,
IrradianceCalibrationFactor {
    static Spectrometer[] scoreboard = new Spectrometer[64];
    private WavelengthCalibrationGUIProvider wavelength;
    private HardwareTrigger hardwareTrigger;
    private ExternalTriggerDelayGUIProvider triggerDelay;
    private SingleStrobeGUIProvider singleStrobe;
    private GPIOGUIProvider gpio;
    private ContinuousStrobeGUIProvider continuousStrobe;
    private BoardTemperatureGUIProvider boardTemperature;
    private DetectorTemperatureGUIProvider detectorTemperature;
    private NonlinearityCorrectionGUIProvider nonlinearity;
    private StrayLightCorrectionGUIProvider strayLight;
    private BadPixelRemovalGUIProvider badPixels;
    private IrradianceCalibrationFactorGUIProvider irradCal;
    private String serialNumber = new String();
    private static final short DATA_OUT = 1;
    private static final short DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 64;
    private static String __extern__ = "__extern__\n<init>,()V\n<init>,(I)V\nsetEndpoints,()V\nopenSpectrometer,(I)V\ngetFirmwareVersion,()Ljava/lang/String;\ngetInfo,(I)Ljava/lang/String;\ngetInfoBytes,(I)[B\ngetStatusArray,()[B\ninitialize,()V\nsetInfo,(ILjava/lang/String;)V\nsetInfoBytes,(I[B)V\nsetIntegrationTime,(I)V\nsetStrobeEnable,(Z)V\ngetGUIFeatures,()[Lcom/oceanoptics/omnidriver/interfaces/GUIProvider;\nreadBenchID,()[B\nwriteBenchID,([B)V\nreadBenchSerialNumber,()[B\nwriteBenchSerialNumber,([B)V\nreadSlitWidthMicrons,()Ljava/lang/Integer;\nwriteSlitWidthMicrons,(S)V\nreadFiberDiameterMicrons,()Ljava/lang/Integer;\nwriteFiberDiameterMicrons,(S)V\nreadGrating,()[B\nwriteGrating,([B)V\nreadCoating,()[B\nwriteCoating,([B)V\nreadFilter,()[B\nwriteFilter,([B)V\nqueryDevice,(I[B)[B\nsendCommandToDevice,(I[B)Z\ngetWavelengthCalibrationCoefficients,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\ngetWavelengths,(I)[D\nreadWavelengthCalibrationCoefficientsFromSpectrometer,()[Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetWavelengthCalibrationCoefficients,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\nsetWavelengths,([DI)V\nwriteWavelengthCoefficientsToSpectrometer,([Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;)V\ngetSingleStrobeCountsToMicros,(I)D\ngetSingleStrobeHigh,()I\ngetSingleStrobeIncrement,()I\ngetSingleStrobeLow,()I\ngetSingleStrobeMaximum,()I\ngetSingleStrobeMinimum,()I\nsetSingleStrobeHigh,(I)V\nsetSingleStrobeLow,(I)V\ncontinuousStrobeCountsToMicros,(I)D\ngetContinuousStrobeDelay,()Ljava/lang/Integer;\ngetContinuousStrobeDelayIncrement,(I)I\ngetContinuousStrobeDelayMaximum,()I\ngetContinuousStrobeDelayMinimum,()I\nsetContinuousStrobeDelay,(I)V\ngetDirectionBits,()Ljava/util/BitSet;\ngetMuxBits,()Ljava/util/BitSet;\ngetNumberOfPins,()I\ngetTotalGPIOBits,()I\ngetValueBit,(I)I\ngetValueBits,()Ljava/util/BitSet;\nsetDirectionAllBits,(Ljava/util/BitSet;)V\nsetDirectionBit,(IZ)V\nsetDirectionBitmask,(S)V\nsetMuxAllBits,(Ljava/util/BitSet;)V\nsetMuxBit,(IZ)V\nsetMuxBitmask,(S)V\nsetValueAllBits,(Ljava/util/BitSet;)V\nsetValueBit,(IZ)V\nsetValueBitmask,(S)V\ngetExternalTriggerDelay,()Ljava/lang/Integer;\ngetExternalTriggerDelayIncrement,()I\ngetExternalTriggerDelayMaximum,()I\ngetExternalTriggerDelayMinimum,()I\nsetExternalTriggerDelay,(I)V\ntriggerDelayCountsToMicroseconds,(I)D\ngetExternalTriggerMode,()Ljava/lang/Integer;\ngetExternalTriggerModes,()[Lcom/oceanoptics/omnidriver/constants/ExternalTriggerMode;\nsetExternalTriggerMode,(I)V\ngetBoardTemperatureCelsius,()D\ngetDetectorTemperatureCelsius,()D\ngetAllPixels,()[I\ngetBadPixels,()[I\ngetBadPixelsFromSpectrometer,()[I\ngetNumberOfBadPixels,()I\nremoveBadPixels,(Lcom/oceanoptics/omnidriver/spectra/Spectrum;)Lcom/oceanoptics/omnidriver/spectra/Spectrum;\nsetBadPixels,([I)V\nsetBadPixelsToSpectrometer,()V\ngetIrradianceCalibrationFactors,()[D\nsetIrradianceCalibrationFactors,([D)V\ngetCollectionArea,()D\nhasCollectionArea,()Z\nsetCollectionArea,(D)V\n";

    public STS() throws IOException {
        try {
            this.setEndpoints();
            this.openNextUnclaimedUSB();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public STS(int i) throws IOException {
        this.setEndpoints();
        this.openSpectrometer(i);
    }

    public void setEndpoints() {
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 64, 0);
        this.highSpeedInEndPoint1 = new USBEndpointDescriptor(7, 5, 129, 2, 64, 0);
        this.highSpeedInEndPoint2 = new USBEndpointDescriptor(7, 5, 129, 2, 64, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 64, 0);
    }

    protected Spectrometer[] getScoreboard() {
        return scoreboard;
    }

    public void openSpectrometer(int index) throws IOException {
        this.integrationTimeMinimum = 10;
        this.integrationTimeMaximum = 85000000;
        this.integrationTimeIncrement = 1;
        this.integrationTimeBase = 1;
        this.numberOfCCDPixels = 1024;
        this.numberOfDarkCCDPixels = 0;
        this.maxIntensity = 16383;
        this.pipeSize = this.numberOfCCDPixels * 2 + 64;
        this.rawData = new byte[this.pipeSize];
        this.channels = new SpectrometerChannel[]{new SpectrometerChannel(this, new Coefficients(), 0)};
        this.numChannels = 1;
        this.productID = 16384;
        this.stabilityScan = false;
        this.usb.openDevice(this.vendorID, this.productID, index);
        this.deviceIndex = index;
        this.initFeatures(this.usb);
        this.finishConstruction();
        this.configuration = new STSConfiguration(this);
    }

    private void initFeatures(USBInterface usb) throws IOException {
        this.hardwareTrigger = new HardwareTriggerImpl_STS(this, usb, new STSTriggerMode[]{new STSTriggerMode(0), new STSTriggerMode(1), new STSTriggerMode(2)});
        this.featureMap.put(HardwareTriggerImpl.class, (HardwareTriggerImpl)this.hardwareTrigger);
        this.triggerDelay = new ExternalTriggerDelayImpl_STS(this, usb);
        this.featureMap.put(ExternalTriggerDelayImpl.class, (ExternalTriggerDelayImpl)this.triggerDelay);
        this.gpio = new GPIOImpl_STS(this, usb);
        this.featureMap.put(GPIOImpl.class, (GPIOImpl)this.gpio);
        this.singleStrobe = new SingleStrobeImpl_STS(this, usb);
        this.featureMap.put(SingleStrobeImpl.class, (SingleStrobeImpl)this.singleStrobe);
        this.continuousStrobe = new ContinuousStrobeImpl_STS(this, usb);
        this.featureMap.put(ContinuousStrobeImpl.class, (ContinuousStrobeImpl)this.continuousStrobe);
        this.wavelength = new WavelengthCalibrationImpl(usb, this);
        this.featureMap.put(WavelengthCalibrationImpl.class, (WavelengthCalibrationImpl)this.wavelength);
        this.nonlinearity = new NonlinearityCorrectionImpl(usb, this);
        this.featureMap.put(NonlinearityCorrectionImpl.class, (NonlinearityCorrectionImpl)this.nonlinearity);
        this.strayLight = new StrayLightCorrectionImpl(usb, this);
        this.featureMap.put(StrayLightCorrectionImpl.class, (StrayLightCorrectionImpl)this.strayLight);
        this.boardTemperature = new BoardTemperatureImpl_STS(this, usb);
        this.featureMap.put(BoardTemperatureImpl.class, (BoardTemperatureImpl)this.boardTemperature);
        this.detectorTemperature = new DetectorTemperatureImpl_STS(this, usb);
        this.featureMap.put(DetectorTemperatureImpl.class, (DetectorTemperatureImpl)this.detectorTemperature);
        this.badPixels = new BadPixelRemovalImpl_STS(this, usb, this.numberOfCCDPixels);
        this.featureMap.put(BadPixelRemovalImpl.class, (BadPixelRemovalImpl)this.badPixels);
        this.irradCal = new IrradianceCalibrationFactorImpl_STS(this, usb);
        this.featureMap.put(IrradianceCalibrationFactorImpl.class, (IrradianceCalibrationFactorImpl)this.irradCal);
    }

    protected byte[] readSerialNumber() throws IOException {
        byte[] data = this.queryDevice(256, null);
        return data;
    }

    protected void writeSerialNumber(byte[] sn) throws IOException {
        boolean success = this.sendCommandToDevice(272, sn);
        if (!success) {
            throw new IOException("Failed to set serial number.");
        }
    }

    protected float readWavelengthCoeff(int order) throws IOException {
        byte[] data = this.queryDevice(0x180101, new byte[]{(byte)order});
        if (null == data || data.length < 4) {
            switch (order) {
                case 1: {
                    return 1.0f;
                }
            }
            return 0.0f;
        }
        int temp = ByteRoutines.makeDWord((byte)data[3], (byte)data[2], (byte)data[1], (byte)data[0]);
        float retval = Float.intBitsToFloat(temp);
        return retval;
    }

    protected void writeWavelengthCoeff(byte[] raw, int order) throws IOException {
        byte[] data = new byte[5];
        String str = new String();
        for (int i = 0; i < raw.length; ++i) {
            str = str + (char)raw[i];
        }
        float f = Float.parseFloat(str);
        int fbytes = Float.floatToRawIntBits(f);
        data[0] = (byte)order;
        data[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)fbytes));
        data[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)fbytes));
        data[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)fbytes));
        data[4] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)fbytes));
        boolean success = this.sendCommandToDevice(0x180111, data);
        if (!success) {
            throw new IOException("Failed to write wavelength coefficient.");
        }
    }

    protected float readNonlinearityCoeff(int order) throws IOException {
        byte[] data = this.queryDevice(0x181101, new byte[]{(byte)order});
        if (null == data || data.length < 4) {
            switch (order) {
                case 1: {
                    return 1.0f;
                }
            }
            return 0.0f;
        }
        int temp = ByteRoutines.makeDWord((byte)data[3], (byte)data[2], (byte)data[1], (byte)data[0]);
        float retval = Float.intBitsToFloat(temp);
        return retval;
    }

    protected void writeNonlinearityCoeff(byte[] raw, int order) throws IOException {
        byte[] data = new byte[5];
        String str = new String();
        for (int i = 0; i < raw.length; ++i) {
            str = str + (char)raw[i];
        }
        float f = Float.parseFloat(str);
        int fbytes = Float.floatToRawIntBits(f);
        data[0] = (byte)order;
        data[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)fbytes));
        data[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)fbytes));
        data[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)fbytes));
        data[4] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)fbytes));
        boolean success = this.sendCommandToDevice(0x181111, data);
        if (!success) {
            throw new IOException("Failed to write wavelength coefficient.");
        }
    }

    protected float readStrayLightCoeff(int order) throws IOException {
        byte[] data = this.queryDevice(1585409, new byte[]{(byte)order});
        if (null == data || data.length < 4) {
            return 0.0f;
        }
        int temp = ByteRoutines.makeDWord((byte)data[3], (byte)data[2], (byte)data[1], (byte)data[0]);
        float retval = Float.intBitsToFloat(temp);
        return retval;
    }

    protected void writeStrayLightCoeff(byte[] raw, int order) throws IOException {
        byte[] data = new byte[5];
        String str = new String();
        for (int i = 0; i < raw.length; ++i) {
            str = str + (char)raw[i];
        }
        float f = Float.parseFloat(str);
        int fbytes = Float.floatToRawIntBits(f);
        data[0] = (byte)order;
        data[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)fbytes));
        data[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)fbytes));
        data[3] = ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)fbytes));
        data[4] = ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)fbytes));
        boolean success = this.sendCommandToDevice(0x183111, data);
        if (!success) {
            throw new IOException("Failed to write wavelength coefficient.");
        }
    }

    public String getFirmwareVersion() throws IOException {
        byte[] payload = this.queryDevice(144, null);
        if (null != payload && payload.length > 1) {
            return Integer.toHexString(payload[1]) + "." + Integer.toHexString(payload[0]);
        }
        return new String();
    }

    public String getInfo(int slot) throws IOException {
        byte[] bytes = this.getInfoBytes(slot);
        if (null == bytes) {
            bytes = new byte[]{};
        }
        String retval = new String();
        for (int i = 0; i < bytes.length && bytes[i] != 0; ++i) {
            retval = retval + (char)bytes[i];
        }
        return retval;
    }

    public byte[] getInfoBytes(int slot) throws IOException {
        byte[] retval = new byte[]{};
        float coeff = 0.0f;
        switch (slot) {
            case 0: {
                retval = this.readSerialNumber();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                coeff = this.readWavelengthCoeff(slot - 1);
                retval = Float.toString(coeff).getBytes("US-ASCII");
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                coeff = this.readNonlinearityCoeff(slot - 6);
                retval = Float.toString(coeff).getBytes("US-ASCII");
                break;
            }
            case 14: {
                retval = "7".getBytes("US-ASCII");
                break;
            }
            case 5: {
                coeff = this.readStrayLightCoeff(0);
                retval = Float.toString(coeff).getBytes("US-ASCII");
                break;
            }
            default: {
                retval = Float.toString(0.0f).getBytes("US-ASCII");
            }
        }
        return retval;
    }

    public byte[] getStatusArray() throws IOException {
        return new byte[0];
    }

    public void initialize() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestSpectrum() throws IOException {
        OceanBinaryProtocolMessage request = new OceanBinaryProtocolMessage();
        request.setMessageType(0x101000);
        byte[] stream = request.toByteStream();
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.usb.bulkOut(this.dataOutEndPoint, stream, stream.length);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void setInfo(int slot, String str) throws IOException {
        this.setInfoBytes(slot, str.getBytes("US-ASCII"));
    }

    public void setInfoBytes(int slot, byte[] byteArray) throws IOException {
        switch (slot) {
            case 0: {
                this.writeSerialNumber(byteArray);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.writeWavelengthCoeff(byteArray, slot - 1);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.writeNonlinearityCoeff(byteArray, slot - 6);
                break;
            }
            case 14: {
                break;
            }
            case 5: {
                this.writeStrayLightCoeff(byteArray, 0);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
    }

    public void setIntegrationTime(int intTime) throws IOException {
        int maxTime = this.getIntegrationTimeMaximum();
        int minTime = this.getIntegrationTimeMinimum();
        if (intTime < minTime) {
            intTime = minTime;
        } else if (intTime > maxTime) {
            intTime = maxTime;
        }
        intTime -= intTime % this.getIntegrationTimeIncrement();
        this.integrationTime = intTime;
        byte[] iData = new byte[]{ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)(intTime /= this.getIntegrationTimeBase()))), ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)intTime)), ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)intTime)), ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)intTime))};
        boolean success = this.sendCommandToDevice(0x110010, iData);
        if (!success) {
            throw new IOException("Failed to set integration time.");
        }
    }

    private void setShutterOpen(boolean open) throws IOException {
        byte[] state = new byte[]{(byte)(open ? 1 : 0)};
        this.sendCommandToDevice(0x110610, state);
    }

    private void setLampEnable(boolean enable) throws IOException {
        byte[] state = new byte[]{(byte)(enable ? 1 : 0)};
        boolean success = this.sendCommandToDevice(0x110410, state);
        if (!success) {
            throw new IOException("Failed to set integration time.");
        }
    }

    private void setSingleStrobeEnable(boolean enable) throws IOException {
        byte[] state = new byte[]{(byte)(enable ? 1 : 0)};
        boolean success = this.sendCommandToDevice(3145746, state);
        if (!success) {
            throw new IOException("Failed to set integration time.");
        }
    }

    private void setContinuousStrobeEnable(boolean enable) throws IOException {
        byte[] state = new byte[]{(byte)(enable ? 1 : 0)};
        boolean success = this.sendCommandToDevice(0x310011, state);
        if (!success) {
            throw new IOException("Failed to set integration time.");
        }
    }

    public void setStrobeEnable(boolean enable) throws IOException {
        this.setLampEnable(enable);
        this.setShutterOpen(enable);
        this.setSingleStrobeEnable(enable);
        this.setContinuousStrobeEnable(enable);
    }

    protected Spectrum formatData(byte[] raw, Spectrum spec) throws IOException {
        byte zero = 0;
        double[] spectrum = spec.getSpectrum();
        this.logger.finest("Formatting data");
        double saturationValue = this.getMaxIntensity();
        spec.setSaturated(false);
        OceanBinaryProtocolMessage obp = OceanBinaryProtocolMessage.parseByteStream(raw);
        byte[] data = obp.getData();
        for (int i = 0; i < this.numberOfCCDPixels; ++i) {
            byte LSB = data[2 * i];
            byte MSB = data[2 * i + 1];
            int pixel = ByteRoutines.makeDWord((byte)zero, (byte)zero, (byte)MSB, (byte)LSB);
            spectrum[i] = pixel;
            if ((double)pixel >= saturationValue) {
                spec.setSaturated(true);
                pixel = (int)saturationValue;
            }
            spectrum[i] = pixel;
        }
        this.badPixels.removeBadPixels(spec);
        return spec;
    }

    public GUIProvider[] getGUIFeatures() {
        Vector<GUIProvider> features = new Vector<GUIProvider>();
        features.add(this.wavelength);
        features.add(this.nonlinearity);
        features.add(this.strayLight);
        features.add(this.singleStrobe);
        features.add(this.continuousStrobe);
        features.add(this.triggerDelay);
        features.add(this.gpio);
        features.add(this.boardTemperature);
        features.add(this.detectorTemperature);
        features.add(this.badPixels);
        return features.toArray(new GUIProvider[0]);
    }

    public byte[] readBenchID() throws IOException {
        return this.queryDevice(0x1B0000, null);
    }

    public void writeBenchID(byte[] id) throws IOException {
        boolean success = this.sendCommandToDevice(0x1B0010, id);
        if (!success) {
            throw new IOException("Failed to set bench ID.");
        }
    }

    public byte[] readBenchSerialNumber() throws IOException {
        return this.queryDevice(0x1B0100, null);
    }

    public void writeBenchSerialNumber(byte[] sn) throws IOException {
        boolean success = this.sendCommandToDevice(0x1B0110, sn);
        if (!success) {
            throw new IOException("Failed to set bench serial number.");
        }
    }

    public Integer readSlitWidthMicrons() throws IOException {
        byte[] data = this.queryDevice(1769984, null);
        if (null == data || data.length < 2) {
            return null;
        }
        return new Integer(ByteRoutines.makeWord((byte)data[1], (byte)data[0]));
    }

    public void writeSlitWidthMicrons(short microns) throws IOException {
        byte[] payload = new byte[]{(byte)(microns & 0xFF), (byte)(microns >> 8 & 0xFF)};
        boolean success = this.sendCommandToDevice(1770000, payload);
        if (!success) {
            throw new IOException("Failed to set slit width.");
        }
    }

    public Integer readFiberDiameterMicrons() throws IOException {
        byte[] data = this.queryDevice(1770240, null);
        if (null == data || data.length < 2) {
            return null;
        }
        return new Integer(ByteRoutines.makeWord((byte)data[1], (byte)data[0]));
    }

    public void writeFiberDiameterMicrons(short microns) throws IOException {
        byte[] payload = new byte[]{(byte)(microns & 0xFF), (byte)(microns >> 8 & 0xFF)};
        boolean success = this.sendCommandToDevice(1770256, payload);
        if (!success) {
            throw new IOException("Failed to set fiber diameter.");
        }
    }

    public byte[] readGrating() throws IOException {
        return this.queryDevice(1770496, null);
    }

    public void writeGrating(byte[] grating) throws IOException {
        boolean success = this.sendCommandToDevice(1770512, grating);
        if (!success) {
            throw new IOException("Failed to set grating.");
        }
    }

    public byte[] readCoating() throws IOException {
        return this.queryDevice(1771008, null);
    }

    public void writeCoating(byte[] coating) throws IOException {
        boolean success = this.sendCommandToDevice(1771024, coating);
        if (!success) {
            throw new IOException("Failed to set coating.");
        }
    }

    public byte[] readFilter() throws IOException {
        return this.queryDevice(1770752, null);
    }

    public void writeFilter(byte[] filter) throws IOException {
        boolean success = this.sendCommandToDevice(1770768, filter);
        if (!success) {
            throw new IOException("Failed to set coating.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] queryDevice(int messageType, byte[] payload) throws IOException {
        OceanBinaryProtocolMessage request = new OceanBinaryProtocolMessage();
        request.setMessageType(messageType);
        if (null != payload) {
            if (payload.length <= 16) {
                request.setImmediateData(payload);
            } else {
                request.setPayload(payload);
            }
        }
        byte[] stream = request.toByteStream();
        OceanBinaryProtocolMessage response = null;
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.usb.bulkOut(this.dataOutEndPoint, stream, stream.length);
                byte[] headerBuffer = new byte[64];
                byte[] fullBuffer = null;
                this.usb.bulkIn(this.lowSpeedInEndPoint, headerBuffer, headerBuffer.length);
                response = OceanBinaryProtocolMessage.parseHeaderFromByteStream(headerBuffer);
                if (null == response || response.getMessageType() != messageType || response.isNackFlagSet()) {
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return null;
                }
                int bytesToRead = response.getBytesRemaining() - 20;
                if (bytesToRead > 0) {
                    fullBuffer = new byte[bytesToRead + headerBuffer.length];
                    System.arraycopy(headerBuffer, 0, fullBuffer, 0, headerBuffer.length);
                    byte[] extended = new byte[bytesToRead];
                    this.usb.bulkIn(this.lowSpeedInEndPoint, extended, extended.length);
                    System.arraycopy(extended, 0, fullBuffer, headerBuffer.length, extended.length);
                } else {
                    fullBuffer = headerBuffer;
                }
                response = OceanBinaryProtocolMessage.parseByteStream(fullBuffer);
                // ** MonitorExit[var7_7] (shouldn't be in output)
            }
            {
                if (null != response) {
                    return response.getData();
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendCommandToDevice(int messageType, byte[] payload) throws IOException {
        OceanBinaryProtocolMessage request = new OceanBinaryProtocolMessage();
        request.setMessageType(messageType);
        request.setAckRequestedFlag();
        if (null != payload) {
            if (payload.length <= 16) {
                request.setImmediateData(payload);
            } else {
                request.setPayload(payload);
            }
        }
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                byte[] stream = request.toByteStream();
                this.usb.bulkOut(this.dataOutEndPoint, stream, stream.length);
                byte[] rawResponse = new byte[64];
                this.usb.bulkIn(this.lowSpeedInEndPoint, rawResponse, rawResponse.length);
                OceanBinaryProtocolMessage response = OceanBinaryProtocolMessage.parseHeaderFromByteStream(rawResponse);
                if (null == response || response.getMessageType() != messageType || response.isNackFlagSet()) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return false;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSpectrum() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                super.readSpectrum();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readSpectrum(byte[] data) throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                super.readSpectrum(data);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
            return;
        }
    }

    public Coefficients[] getWavelengthCalibrationCoefficients() {
        return this.wavelength.getWavelengthCalibrationCoefficients();
    }

    public double[] getWavelengths(int index) {
        return this.wavelength.getWavelengths(index);
    }

    public Coefficients[] readWavelengthCalibrationCoefficientsFromSpectrometer() {
        return this.wavelength.readWavelengthCalibrationCoefficientsFromSpectrometer();
    }

    public void setWavelengthCalibrationCoefficients(Coefficients[] coefficients) {
        this.wavelength.setWavelengthCalibrationCoefficients(coefficients);
    }

    public void setWavelengths(double[] wavelengths, int index) {
        this.wavelength.setWavelengths(wavelengths, index);
    }

    public void writeWavelengthCoefficientsToSpectrometer(Coefficients[] coefficients) throws IOException {
        this.wavelength.writeWavelengthCoefficientsToSpectrometer(coefficients);
    }

    public double getSingleStrobeCountsToMicros(int counts) {
        return this.singleStrobe.getSingleStrobeCountsToMicros(counts);
    }

    public int getSingleStrobeHigh() throws IOException {
        return this.singleStrobe.getSingleStrobeHigh();
    }

    public int getSingleStrobeIncrement() {
        return this.singleStrobe.getSingleStrobeIncrement();
    }

    public int getSingleStrobeLow() throws IOException {
        return this.singleStrobe.getSingleStrobeLow();
    }

    public int getSingleStrobeMaximum() {
        return this.singleStrobe.getSingleStrobeMaximum();
    }

    public int getSingleStrobeMinimum() {
        return this.singleStrobe.getSingleStrobeMinimum();
    }

    public void setSingleStrobeHigh(int counts) throws IOException {
        this.singleStrobe.setSingleStrobeHigh(counts);
    }

    public void setSingleStrobeLow(int counts) throws IOException {
        this.singleStrobe.setSingleStrobeLow(counts);
    }

    public double continuousStrobeCountsToMicros(int counts) {
        return this.continuousStrobe.continuousStrobeCountsToMicros(counts);
    }

    public Integer getContinuousStrobeDelay() {
        return this.continuousStrobe.getContinuousStrobeDelay();
    }

    public int getContinuousStrobeDelayIncrement(int magnitude) {
        return this.continuousStrobe.getContinuousStrobeDelayIncrement(magnitude);
    }

    public int getContinuousStrobeDelayMaximum() {
        return this.continuousStrobe.getContinuousStrobeDelayMaximum();
    }

    public int getContinuousStrobeDelayMinimum() {
        return this.continuousStrobe.getContinuousStrobeDelayMinimum();
    }

    public void setContinuousStrobeDelay(int durationOfPhase) throws IOException {
        this.continuousStrobe.setContinuousStrobeDelay(durationOfPhase);
    }

    public BitSet getDirectionBits() throws IOException {
        return this.gpio.getDirectionBits();
    }

    public BitSet getMuxBits() throws IOException {
        return this.gpio.getMuxBits();
    }

    public int getNumberOfPins() {
        return this.gpio.getNumberOfPins();
    }

    public int getTotalGPIOBits() {
        return this.gpio.getTotalGPIOBits();
    }

    public int getValueBit(int bitNumber) throws IOException {
        return this.gpio.getValueBit(bitNumber);
    }

    public BitSet getValueBits() throws IOException {
        return this.gpio.getValueBits();
    }

    public void setDirectionAllBits(BitSet bitSet) throws IOException {
        this.gpio.setDirectionAllBits(bitSet);
    }

    public void setDirectionBit(int bit, boolean value) throws IOException {
        this.gpio.setDirectionBit(bit, value);
    }

    public void setDirectionBitmask(short bitmask) throws IOException {
        this.gpio.setDirectionBitmask(bitmask);
    }

    public void setMuxAllBits(BitSet bitSet) throws IOException {
        this.gpio.setMuxAllBits(bitSet);
    }

    public void setMuxBit(int bit, boolean value) throws IOException {
        this.gpio.setMuxBit(bit, value);
    }

    public void setMuxBitmask(short bitmask) throws IOException {
        this.gpio.setMuxBitmask(bitmask);
    }

    public void setValueAllBits(BitSet bitSet) throws IOException {
        this.gpio.setValueAllBits(bitSet);
    }

    public void setValueBit(int bit, boolean value) throws IOException {
        this.gpio.setValueBit(bit, value);
    }

    public void setValueBitmask(short bitmask) throws IOException {
        this.gpio.setValueBitmask(bitmask);
    }

    public Integer getExternalTriggerDelay() {
        return this.triggerDelay.getExternalTriggerDelay();
    }

    public int getExternalTriggerDelayIncrement() {
        return this.triggerDelay.getExternalTriggerDelayIncrement();
    }

    public int getExternalTriggerDelayMaximum() {
        return this.triggerDelay.getExternalTriggerDelayMaximum();
    }

    public int getExternalTriggerDelayMinimum() {
        return this.triggerDelay.getExternalTriggerDelayMinimum();
    }

    public void setExternalTriggerDelay(int counts) throws IOException {
        this.triggerDelay.setExternalTriggerDelay(counts);
    }

    public double triggerDelayCountsToMicroseconds(int counts) {
        return this.triggerDelay.triggerDelayCountsToMicroseconds(counts);
    }

    public Integer getExternalTriggerMode() {
        return this.hardwareTrigger.getExternalTriggerMode();
    }

    public ExternalTriggerMode[] getExternalTriggerModes() {
        return this.hardwareTrigger.getExternalTriggerModes();
    }

    public void setExternalTriggerMode(int mode) throws IOException {
        this.hardwareTrigger.setExternalTriggerMode(mode);
    }

    public double getBoardTemperatureCelsius() throws IOException {
        return this.boardTemperature.getBoardTemperatureCelsius();
    }

    public double getDetectorTemperatureCelsius() throws IOException {
        return this.detectorTemperature.getDetectorTemperatureCelsius();
    }

    public int[] getAllPixels() {
        return this.badPixels.getAllPixels();
    }

    public int[] getBadPixels() throws IOException {
        return this.badPixels.getBadPixels();
    }

    public int[] getBadPixelsFromSpectrometer() throws IOException {
        return this.badPixels.getBadPixelsFromSpectrometer();
    }

    public int getNumberOfBadPixels() {
        return this.badPixels.getNumberOfBadPixels();
    }

    public Spectrum removeBadPixels(Spectrum spectrum) throws IOException {
        return this.badPixels.removeBadPixels(spectrum);
    }

    public void setBadPixels(int[] pixels) throws IOException {
        this.badPixels.setBadPixels(pixels);
    }

    public void setBadPixelsToSpectrometer() throws IOException {
        this.badPixels.setBadPixelsToSpectrometer();
    }

    public double[] getIrradianceCalibrationFactors() throws IOException {
        return this.irradCal.getIrradianceCalibrationFactors();
    }

    public void setIrradianceCalibrationFactors(double[] data) throws IOException {
        this.irradCal.setIrradianceCalibrationFactors(data);
    }

    public double getCollectionArea() throws IOException {
        return this.irradCal.getCollectionArea();
    }

    public boolean hasCollectionArea() {
        return this.irradCal.hasCollectionArea();
    }

    public void setCollectionArea(double area) throws IOException {
        this.irradCal.setCollectionArea(area);
    }
}

