/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.tests;

import com.oceanoptics.omnidriver.accessories.mikropack.commands.Node;
import com.oceanoptics.omnidriver.accessories.mikropack.devices.MPM2000;
import com.oceanoptics.omnidriver.accessories.mikropack.devices.MappingTable;
import com.oceanoptics.omnidriver.accessories.mikropack.devices.MonoScan2000;
import com.oceanoptics.omnidriver.accessories.mikropack.exceptions.TimeoutException;
import com.oceanoptics.unirs232.UniRS232;
import com.oceanoptics.utilities.OSInformation;
import java.io.IOException;
import java.util.Random;

public class MPProductTest {
    UniRS232 serPort;
    private static String __extern__ = "__extern__\nmain,([Ljava/lang/String;)V\n<init>,()V\n";

    public static void main(String[] args) {
        MPProductTest mp = new MPProductTest();
    }

    public MPProductTest() {
        try {
            this.serPort = new UniRS232();
            long port = 0L;
            if (OSInformation.isMac()) {
                port = this.serPort.openPort("/dev/tty.KeySerial1");
            } else if (OSInformation.isLinux()) {
                port = this.serPort.openPort("/dev/ttyUSB0");
            } else if (OSInformation.isWindows()) {
                if (OSInformation.is64Bit()) {
                    System.err.println("You are 64");
                    port = this.serPort.openPort("COM4");
                } else {
                    System.err.println("in 32 bit");
                    port = this.serPort.openPort("COM4");
                }
            }
            System.err.println("port is " + port);
            this.serPort.setBaudRate(9600);
            this.serPort.setDataBits((byte)8);
            this.serPort.setStopBits((byte)1);
            this.serPort.setFlowControl((byte)0);
            this.serPort.setParity((byte)0);
            this.serPort.setReadTimeout(1000);
            System.err.println("after setting params");
            this.testMPM();
            this.serPort.closePort();
        }
        catch (Exception e) {
            System.err.println("exception");
            e.printStackTrace();
        }
    }

    private void testMappingTable() throws IOException, InterruptedException, TimeoutException {
        MappingTable mp = new MappingTable(this.serPort);
        Random r = new Random(System.currentTimeMillis());
        for (int i = 0; i < 1000; ++i) {
            for (int axis = 1; axis < 4; ++axis) {
                double newPos = r.nextDouble() * -100.0;
                System.err.println("moving " + axis + " to " + newPos);
                mp.moveToMMAndWait(axis, newPos);
            }
        }
    }

    private void testMPM2000Sequential() throws IOException, InterruptedException, TimeoutException {
        MPM2000 ms = new MPM2000(this.serPort);
        ms.goToIndex(1);
        for (int i = 0; i < 30; ++i) {
            ms.shiftIndex(1);
            System.err.println("current index is now " + ms.getCurrentIndex());
            Thread.sleep(100L);
        }
    }

    private void testMonoScanSpeed() throws IOException, InterruptedException, TimeoutException {
        MonoScan2000 ms = new MonoScan2000(this.serPort);
        int speed = 300;
        ms.setSpeed(Node.SINGLE(), speed);
        ms.goToWavelength(200.0);
        long start = System.currentTimeMillis();
        int startPos = ms.getPosition(Node.SINGLE());
        ms.goToWavelength(1000.0);
        long end = System.currentTimeMillis();
        int endPos = ms.getPosition(Node.SINGLE());
        long time = end - start;
        System.err.println("speed " + ms.getSpeed(Node.SINGLE()) + " took " + (end - start) + " msec " + (endPos - startPos) + " encoder ticks");
        start = System.currentTimeMillis();
        startPos = ms.getPosition(Node.SINGLE());
        ms.setSpeed(Node.SINGLE(), 250);
        ms.goToWavelength(200.0);
        end = System.currentTimeMillis();
        endPos = ms.getPosition(Node.SINGLE());
        time = end - start;
        System.err.println("speed " + ms.getSpeed(Node.SINGLE()) + " took " + (end - start) + " msec " + (endPos - startPos) + " encoder ticks");
        start = System.currentTimeMillis();
        startPos = ms.getPosition(Node.SINGLE());
        ms.setSpeed(Node.SINGLE(), 200);
        ms.goToWavelength(1000.0);
        end = System.currentTimeMillis();
        endPos = ms.getPosition(Node.SINGLE());
        time = end - start;
        System.err.println("speed " + ms.getSpeed(Node.SINGLE()) + " took " + (end - start) + " msec " + (endPos - startPos) + " encoder ticks");
        start = System.currentTimeMillis();
        startPos = ms.getPosition(Node.SINGLE());
        ms.setSpeed(Node.SINGLE(), 150);
        ms.goToWavelength(200.0);
        end = System.currentTimeMillis();
        endPos = ms.getPosition(Node.SINGLE());
        time = end - start;
        System.err.println("speed " + ms.getSpeed(Node.SINGLE()) + " took " + (end - start) + " msec " + (endPos - startPos) + " encoder ticks");
        start = System.currentTimeMillis();
        startPos = ms.getPosition(Node.SINGLE());
        ms.setSpeed(Node.SINGLE(), 100);
        ms.goToWavelength(1000.0);
        end = System.currentTimeMillis();
        endPos = ms.getPosition(Node.SINGLE());
        time = end - start;
        System.err.println("speed " + ms.getSpeed(Node.SINGLE()) + " took " + (end - start) + " msec " + (endPos - startPos) + " encoder ticks");
        start = System.currentTimeMillis();
        startPos = ms.getPosition(Node.SINGLE());
        ms.setSpeed(Node.SINGLE(), 50);
        ms.goToWavelength(200.0);
        end = System.currentTimeMillis();
        endPos = ms.getPosition(Node.SINGLE());
        time = end - start;
        System.err.println("speed " + ms.getSpeed(Node.SINGLE()) + " took " + (end - start) + " msec " + (endPos - startPos) + " encoder ticks");
    }

    private void testMonoScanRandom() throws IOException, InterruptedException, TimeoutException {
        MonoScan2000 ms = new MonoScan2000(this.serPort);
        Random r = new Random(System.currentTimeMillis());
        for (int i = 0; i < 30; ++i) {
            double newWL = 200.0 + r.nextDouble() * 800.0;
            ms.goToWavelength(newWL);
            Thread.sleep(500L);
        }
    }

    private void testMonoScan() throws IOException, InterruptedException, TimeoutException {
        MonoScan2000 ms = new MonoScan2000(this.serPort);
        for (int loop = 0; loop < 1; ++loop) {
            for (int i = 200; i < 1001; i += 20) {
                System.err.println("going to " + i);
                ms.goToWavelength(i);
            }
            ms.goToWavelength(200.0);
        }
    }

    private void testMPM() throws IOException, InterruptedException, TimeoutException {
        MPM2000 mpm = new MPM2000(this.serPort);
        System.err.println("serial number is " + mpm.getSerialNumber());
        Random r = new Random(System.currentTimeMillis());
        for (int loop = 0; loop < 1; ++loop) {
            System.err.println("LOOP NUMBER " + loop + " ==============");
            for (int i = 1; i <= 16; ++i) {
                int targetIndex = 1 + (int)(r.nextDouble() * 17.0);
                System.err.println("moving to " + targetIndex);
                mpm.goToIndex(targetIndex);
            }
        }
    }

    private void testMappingTableSpeed() throws IOException, InterruptedException, TimeoutException {
        MappingTable mt = new MappingTable(this.serPort);
        int speed = 300;
        Node testAxis = Node.XAXIS();
        mt.setSpeed(testAxis, 1000);
        mt.moveToMM(testAxis, 0.0);
        boolean atZero = true;
        long start = System.currentTimeMillis();
        for (int axis = 1; axis < 4; ++axis) {
            testAxis.setIndex(axis);
            for (speed = 1000; speed > 500; speed -= 100) {
                mt.setSpeed(testAxis, speed);
                start = System.currentTimeMillis();
                int startPos = mt.getPosition(testAxis);
                int newPos = startPos > -1000 ? -30100 : -100;
                mt.loadAbsolutePosition(testAxis, newPos);
                mt.moveAndWait(testAxis);
                long end = System.currentTimeMillis();
                int endPos = mt.getPosition(testAxis);
                long time = end - start;
                double factor = (double)speed / ((double)(endPos - startPos) / (double)time);
                System.err.println("Axis " + testAxis.getDesc() + "\tspeed\t" + speed + "\t" + (end - start) + "\tmsec\t" + (endPos - startPos) + "\tencoder ticks\tFactor\t" + Math.abs(factor));
            }
            mt.loadAbsolutePosition(testAxis, -100);
            mt.moveAndWait(testAxis);
        }
    }
}

