/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.accessories.mikropack.commands;

import com.oceanoptics.omnidriver.accessories.mikropack.commands.Node;
import com.oceanoptics.omnidriver.interfaces.GUIProvider;
import com.oceanoptics.unirs232.UniRS232;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class FaulhaberCommandBase
implements GUIProvider {
    protected byte[] in = null;
    protected UniRS232 serialPort = null;
    protected Logger logger = Logger.getLogger("Mikropack");
    protected int maxIntegerLength;
    protected int lastReadTimeout = 0;
    protected int defaultReadTimeout = 1000;
    protected String commandBase;
    protected String commandParameter;
    protected String commandBuffer;
    protected String commandName;
    private int defaultPostCommandSleep = 50;
    private Node cmdNode;
    protected String panelPath = "com.oceanoptics.omnidriver.guisupport.accessories.mikropack.panels.";
    private String panelClass;
    private String panelPackage;
    private static String __extern__ = "__extern__\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n<init>,(Lcom/oceanoptics/unirs232/UniRS232;)V\ngetCommandName,(Ljava/lang/Object;)Ljava/lang/String;\ngetNode,()Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;\nsetNode,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;)V\ngetNodeString,()Ljava/lang/String;\nsetSerialPort,(Lcom/oceanoptics/unirs232/UniRS232;)V\ngetCommandBuffer,()Ljava/lang/String;\nsetInputBufferSize,(I)V\nsendCommand,(Ljava/lang/String;)I\nsendCommandSlow,(Ljava/lang/String;I)I\nsendCommand,([B)I\nsendCommandSlow,([BI)I\n";

    public String[] getFeatureGUIClassnames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FaulhaberCommandBase(UniRS232 serPort) throws IOException {
        this.in = new byte[10];
        this.serialPort = serPort;
        this.serialPort.setReadTimeout(this.defaultReadTimeout);
        this.lastReadTimeout = this.defaultReadTimeout;
        Integer i = new Integer(Integer.MAX_VALUE);
        this.maxIntegerLength = i.toString().length() + 3;
        this.cmdNode = Node.SINGLE();
        this.commandParameter = new String("");
        String commandClass = this.getClass().toString();
        String commandPackage = this.getClass().getPackage().toString();
        String[] commandPackageStringArray = commandPackage.split("\\.");
        String panelPackageEnd = commandPackageStringArray[commandPackageStringArray.length - 1];
        this.panelPackage = this.panelPath + panelPackageEnd;
        String[] commandClassStringArray = commandClass.split("\\.");
        String classOnlyName = commandClassStringArray[commandClassStringArray.length - 1].replaceFirst("Impl", "") + "Panel";
        this.panelClass = this.panelPackage + "." + classOnlyName;
    }

    public String getCommandName(Object clazz) {
        return this.commandName;
    }

    public Node getNode() {
        return this.cmdNode;
    }

    public void setNode(Node n) {
        this.cmdNode = n;
    }

    public String getNodeString() {
        return this.cmdNode.toString();
    }

    public void setSerialPort(UniRS232 port) throws IOException {
        if (port != null && port.isOpened()) {
            try {
                this.serialPort = port;
                this.serialPort.setReadTimeout(this.defaultReadTimeout);
                this.lastReadTimeout = this.defaultReadTimeout;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getCommandBuffer() {
        return this.commandBuffer;
    }

    public void setInputBufferSize(int size) {
        this.in = new byte[size];
    }

    public int sendCommand(String command) throws IOException {
        this.serialPort.flushInput();
        this.serialPort.flushOutput();
        int retval = this.serialPort.writeString(command);
        this.postCommandSleep(this.defaultPostCommandSleep);
        return retval;
    }

    public int sendCommandSlow(String command, int msecDelay) throws IOException {
        this.serialPort.flushInput();
        this.serialPort.flushOutput();
        int retval = this.serialPort.writeStringSlow(command, msecDelay);
        this.postCommandSleep(this.defaultPostCommandSleep);
        return retval;
    }

    public int sendCommand(byte[] command) throws IOException {
        this.serialPort.flushInput();
        this.serialPort.flushOutput();
        int retval = this.serialPort.write(command);
        this.postCommandSleep(this.defaultPostCommandSleep);
        return retval;
    }

    public int sendCommandSlow(byte[] command, int msecDelay) throws IOException {
        this.serialPort.flushInput();
        this.serialPort.flushOutput();
        int retval = this.serialPort.writeSlow(command, msecDelay);
        this.postCommandSleep(this.defaultPostCommandSleep);
        return retval;
    }

    protected void postCommandSleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String getCommandNameFromBundle(Object clazz) {
        String className = clazz.getClass().getName();
        String[] arr = className.split("[.]");
        String resourceName = "COMMAND_" + arr[arr.length - 1].toUpperCase();
        return ResourceBundle.getBundle("com.oceanoptics.omnidriver.accessories.mikropack.commands.Bundle").getString(resourceName);
    }
}

