/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.accessories.mikropack.commands;

import com.oceanoptics.omnidriver.accessories.mikropack.commands.FaulhaberCommandBase;
import com.oceanoptics.omnidriver.accessories.mikropack.commands.Node;
import com.oceanoptics.unirs232.UniRS232;
import java.io.IOException;

public class FaulhaberCommandIntegerResponse
extends FaulhaberCommandBase {
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/unirs232/UniRS232;)V\ngetIntResponse,(I)I\ngetIntResponse,()I\nsendCommandIntResponse,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;)I\n";

    public FaulhaberCommandIntegerResponse(UniRS232 serPort) throws IOException {
        super(serPort);
        this.commandName = this.getCommandNameFromBundle(this);
    }

    public int getIntResponse(int waitTimeout) throws IOException {
        int bytesRead;
        int retval = 0;
        if (null == this.in || this.in.length < this.maxIntegerLength) {
            this.in = new byte[this.maxIntegerLength];
        }
        if (waitTimeout != this.lastReadTimeout) {
            this.lastReadTimeout = waitTimeout;
            this.serialPort.setReadTimeout(this.lastReadTimeout);
        }
        if ((bytesRead = this.serialPort.read(this.in, this.maxIntegerLength)) == 0) {
            throw new IOException("No Serial Data Present");
        }
        if (this.in[bytesRead - 2] != 13 || this.in[bytesRead - 1] != 10) {
            throw new IOException("Invalid return value");
        }
        retval = new Integer(new String(this.in, 0, bytesRead, "US-ASCII").trim());
        return retval;
    }

    public int getIntResponse() throws IOException {
        return this.getIntResponse(this.defaultReadTimeout);
    }

    public int sendCommandIntResponse(Node node) throws IOException {
        if (node != null) {
            this.commandBuffer = node.toString() + this.commandBase + this.commandParameter + "\r";
            this.sendCommand(this.commandBuffer);
            return this.getIntResponse();
        }
        throw new NullPointerException("Device node was null");
    }
}

