/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.accessories.mikropack.commands.moveandwait;

import com.oceanoptics.omnidriver.accessories.mikropack.commands.FaulhaberCommandOnly;
import com.oceanoptics.omnidriver.accessories.mikropack.commands.Node;
import com.oceanoptics.omnidriver.accessories.mikropack.commands.moveandwait.MoveAndWaitGUIProvider;
import com.oceanoptics.omnidriver.accessories.mikropack.exceptions.TimeoutException;
import com.oceanoptics.unirs232.UniRS232;
import java.io.IOException;

public class MoveAndWaitImpl
extends FaulhaberCommandOnly
implements MoveAndWaitGUIProvider {
    private final boolean waitForCharacter = true;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/unirs232/UniRS232;)V\nmoveAndWait,(Lcom/oceanoptics/omnidriver/accessories/mikropack/commands/Node;J)V\n";

    public MoveAndWaitImpl(UniRS232 serPort) throws IOException {
        super(serPort);
        this.commandBase = new String("M");
    }

    public void moveAndWait(Node node, long millis) throws IOException, TimeoutException {
        this.sendCommandOnly(node);
        this.waitForPositionNotify(node, millis);
    }

    protected void waitForPositionNotify(Node node, long millis) throws IOException, TimeoutException {
        long endTime = System.currentTimeMillis() + millis;
        int currentReadTimeout = this.serialPort.getReadTimeout();
        this.serialPort.setReadTimeout(100);
        int numberOfBytesInBuffer = this.serialPort.getBytesInRXBuffer();
        while (System.currentTimeMillis() < endTime && numberOfBytesInBuffer == 0) {
            try {
                Thread.sleep(50L);
                numberOfBytesInBuffer = this.serialPort.getBytesInRXBuffer();
            }
            catch (Exception e) {
                System.err.println("there was an exception in wait");
                e.printStackTrace();
            }
        }
        if (numberOfBytesInBuffer == 0) {
            throw new TimeoutException("Timeout ocurred before position was reached");
        }
        this.serialPort.setReadTimeout(currentReadTimeout);
    }
}

