/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.accessories.mikropack.devices;

import com.oceanoptics.omnidriver.accessories.mikropack.commands.Node;
import com.oceanoptics.omnidriver.accessories.mikropack.devices.MPDeviceBase;
import com.oceanoptics.omnidriver.accessories.mikropack.exceptions.TimeoutException;
import com.oceanoptics.unirs232.UniRS232;
import java.io.IOException;

public class MPM2000
extends MPDeviceBase {
    private String[] EEPROM;
    int EEPROMVersion;
    int serialNumber;
    int[] indexPosition = new int[16];
    boolean is8Channel;
    int currentIndex;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/unirs232/UniRS232;)V\ngetSerialNumber,()I\ngetEEPROMVersion,()I\ngoToIndex,(I)V\ngetCurrentIndex,()I\nshiftIndex,(I)V\nis8Channel,()Z\n";

    public MPM2000(UniRS232 serPort) throws IOException, TimeoutException {
        super(serPort);
        this.nodes = new Node[1];
        this.nodes[0] = new Node(Node.SINGLE());
        try {
            int n = this.getNodeNumber(this.nodes[0]);
            if (n != 0) {
                this.nodes[0] = null;
                throw new IOException("Node number did not match.");
            }
        }
        catch (Exception e) {
            this.nodes[0] = null;
        }
        this.EEPROM = this.getProgramSequence(this.nodes[0]);
        this.printEEPROM(this.EEPROM, System.err);
        this.EEPROMVersion = this.EEPROM[2].startsWith("SW") ? 1 : 2;
        switch (this.EEPROMVersion) {
            case 1: {
                this.serialNumber = new Integer(this.EEPROM[3].substring(2));
                break;
            }
            case 2: {
                this.serialNumber = new Integer(this.EEPROM[3].substring(3));
            }
        }
        this.is8Channel = this.serialNumber > 50000000;
        for (int i = 0; i < 16; ++i) {
            this.indexPosition[i] = new Integer(this.EEPROM[4 + i].substring(2).trim());
        }
        this.setResponseMode(this.nodes[0], 1);
        this.notifyPositionEnable(this.nodes[0]);
        this.negativeLimit[this.nodes[0].getIndex()] = this.getNegativeLimit(this.nodes[0]);
        this.positiveLimit[this.nodes[0].getIndex()] = this.getPositiveLimit(this.nodes[0]);
        this.maxSpeed = 1000;
        this.setSpeed(this.nodes[this.nodes[0].getIndex()], this.maxSpeed);
        this.speedFactor = 700.0;
        this.goToIndex(0);
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public int getEEPROMVersion() {
        return this.EEPROMVersion;
    }

    public void goToIndex(int index) throws IOException, TimeoutException {
        if (index < 1) {
            index = 1;
        }
        if (index > 16) {
            index = 16;
        }
        this.loadAbsolutePosition(Node.SINGLE(), this.indexPosition[index - 1]);
        this.moveAndWait(Node.SINGLE());
        this.currentIndex = index;
        this.currentPosition[0] = this.indexPosition[index - 1];
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void shiftIndex(int shiftBy) throws IOException, TimeoutException {
        int newIndex = this.currentIndex + shiftBy;
        if (newIndex > 16) {
            newIndex -= 16;
        }
        if (newIndex < 1) {
            newIndex += 16;
        }
        this.goToIndex(newIndex);
    }

    public boolean is8Channel() {
        return this.is8Channel;
    }
}

