/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.accessories.mikropack.devices;

import com.oceanoptics.omnidriver.accessories.mikropack.commands.Node;
import com.oceanoptics.omnidriver.accessories.mikropack.devices.MPDeviceBase;
import com.oceanoptics.omnidriver.accessories.mikropack.exceptions.TimeoutException;
import com.oceanoptics.spam.numericalmethods.NumericalMethods;
import com.oceanoptics.unirs232.UniRS232;
import java.io.IOException;

public class MonoScan2000
extends MPDeviceBase {
    private String[] EEPROM;
    int serialNumber;
    double[] storedWavelength;
    double[] interpolatedWavelength;
    double[] readPosition;
    double[] motorPositions;
    double minimumWavelength;
    double maximumWavelength;
    double currentWavelength;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/unirs232/UniRS232;)V\ngetSerialNumber,()I\ngoToWavelength,(D)V\nshiftWavelength,(D)V\ngetCurrentWavelength,()D\n";

    public MonoScan2000(UniRS232 serPort) throws IOException, TimeoutException {
        super(serPort);
        int i;
        int n;
        this.nodes = new Node[1];
        this.nodes[0] = new Node(Node.SINGLE());
        try {
            n = this.getNodeNumber(this.nodes[0]);
            if (n != 0) {
                this.nodes[0] = null;
                throw new IOException("Node number did not match.");
            }
        }
        catch (Exception e) {
            this.nodes[0] = null;
        }
        this.EEPROM = this.getProgramSequence(this.nodes[0]);
        for (n = 0; n < this.EEPROM.length; ++n) {
            String sanitized = this.EEPROM[n].replaceAll(" ", "");
            this.EEPROM[n] = sanitized = sanitized.toLowerCase();
        }
        this.serialNumber = new Integer(this.EEPROM[1].substring(2));
        this.printEEPROM(this.EEPROM, System.err);
        int startIndex = -1;
        int endIndex = -1;
        for (i = 0; startIndex == -1 && i < this.EEPROM.length; ++i) {
            if (!this.EEPROM[i].startsWith("lr-")) continue;
            startIndex = i;
        }
        while (endIndex == -1 && i < this.EEPROM.length) {
            if (!this.EEPROM[i].startsWith("lr-")) {
                endIndex = i;
            }
            ++i;
        }
        if (startIndex != -1 && endIndex != -1) {
            this.storedWavelength = new double[endIndex - startIndex];
            this.readPosition = new double[endIndex - startIndex];
            for (i = 0; i < this.storedWavelength.length; ++i) {
                this.storedWavelength[i] = 200.0f + 10.0f * (float)i;
                this.readPosition[i] = new Double(this.EEPROM[startIndex + i].substring(2)).floatValue();
            }
            this.minimumWavelength = this.storedWavelength[0];
            this.maximumWavelength = this.storedWavelength[this.storedWavelength.length - 1];
            this.interpolatedWavelength = new double[this.storedWavelength.length * 10];
            for (i = 0; i < this.interpolatedWavelength.length; ++i) {
                this.interpolatedWavelength[i] = 200.0f + (float)i;
            }
            try {
                this.motorPositions = NumericalMethods.linearSpline((double[])this.storedWavelength, (double[])this.readPosition, (double[])this.interpolatedWavelength);
            }
            catch (Exception e) {}
        } else {
            System.err.println("Unable to extract wavelengths from program.");
        }
        this.setResponseMode(this.nodes[0], 1);
        this.notifyPositionEnable(this.nodes[0]);
        this.negativeLimit[this.nodes[0].getIndex()] = this.getNegativeLimit(this.nodes[0]);
        this.positiveLimit[this.nodes[0].getIndex()] = this.getPositiveLimit(this.nodes[0]);
        this.currentPosition[this.nodes[0].getIndex()] = this.getPosition(this.nodes[0]);
        this.maxSpeed = 300;
        this.setSpeed(this.nodes[0], this.maxSpeed);
        this.speedFactor = 61.3;
        this.goToWavelength(this.minimumWavelength);
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void goToWavelength(double nm) throws IOException, TimeoutException {
        int index;
        int intPos;
        if (nm < this.minimumWavelength) {
            nm = this.minimumWavelength;
        }
        if (nm > this.maximumWavelength) {
            nm = this.maximumWavelength;
        }
        if ((intPos = (int)this.motorPositions[index = NumericalMethods.findNearestElement((double[])this.interpolatedWavelength, (double)nm)]) < this.negativeLimit[0]) {
            intPos = this.negativeLimit[0];
        }
        if (intPos > this.positiveLimit[0]) {
            intPos = this.positiveLimit[0];
        }
        this.loadAbsolutePosition(this.nodes[0], intPos);
        this.moveAndWait(this.nodes[0]);
        this.currentWavelength = nm;
        this.currentPosition[0] = intPos;
    }

    public void shiftWavelength(double shift) throws IOException, TimeoutException {
        double newWavelength = this.currentWavelength + shift;
        if (newWavelength > this.maximumWavelength) {
            newWavelength = this.maximumWavelength;
        } else if (newWavelength < this.minimumWavelength) {
            newWavelength = this.minimumWavelength;
        }
        this.goToWavelength(newWavelength);
    }

    public double getCurrentWavelength() {
        return this.currentWavelength;
    }
}

