/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.api.wrapper;

import com.oceanoptics.highrestiming.HighResTimeStamp;
import com.oceanoptics.omnidriver.api.wrapper.WrapperExtensions;
import com.oceanoptics.omnidriver.features.analogin.AnalogIn;
import com.oceanoptics.omnidriver.features.analogin.AnalogInImpl;
import com.oceanoptics.omnidriver.features.analogout.AnalogOut;
import com.oceanoptics.omnidriver.features.analogout.AnalogOutImpl;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperature;
import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureImpl;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobe;
import com.oceanoptics.omnidriver.features.continuousstrobe.ContinuousStrobeImpl;
import com.oceanoptics.omnidriver.features.currentout.CurrentOut;
import com.oceanoptics.omnidriver.features.currentout.CurrentOutImpl_LS450;
import com.oceanoptics.omnidriver.features.detectortemperature.DetectorTemperature;
import com.oceanoptics.omnidriver.features.detectortemperature.DetectorTemperatureImpl;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelay;
import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayImpl;
import com.oceanoptics.omnidriver.features.gpio.GPIO;
import com.oceanoptics.omnidriver.features.gpio.GPIOImpl;
import com.oceanoptics.omnidriver.features.highgainmode.HighGainMode;
import com.oceanoptics.omnidriver.features.highgainmode.HighGainModeImpl;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBus;
import com.oceanoptics.omnidriver.features.i2cbus.I2CBusImpl;
import com.oceanoptics.omnidriver.features.indy.Indy;
import com.oceanoptics.omnidriver.features.indy.IndyImpl;
import com.oceanoptics.omnidriver.features.internaltrigger.InternalTrigger;
import com.oceanoptics.omnidriver.features.internaltrigger.InternalTriggerImpl_Jaz;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactor;
import com.oceanoptics.omnidriver.features.irradiancecalibrationfactor.IrradianceCalibrationFactorImpl;
import com.oceanoptics.omnidriver.features.ls450functions.LS450_Functions;
import com.oceanoptics.omnidriver.features.ls450functions.LS450_FunctionsImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionImpl;
import com.oceanoptics.omnidriver.features.nonlinearitycorrection.NonlinearityCorrectionProvider;
import com.oceanoptics.omnidriver.features.pluginprovider.PlugInProviderImpl;
import com.oceanoptics.omnidriver.features.saturationthreshold.SaturationThreshold;
import com.oceanoptics.omnidriver.features.saturationthreshold.SaturationThresholdImpl;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobe;
import com.oceanoptics.omnidriver.features.singlestrobe.SingleStrobeImpl;
import com.oceanoptics.omnidriver.features.spibus.SPIBus;
import com.oceanoptics.omnidriver.features.spibus.SPIBusImpl;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrection;
import com.oceanoptics.omnidriver.features.straylightcorrection.StrayLightCorrectionImpl;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectric;
import com.oceanoptics.omnidriver.features.thermoelectric.ThermoElectricImpl;
import com.oceanoptics.omnidriver.features.uvvislightsource.UV_VIS_LightSource;
import com.oceanoptics.omnidriver.features.version.Version;
import com.oceanoptics.omnidriver.features.version.VersionImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationImpl;
import com.oceanoptics.omnidriver.features.wavelengthcalibration.WavelengthCalibrationProvider;
import com.oceanoptics.omnidriver.gramsspc.GramsSPC;
import com.oceanoptics.omnidriver.plugin.SpectrometerPlugIn;
import com.oceanoptics.omnidriver.spectra.AnnotatedSpectrum;
import com.oceanoptics.omnidriver.spectra.Spectrum;
import com.oceanoptics.omnidriver.spectrometer.Bench;
import com.oceanoptics.omnidriver.spectrometer.Coefficients;
import com.oceanoptics.omnidriver.spectrometer.Detector;
import com.oceanoptics.omnidriver.spectrometer.NetworkSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerAssembly;
import com.oceanoptics.omnidriver.spectrometer.SpectrometerFactory;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.omnidriver.spectrometer.jaz.JazNetwork;
import com.oceanoptics.omnidriver.spectrometer.sts.STS;
import com.oceanoptics.omnidriver.spectrometer.sts.STSBench;
import com.oceanoptics.omnidriver.spectrometer.sts.STSConfiguration;
import com.oceanoptics.spectralprocessing.SpectralProcessor;
import com.oceanoptics.utilities.Jars;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class Wrapper {
    private static final String API_VERSION = "1.66";
    private static final int BUILD_NUMBER = 1660;
    int numberOfSpectraAcquired = 0;
    boolean stopCollectingSpectra;
    private Spectrum[] spectrumBuffer = null;
    private boolean[] isSaturatedBuffer = null;
    HighResTimeStamp[] timeStampBuffer = null;
    boolean keyIsInserted = false;
    public Exception lastException = null;
    int privilegeLevel = 0;
    boolean dragonIsAccessible = false;
    boolean rawSpectrumMode = false;
    ArrayList spectrometerAssemblyCollection = new ArrayList();
    private WrapperExtensions wrapperExtensions;
    private static String __extern__ = "__extern__\n<init>,()V\ngetWrapperExtensions,()Lcom/oceanoptics/omnidriver/api/wrapper/WrapperExtensions;\nexportToGramsSPC,(ILjava/lang/String;[DLjava/lang/String;)Z\nexportToGramsSPC,(IILjava/lang/String;[DLjava/lang/String;)Z\ngetApiVersion,()Ljava/lang/String;\ngetBuildNumber,()I\ngetLastException,()Ljava/lang/String;\ngetLastExceptionStackTrace,()Ljava/lang/String;\nopenNetworkSpectrometer,(Ljava/lang/String;)I\nsetNetworkCommunicationParameters,(IIZII)V\nopenAllSpectrometers,()I\ngetName,(I)Ljava/lang/String;\ngetMaximumIntegrationTime,(I)I\ngetMinimumIntegrationTime,(I)I\ngetMaximumIntensity,(I)I\ngetNumberOfSpectrometersFound,()I\ngetFirmwareVersion,(I)Ljava/lang/String;\ngetSerialNumber,(I)Ljava/lang/String;\ngetNumberOfPixels,(I)I\ngetNumberOfPixels,(II)I\ngetNumberOfDarkPixels,(I)I\ngetNumberOfDarkPixels,(II)I\nsetIntegrationTime,(II)V\nsetIntegrationTime,(III)V\ngetIntegrationTime,(I)I\ngetIntegrationTime,(II)I\nsetScansToAverage,(II)V\nsetScansToAverage,(III)V\ngetScansToAverage,(I)I\ngetScansToAverage,(II)I\ngetBench,(I)Lcom/oceanoptics/omnidriver/spectrometer/Bench;\ngetBench,(II)Lcom/oceanoptics/omnidriver/spectrometer/Bench;\ngetDetector,(II)Lcom/oceanoptics/omnidriver/spectrometer/Detector;\nsaveSTSConfiguration,(I)Z\ngetSTSBench,(I)Lcom/oceanoptics/omnidriver/spectrometer/sts/STSBench;\nsetBoxcarWidth,(II)V\nsetBoxcarWidth,(III)V\ngetBoxcarWidth,(I)I\ngetBoxcarWidth,(II)I\ninsertKey,(Ljava/lang/String;)Z\nremoveKey,()V\ngetCalibrationCoefficientsFromBuffer,(I)Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\ngetCalibrationCoefficientsFromBuffer,(II)Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\ngetCalibrationCoefficientsFromEEProm,(I)Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\ngetCalibrationCoefficientsFromEEProm,(II)Lcom/oceanoptics/omnidriver/spectrometer/Coefficients;\nsetCalibrationCoefficientsIntoBuffer,(ILcom/oceanoptics/omnidriver/spectrometer/Coefficients;ZZZ)Z\nsetCalibrationCoefficientsIntoBuffer,(IILcom/oceanoptics/omnidriver/spectrometer/Coefficients;ZZZ)Z\nsetCalibrationCoefficientsIntoEEProm,(ILcom/oceanoptics/omnidriver/spectrometer/Coefficients;ZZZ)Z\nsetCalibrationCoefficientsIntoEEProm,(IILcom/oceanoptics/omnidriver/spectrometer/Coefficients;ZZZ)Z\ngetEEPromInfo,(II)Ljava/lang/String;\nsetEEPromInfo,(IILjava/lang/String;)Z\nsetDetectorSetPointCelsius,(ID)Z\nsetExternalTriggerMode,(II)V\nsetExternalTriggerMode,(III)V\ngetExternalTriggerMode,(I)I\ngetExternalTriggerMode,(II)I\nsetCorrectForElectricalDark,(II)V\nsetCorrectForElectricalDark,(III)V\ngetCorrectForElectricalDark,(I)Z\ngetCorrectForElectricalDark,(II)Z\ngetCorrectForStrayLight,(I)Z\ngetCorrectForStrayLight,(II)Z\nsetCorrectForDetectorNonlinearity,(II)Z\nsetCorrectForDetectorNonlinearity,(III)Z\ngetCorrectForDetectorNonlinearity,(I)Z\ngetCorrectForDetectorNonlinearity,(II)Z\nsetStrobeEnable,(II)V\nsetStrobeEnable,(III)V\ngetStrobeEnable,(I)I\ngetStrobeEnable,(II)I\ngetWavelength,(II)D\ngetWavelength,(III)D\ngetWavelengths,(I)[D\ngetWavelengths,(II)[D\ngetWavelengthIntercept,(I)D\ngetWavelengthIntercept,(II)D\ngetWavelengthFirst,(I)D\ngetWavelengthFirst,(II)D\ngetWavelengthSecond,(I)D\ngetWavelengthSecond,(II)D\ngetWavelengthThird,(I)D\ngetWavelengthThird,(II)D\nsetTimeout,(II)I\nisTimeout,(I)Z\nisTimeout,(II)Z\nisSpectrumValid,(I)Z\nisSpectrumValid,(II)Z\ngetSpectrum,(I)[D\ngetSpectrum,(II)[D\nstopAveraging,(I)V\nstopAveraging,(II)V\nisSaturated,(I)Z\nisSaturated,(II)Z\ncloseAllSpectrometers,()V\ncloseSpectrometer,(I)V\ngetFeatureControllerGPIO,(I)Lcom/oceanoptics/omnidriver/features/gpio/GPIO;\nisFeatureSupportedGPIO,(I)Z\ngetFeatureControllerSaturationThreshold,(I)Lcom/oceanoptics/omnidriver/features/saturationthreshold/SaturationThreshold;\nisFeatureSupportedSaturationThreshold,(I)Z\ngetFeatureControllerSPIBus,(I)Lcom/oceanoptics/omnidriver/features/spibus/SPIBus;\nisFeatureSupportedSPIBus,(I)Z\ngetFeatureControllerSingleStrobe,(I)Lcom/oceanoptics/omnidriver/features/singlestrobe/SingleStrobe;\nisFeatureSupportedSingleStrobe,(I)Z\ngetFeatureControllerContinuousStrobe,(I)Lcom/oceanoptics/omnidriver/features/continuousstrobe/ContinuousStrobe;\nisFeatureSupportedContinuousStrobe,(I)Z\ngetFeatureControllerCurrentOut,(I)Lcom/oceanoptics/omnidriver/features/currentout/CurrentOut;\nisFeatureSupportedCurrentOut,(I)Z\ngetFeatureControllerBoardTemperature,(I)Lcom/oceanoptics/omnidriver/features/boardtemperature/BoardTemperature;\nisFeatureSupportedBoardTemperature,(I)Z\ngetFeatureControllerDetectorTemperature,(I)Lcom/oceanoptics/omnidriver/features/detectortemperature/DetectorTemperature;\nisFeatureSupportedDetectorTemperature,(I)Z\ngetFeatureControllerAnalogIn,(I)Lcom/oceanoptics/omnidriver/features/analogin/AnalogIn;\nisFeatureSupportedAnalogIn,(I)Z\ngetFeatureControllerAnalogOut,(I)Lcom/oceanoptics/omnidriver/features/analogout/AnalogOut;\nisFeatureSupportedAnalogOut,(I)Z\ngetFeatureControllerExternalTriggerDelay,(I)Lcom/oceanoptics/omnidriver/features/externaltriggerdelay/ExternalTriggerDelay;\nisFeatureSupportedExternalTriggerDelay,(I)Z\ngetFeatureControllerI2CBus,(I)Lcom/oceanoptics/omnidriver/features/i2cbus/I2CBus;\nisFeatureSupportedI2CBus,(I)Z\ngetFeatureControllerHighGainMode,(I)Lcom/oceanoptics/omnidriver/features/highgainmode/HighGainMode;\nisFeatureSupportedHighGainMode,(I)Z\ngetFeatureControllerIrradianceCalibrationFactor,(I)Lcom/oceanoptics/omnidriver/features/irradiancecalibrationfactor/IrradianceCalibrationFactor;\nisFeatureSupportedIrradianceCalibrationFactor,(I)Z\ngetFeatureControllerLS450,(I)Lcom/oceanoptics/omnidriver/features/ls450functions/LS450_Functions;\nisFeatureSupportedLS450,(I)Z\ngetFeatureController_UV_VIS_LightSource,(I)Lcom/oceanoptics/omnidriver/features/uvvislightsource/UV_VIS_LightSource;\nisFeatureSupported_UV_VIS_LightSource,(I)Z\ngetFeatureControllerNonlinearityCorrectionProvider,(I)Lcom/oceanoptics/omnidriver/features/nonlinearitycorrection/NonlinearityCorrectionProvider;\nisFeatureSupportedNonlinearityCorrectionProvider,(I)Z\ngetFeatureControllerStrayLightCorrection,(I)Lcom/oceanoptics/omnidriver/features/straylightcorrection/StrayLightCorrection;\nisFeatureSupportedStrayLightCorrection,(I)Z\ngetFeatureControllerVersion,(I)Lcom/oceanoptics/omnidriver/features/version/Version;\nisFeatureSupportedVersion,(I)Z\ngetFeatureControllerWavelengthCalibrationProvider,(I)Lcom/oceanoptics/omnidriver/features/wavelengthcalibration/WavelengthCalibrationProvider;\nisFeatureSupportedWavelengthCalibrationProvider,(I)Z\ngetFeatureControllerThermoElectric,(I)Lcom/oceanoptics/omnidriver/features/thermoelectric/ThermoElectric;\nisFeatureSupportedThermoElectric,(I)Z\ngetFeatureControllerIndy,(I)Lcom/oceanoptics/omnidriver/features/indy/Indy;\nisFeatureSupportedIndy,(I)Z\ngetFeatureControllerInternalTrigger,(I)Lcom/oceanoptics/omnidriver/features/internaltrigger/InternalTrigger;\nisFeatureSupportedInternalTrigger,(I)Z\nsetAutoToggleStrobeLampEnable,(IZ)V\nsetAutoToggleStrobeLampEnable,(IIZ)V\nhighSpdAcq_AllocateBuffer,(II)V\nhighSpdAcq_StartAcquisition,(I)V\nhighSpdAcq_StartAcquisition,(II)V\nhighSpdAcq_StopAcquisition,()V\nhighSpdAcq_GetNumberOfSpectraAcquired,()I\nhighSpdAcq_GetSpectrum,(I)[D\nhighSpdAcq_IsSaturated,(I)Z\nhighSpdAcq_GetTimeStamp,(I)Lcom/oceanoptics/highrestiming/HighResTimeStamp;\nmainOBSOLETE,()V\n";

    public WrapperExtensions getWrapperExtensions() {
        if (this.wrapperExtensions == null) {
            this.wrapperExtensions = new WrapperExtensions();
            this.wrapperExtensions.setWrapper(this);
        }
        return this.wrapperExtensions;
    }

    private AnnotatedSpectrum createAnnotatedSpectrum(int spectrometerIndex, int channelIndex, double[] pixels, String username) {
        HighResTimeStamp timestamp = new HighResTimeStamp();
        boolean rotationEnabled = false;
        AnnotatedSpectrum annotatedSpectrum = new AnnotatedSpectrum(pixels, this.getWavelengths(spectrometerIndex, channelIndex), this.isSaturated(spectrometerIndex, channelIndex), this.getIntegrationTime(spectrometerIndex, channelIndex), this.getStrobeEnable(spectrometerIndex, channelIndex) == 1, timestamp, this.getBoxcarWidth(spectrometerIndex, channelIndex), this.getScansToAverage(spectrometerIndex, channelIndex), this.getCorrectForElectricalDark(spectrometerIndex, channelIndex), this.getCorrectForDetectorNonlinearity(spectrometerIndex, channelIndex), this.getCorrectForStrayLight(spectrometerIndex, channelIndex), rotationEnabled, this.getSerialNumber(spectrometerIndex), channelIndex, username);
        return annotatedSpectrum;
    }

    public boolean exportToGramsSPC(int spectrometerIndex, String outputPathname, double[] pixels, String username) {
        return this.exportToGramsSPC(spectrometerIndex, 0, outputPathname, pixels, username);
    }

    public boolean exportToGramsSPC(int spectrometerIndex, int channelIndex, String outputPathname, double[] pixels, String username) {
        this.lastException = null;
        AnnotatedSpectrum annotatedSpectrum = this.createAnnotatedSpectrum(spectrometerIndex, channelIndex, pixels, username);
        try {
            File outputFile = new File(outputPathname);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            byte[] byteArray = GramsSPC.getSPCByteStream(annotatedSpectrum);
            outputStream.write(byteArray);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            this.lastException = exception;
            return false;
        }
        return true;
    }

    public String getApiVersion() {
        return API_VERSION;
    }

    public int getBuildNumber() {
        return 1660;
    }

    public String getLastException() {
        if (this.lastException == null) {
            return "no exception";
        }
        return this.lastException.toString();
    }

    public String getLastExceptionStackTrace() {
        if (this.lastException == null) {
            return "no exception";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.lastException.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public int openNetworkSpectrometer(String ipAddress) {
        Socket socket;
        this.lastException = null;
        for (int index = 0; index < this.spectrometerAssemblyCollection.size(); ++index) {
            Spectrometer spectrometer = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(index)).getSpectrometer();
            if (!(spectrometer instanceof NetworkSpectrometer) || ipAddress.compareTo(((NetworkSpectrometer)spectrometer).getAddress()) != 0) continue;
            return index;
        }
        try {
            socket = new Socket(ipAddress, 7654);
        }
        catch (UnknownHostException exception) {
            this.lastException = exception;
            return -1;
        }
        catch (IOException exception) {
            this.lastException = exception;
            return -1;
        }
        try {
            socket.setSoTimeout(0);
            socket.setSoLinger(false, 1);
            JazNetwork jazNetwork = new JazNetwork(socket);
            this.spectrometerAssemblyCollection.add(new SpectrometerAssembly(jazNetwork));
        }
        catch (Exception exception) {
            this.lastException = exception;
            try {
                if (socket.isConnected()) {
                    socket.close();
                }
            }
            catch (Exception exceptionToBeIgnored) {
                // empty catch block
            }
            return -1;
        }
        return this.spectrometerAssemblyCollection.size() - 1;
    }

    public void setNetworkCommunicationParameters(int spectrometerIndex, int socketTimeoutMilliseconds, boolean checkForBytesAvailable, int spectrumReadThrottleMilliseconds, int spectrumReadRetryLimit) {
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().setSocketTimeoutMilliseconds(socketTimeoutMilliseconds);
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().setCheckForBytesAvailable(checkForBytesAvailable);
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().setSpectrumReadThrottleMilliseconds(spectrumReadThrottleMilliseconds);
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().setReadSpectrumRetryLimit(spectrumReadRetryLimit);
    }

    public int openAllSpectrometers() {
        try {
            int index;
            for (index = 0; index < this.spectrometerAssemblyCollection.size(); ++index) {
                SpectrometerAssembly spectrometerAssembly = (SpectrometerAssembly)this.spectrometerAssemblyCollection.get(index);
                Spectrometer spectrometer = spectrometerAssembly.getSpectrometer();
                if (spectrometer.isNetworkSpectrometer()) continue;
                return this.spectrometerAssemblyCollection.size();
            }
            Spectrometer[] spectrometerArray = SpectrometerFactory.getAllSpectrometers();
            for (index = 0; index < spectrometerArray.length; ++index) {
                this.spectrometerAssemblyCollection.add(new SpectrometerAssembly(spectrometerArray[index]));
            }
            return this.spectrometerAssemblyCollection.size();
        }
        catch (Exception ee) {
            this.lastException = ee;
            return -1;
        }
    }

    public String getName(int spectrometerIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getName();
    }

    public int getMaximumIntegrationTime(int spectrometerIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getIntegrationTimeMaximum();
    }

    public int getMinimumIntegrationTime(int spectrometerIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getIntegrationTimeMinimum();
    }

    public int getMaximumIntensity(int spectrometerIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getMaxIntensity();
    }

    public int getNumberOfSpectrometersFound() {
        return this.spectrometerAssemblyCollection.size();
    }

    public String getFirmwareVersion(int spectrometerIndex) {
        String firmwareVersionString;
        try {
            firmwareVersionString = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getFirmwareVersion();
            firmwareVersionString = firmwareVersionString.substring(firmwareVersionString.indexOf(32) + 1);
        }
        catch (IOException ee) {
            this.lastException = ee;
            return "I/O error";
        }
        return firmwareVersionString;
    }

    public String getSerialNumber(int spectrometerIndex) {
        String str;
        USBSpectrometer usb = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        try {
            str = usb.getSerialNumber();
        }
        catch (Exception ee) {
            this.lastException = ee;
            str = "Not Found";
        }
        return str;
    }

    public int getNumberOfPixels(int spectrometerIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfPixels();
    }

    public int getNumberOfPixels(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getChannels()[channelIndex].getNumberOfPixels();
    }

    public int getNumberOfDarkPixels(int spectrometerIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfDarkPixels();
    }

    public int getNumberOfDarkPixels(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getChannels()[channelIndex].getNumberOfDarkPixels();
    }

    public void setIntegrationTime(int spectrometerIndex, int usec) {
        this.setIntegrationTime(spectrometerIndex, 0, usec);
    }

    public void setIntegrationTime(int spectrometerIndex, int channelIndex, int usec) {
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).setIntegrationTime(usec);
    }

    public int getIntegrationTime(int spectrometerIndex) {
        return this.getIntegrationTime(spectrometerIndex, 0);
    }

    public int getIntegrationTime(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).getIntegrationTime();
    }

    public void setScansToAverage(int spectrometerIndex, int numberOfScansToAverage) {
        this.setScansToAverage(spectrometerIndex, 0, numberOfScansToAverage);
    }

    public void setScansToAverage(int spectrometerIndex, int channelIndex, int numberOfScansToAverage) {
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).setScansToAverage(numberOfScansToAverage);
    }

    public int getScansToAverage(int spectrometerIndex) {
        return this.getScansToAverage(spectrometerIndex, 0);
    }

    public int getScansToAverage(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).getScansToAverage();
    }

    public Bench getBench(int spectrometerIndex) {
        try {
            return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getConfiguration().getBench();
        }
        catch (IOException exception) {
            this.lastException = exception;
            return null;
        }
    }

    public Bench getBench(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getConfiguration(channelIndex).getBench();
    }

    public Detector getDetector(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getConfiguration(channelIndex).getDetector();
    }

    public boolean saveSTSConfiguration(int spectrometerIndex) {
        if (!this.keyIsInserted) {
            return false;
        }
        Spectrometer s = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        if (s instanceof STS) {
            try {
                STSConfiguration config = (STSConfiguration)((STS)s).getConfiguration();
                config.setConfigurationToSpectrometer();
                return true;
            }
            catch (IOException ioe) {
                this.lastException = ioe;
                return false;
            }
        }
        return false;
    }

    public STSBench getSTSBench(int spectrometerIndex) {
        Spectrometer s = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        if (s instanceof STS) {
            try {
                STSConfiguration config = (STSConfiguration)((STS)s).getConfiguration();
                return (STSBench)config.getBench();
            }
            catch (IOException ioe) {
                this.lastException = ioe;
                return null;
            }
        }
        return null;
    }

    public void setBoxcarWidth(int spectrometerIndex, int numberOfPixelsOnEitherSideOfCenter) {
        this.setBoxcarWidth(spectrometerIndex, 0, numberOfPixelsOnEitherSideOfCenter);
    }

    public void setBoxcarWidth(int spectrometerIndex, int channelIndex, int numberOfPixelsOnEitherSideOfCenter) {
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).setSmoothingWindowSize(numberOfPixelsOnEitherSideOfCenter);
    }

    public int getBoxcarWidth(int spectrometerIndex) {
        return this.getBoxcarWidth(spectrometerIndex, 0);
    }

    public int getBoxcarWidth(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).getSmoothingWindowSize();
    }

    public boolean insertKey(String keyValue) {
        this.keyIsInserted = false;
        if (keyValue.length() != 9) {
            return false;
        }
        if (keyValue.charAt(0) == 'w' && keyValue.charAt(1) == 'p' && keyValue.charAt(2) == 'T' && keyValue.charAt(3) == '3' && keyValue.charAt(4) == '7' && keyValue.charAt(5) == '9' && keyValue.charAt(6) == 'h' && keyValue.charAt(7) == 'L' && keyValue.charAt(8) == 'w') {
            this.keyIsInserted = true;
            this.privilegeLevel = 0;
        }
        if (keyValue.charAt(0) == 'M' && keyValue.charAt(1) == 'a' && keyValue.charAt(2) == 't' && keyValue.charAt(3) == '4' && keyValue.charAt(4) == '2' && keyValue.charAt(5) == '9' && keyValue.charAt(6) == 's' && keyValue.charAt(7) == 'k' && keyValue.charAt(8) == 'y') {
            this.keyIsInserted = true;
            this.privilegeLevel = 1;
        }
        if (keyValue.charAt(0) == 'd' && keyValue.charAt(1) == 'r' && keyValue.charAt(2) == 'a' && keyValue.charAt(3) == 'g' && keyValue.charAt(4) == 'o' && keyValue.charAt(5) == 'n' && keyValue.charAt(6) == '_' && keyValue.charAt(7) == '2' && keyValue.charAt(8) == '5') {
            this.keyIsInserted = true;
            this.dragonIsAccessible = true;
        }
        return this.keyIsInserted;
    }

    public void removeKey() {
        this.keyIsInserted = false;
    }

    public Coefficients getCalibrationCoefficientsFromBuffer(int spectrometerIndex) {
        return this.getCalibrationCoefficientsFromBuffer(spectrometerIndex, 0);
    }

    public Coefficients getCalibrationCoefficientsFromBuffer(int spectrometerIndex, int channelIndex) {
        Coefficients coefficients = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getChannel(channelIndex).getCoefficients();
        Coefficients newCoefficients = new Coefficients(coefficients);
        return newCoefficients;
    }

    public Coefficients getCalibrationCoefficientsFromEEProm(int spectrometerIndex) {
        return this.getCalibrationCoefficientsFromEEProm(spectrometerIndex, 0);
    }

    public Coefficients getCalibrationCoefficientsFromEEProm(int spectrometerIndex, int channelIndex) {
        try {
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getChannel(channelIndex).getCoefficientsFromSpectrometer();
        }
        catch (IOException exception) {
            this.lastException = exception;
            return null;
        }
        Coefficients coefficients = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getChannel(channelIndex).getCoefficients();
        Coefficients newCoefficients = new Coefficients(coefficients);
        return newCoefficients;
    }

    public boolean setCalibrationCoefficientsIntoBuffer(int spectrometerIndex, Coefficients coefficients, boolean applyWavelengthCoefficients, boolean applyStrayLightConstant, boolean applyNonlinearityCoefficients) {
        return this.setCalibrationCoefficientsIntoBuffer(spectrometerIndex, 0, coefficients, applyWavelengthCoefficients, applyStrayLightConstant, applyNonlinearityCoefficients);
    }

    public boolean setCalibrationCoefficientsIntoBuffer(int spectrometerIndex, int channelIndex, Coefficients newCoefficients, boolean applyWavelengthCoefficients, boolean applyStrayLightConstant, boolean applyNonlinearityCoefficients) {
        if (!this.keyIsInserted) {
            return false;
        }
        Coefficients coefficients = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getChannel(channelIndex).getCoefficients();
        if (applyWavelengthCoefficients) {
            coefficients.setWlIntercept(newCoefficients.getWlIntercept());
            coefficients.setWlFirst(newCoefficients.getWlFirst());
            coefficients.setWlSecond(newCoefficients.getWlSecond());
            coefficients.setWlThird(newCoefficients.getWlThird());
        }
        if (applyStrayLightConstant) {
            coefficients.setStrayLight(newCoefficients.getStrayLight(), newCoefficients.getStrayLightSlope());
        }
        if (applyNonlinearityCoefficients) {
            coefficients.setNlCoef0(newCoefficients.getNlCoef0());
            coefficients.setNlCoef1(newCoefficients.getNlCoef1());
            coefficients.setNlCoef2(newCoefficients.getNlCoef2());
            coefficients.setNlCoef3(newCoefficients.getNlCoef3());
            coefficients.setNlCoef4(newCoefficients.getNlCoef4());
            coefficients.setNlCoef5(newCoefficients.getNlCoef5());
            coefficients.setNlCoef6(newCoefficients.getNlCoef6());
            coefficients.setNlCoef7(newCoefficients.getNlCoef7());
            coefficients.setNlOrder(newCoefficients.getNlOrder());
        }
        return true;
    }

    public boolean setCalibrationCoefficientsIntoEEProm(int spectrometerIndex, Coefficients coefficients, boolean applyWavelengthCoefficients, boolean applyStrayLightConstant, boolean applyNonlinearityCoefficients) {
        return this.setCalibrationCoefficientsIntoEEProm(spectrometerIndex, 0, coefficients, applyWavelengthCoefficients, applyStrayLightConstant, applyNonlinearityCoefficients);
    }

    public boolean setCalibrationCoefficientsIntoEEProm(int spectrometerIndex, int channelIndex, Coefficients newCoefficients, boolean applyWavelengthCoefficients, boolean applyStrayLightConstants, boolean applyNonlinearityCoefficients) {
        if (!this.keyIsInserted) {
            return false;
        }
        Coefficients coefficients = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getChannel(channelIndex).getCoefficients();
        if (applyWavelengthCoefficients) {
            coefficients.setWlIntercept(newCoefficients.getWlIntercept());
            coefficients.setWlFirst(newCoefficients.getWlFirst());
            coefficients.setWlSecond(newCoefficients.getWlSecond());
            coefficients.setWlThird(newCoefficients.getWlThird());
        }
        if (applyStrayLightConstants) {
            coefficients.setStrayLight(newCoefficients.getStrayLight(), newCoefficients.getStrayLightSlope());
        }
        if (applyNonlinearityCoefficients) {
            coefficients.setNlCoef0(newCoefficients.getNlCoef0());
            coefficients.setNlCoef1(newCoefficients.getNlCoef1());
            coefficients.setNlCoef2(newCoefficients.getNlCoef2());
            coefficients.setNlCoef3(newCoefficients.getNlCoef3());
            coefficients.setNlCoef4(newCoefficients.getNlCoef4());
            coefficients.setNlCoef5(newCoefficients.getNlCoef5());
            coefficients.setNlCoef6(newCoefficients.getNlCoef6());
            coefficients.setNlCoef7(newCoefficients.getNlCoef7());
            coefficients.setNlOrder(newCoefficients.getNlOrder());
        }
        try {
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getChannel(channelIndex).setCoefficients();
        }
        catch (IOException exception) {
            this.lastException = exception;
            return false;
        }
        return true;
    }

    public String getEEPromInfo(int spectrometerIndex, int slot) {
        if (slot < 0) {
            return null;
        }
        try {
            Spectrometer spectrometer = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
            if (!(spectrometer instanceof USBSpectrometer)) {
                return null;
            }
            return ((USBSpectrometer)spectrometer).getInfo(slot);
        }
        catch (IOException exception) {
            this.lastException = exception;
            return null;
        }
    }

    public boolean setEEPromInfo(int spectrometerIndex, int slot, String str) {
        if (!this.keyIsInserted) {
            return false;
        }
        if (slot < 0) {
            return false;
        }
        Spectrometer spectrometer = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        if (!spectrometer.allowWriteToEEPROM(this.privilegeLevel, slot)) {
            return false;
        }
        try {
            if (!(spectrometer instanceof USBSpectrometer)) {
                return false;
            }
            ((USBSpectrometer)spectrometer).setInfo(slot, str);
        }
        catch (IOException exception) {
            this.lastException = exception;
            return false;
        }
        return true;
    }

    public boolean setDetectorSetPointCelsius(int spectrometerIndex, double temperatureCelsius) {
        if (!this.isFeatureSupportedThermoElectric(spectrometerIndex)) {
            return false;
        }
        ThermoElectric thermoElectricController = this.getFeatureControllerThermoElectric(spectrometerIndex);
        try {
            thermoElectricController.setDetectorSetPointCelsius(temperatureCelsius);
        }
        catch (IOException exception) {
            return false;
        }
        return true;
    }

    public void setExternalTriggerMode(int spectrometerIndex, int mode) {
        this.setExternalTriggerMode(spectrometerIndex, 0, mode);
    }

    public void setExternalTriggerMode(int spectrometerIndex, int channelIndex, int mode) {
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).setExternalTriggerMode(mode);
    }

    public int getExternalTriggerMode(int spectrometerIndex) {
        return this.getExternalTriggerMode(spectrometerIndex, 0);
    }

    public int getExternalTriggerMode(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).getExternalTriggerMode();
    }

    public void setCorrectForElectricalDark(int spectrometerIndex, int enable) {
        this.setCorrectForElectricalDark(spectrometerIndex, 0, enable);
    }

    public void setCorrectForElectricalDark(int spectrometerIndex, int channelIndex, int enable) {
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).setCorrectForElectricalDark(enable != 0, false);
    }

    public boolean getCorrectForElectricalDark(int spectrometerIndex) {
        return this.getCorrectForElectricalDark(spectrometerIndex, 0);
    }

    public boolean getCorrectForElectricalDark(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).isCorrectForElectricalDark();
    }

    public boolean getCorrectForStrayLight(int spectrometerIndex) {
        return this.getCorrectForStrayLight(spectrometerIndex, 0);
    }

    public boolean getCorrectForStrayLight(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).isCorrectForStrayLight();
    }

    public boolean setCorrectForDetectorNonlinearity(int spectrometerIndex, int enable) {
        return this.setCorrectForDetectorNonlinearity(spectrometerIndex, 0, enable);
    }

    public boolean setCorrectForDetectorNonlinearity(int spectrometerIndex, int channelIndex, int enable) {
        if (enable != 0 && !((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).hasNonlinearityCorrectionCoefficients()) {
            return false;
        }
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).setCorrectForDetectorNonlinearity(enable != 0);
        return true;
    }

    public boolean getCorrectForDetectorNonlinearity(int spectrometerIndex) {
        return this.getCorrectForDetectorNonlinearity(spectrometerIndex, 0);
    }

    public boolean getCorrectForDetectorNonlinearity(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).isCorrectForDetectorNonlinearity();
    }

    public void setStrobeEnable(int spectrometerIndex, int lampOn) {
        this.setStrobeEnable(spectrometerIndex, 0, lampOn);
    }

    public void setStrobeEnable(int spectrometerIndex, int channelIndex, int lampOn) {
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).setStrobeEnable(lampOn != 0);
    }

    public int getStrobeEnable(int spectrometerIndex) {
        return this.getStrobeEnable(spectrometerIndex, 0);
    }

    public int getStrobeEnable(int spectrometerIndex, int channelIndex) {
        boolean strobeEnabled = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).getStrobeEnable();
        return strobeEnabled ? 1 : 0;
    }

    private String getDriverVersion(String directory) {
        File[] f = Jars.getAllJarsInDirectory((String)directory);
        String str = "";
        for (int i = 0; i < f.length; ++i) {
            str = str + f[i].getName() + " " + Jars.getJarAttribute((File)f[i], (String)"OpenIDE-Module-Specification-Version") + "\n";
        }
        return str;
    }

    public double getWavelength(int spectrometerIndex, int pixel) {
        return this.getWavelength(spectrometerIndex, 0, pixel);
    }

    public double getWavelength(int spectrometerIndex, int channelIndex, int pixel) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getChannel(channelIndex).getWavelength(pixel);
    }

    public double[] getWavelengths(int spectrometerIndex) {
        return this.getWavelengths(spectrometerIndex, 0);
    }

    public double[] getWavelengths(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getChannel(channelIndex).getAllWavelengths();
    }

    public double getWavelengthIntercept(int spectrometerIndex) {
        return this.getWavelengthIntercept(spectrometerIndex, 0);
    }

    public double getWavelengthIntercept(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getChannel(channelIndex).getCoefficients().getWlIntercept();
    }

    public double getWavelengthFirst(int spectrometerIndex) {
        return this.getWavelengthFirst(spectrometerIndex, 0);
    }

    public double getWavelengthFirst(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getChannel(channelIndex).getCoefficients().getWlFirst();
    }

    public double getWavelengthSecond(int spectrometerIndex) {
        return this.getWavelengthSecond(spectrometerIndex, 0);
    }

    public double getWavelengthSecond(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getChannel(channelIndex).getCoefficients().getWlSecond();
    }

    public double getWavelengthThird(int spectrometerIndex) {
        return this.getWavelengthThird(spectrometerIndex, 0);
    }

    public double getWavelengthThird(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getChannel(channelIndex).getCoefficients().getWlThird();
    }

    public int setTimeout(int spectrometerIndex, int timeoutMilliseconds) {
        try {
            return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(0).setTimeout(timeoutMilliseconds);
        }
        catch (Exception exception) {
            this.lastException = exception;
            return -1;
        }
    }

    public boolean isTimeout(int spectrometerIndex) {
        return this.isTimeout(spectrometerIndex, 0);
    }

    public boolean isTimeout(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getTimeoutState(channelIndex);
    }

    public boolean isSpectrumValid(int spectrometerIndex) {
        return this.isSpectrumValid(spectrometerIndex, 0);
    }

    public boolean isSpectrumValid(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).isSpectrumValid(channelIndex);
    }

    public double[] getSpectrum(int spectrometerIndex) {
        return this.getSpectrum(spectrometerIndex, 0);
    }

    public double[] getSpectrum(int spectrometerIndex, int channelIndex) {
        if (this.rawSpectrumMode) {
            return this.getSpectrumRaw(spectrometerIndex, channelIndex);
        }
        int numberOfPixels = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfPixels();
        int numberOfDarkPixels = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfDarkPixels();
        Spectrum ds = new Spectrum(numberOfPixels, numberOfDarkPixels);
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, false);
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setTimeoutState(channelIndex, false);
        try {
            ds = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).getSpectrum(ds);
        }
        catch (Exception ee) {
            this.lastException = ee;
            boolean timeoutOccurred = false;
            Spectrometer temporarySpectrometerReference = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
            if (temporarySpectrometerReference instanceof USBSpectrometer) {
                timeoutOccurred = ((USBSpectrometer)temporarySpectrometerReference).isTimeout();
            }
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setTimeoutState(channelIndex, timeoutOccurred);
            ds = new Spectrum(numberOfPixels, numberOfDarkPixels);
            double[] pixels = ds.getSpectrum();
            for (int index = 0; index < numberOfPixels; ++index) {
                pixels[index] = 0.0;
            }
            ds.setSpectrum(pixels);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, false);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSpectrumValidity(channelIndex, false);
            return ds.getSpectrum();
        }
        boolean timeoutOccurred = false;
        Spectrometer temporarySpectrometerReference = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        if (temporarySpectrometerReference instanceof USBSpectrometer) {
            timeoutOccurred = ((USBSpectrometer)temporarySpectrometerReference).isTimeout();
        }
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setTimeoutState(channelIndex, timeoutOccurred);
        if (ds == null || timeoutOccurred) {
            ds = new Spectrum(numberOfPixels, numberOfDarkPixels);
            double[] pixels = ds.getSpectrum();
            for (int index = 0; index < numberOfPixels; ++index) {
                pixels[index] = 0.0;
            }
            ds.setSpectrum(pixels);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, false);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSpectrumValidity(channelIndex, false);
            return ds.getSpectrum();
        }
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, ds.isSaturated());
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSpectrumValidity(channelIndex, true);
        return ds.getSpectrum();
    }

    private double[] getSpectrumRaw(int spectrometerIndex, int channelIndex) {
        int numberOfPixels = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfRawPixels();
        int numberOfDarkPixels = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfDarkPixels();
        Spectrum ds = new Spectrum(numberOfPixels, numberOfDarkPixels);
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, false);
        try {
            ds = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).getSpectrumRaw(ds);
        }
        catch (Exception ee) {
            this.lastException = ee;
            ds = new Spectrum(numberOfPixels, numberOfDarkPixels);
            double[] pixels = ds.getSpectrum();
            for (int index = 0; index < numberOfPixels; ++index) {
                pixels[index] = 0.0;
            }
            ds.setSpectrum(pixels);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, false);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSpectrumValidity(channelIndex, false);
            return ds.getSpectrum();
        }
        if (ds == null) {
            ds = new Spectrum(numberOfPixels, numberOfDarkPixels);
            double[] pixels = ds.getSpectrum();
            for (int index = 0; index < numberOfPixels; ++index) {
                pixels[index] = 0.0;
            }
            ds.setSpectrum(pixels);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, false);
            ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSpectrumValidity(channelIndex, false);
            return ds.getSpectrum();
        }
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSaturationState(channelIndex, ds.isSaturated());
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).setSpectrumValidity(channelIndex, true);
        return ds.getSpectrum();
    }

    public void stopAveraging(int spectrometerIndex) {
        this.stopAveraging(spectrometerIndex, 0);
    }

    public void stopAveraging(int spectrometerIndex, int channelIndex) {
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).stopAveraging();
    }

    public boolean isSaturated(int spectrometerIndex) {
        return this.isSaturated(spectrometerIndex, 0);
    }

    public boolean isSaturated(int spectrometerIndex, int channelIndex) {
        return ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSaturationState(channelIndex);
    }

    public void closeAllSpectrometers() {
        for (int spectrometerIndex = 0; spectrometerIndex < this.spectrometerAssemblyCollection.size(); ++spectrometerIndex) {
            this.closeSpectrometer(spectrometerIndex);
        }
        this.spectrometerAssemblyCollection = new ArrayList();
    }

    public void closeSpectrometer(int spectrometerIndex) {
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).closeSpectrometer();
    }

    public GPIO getFeatureControllerGPIO(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (GPIO)((Object)usbSpectrometer.getFeatureController(GPIOImpl.class));
    }

    public boolean isFeatureSupportedGPIO(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        GPIO gpio = (GPIO)((Object)usbSpectrometer.getFeatureController(GPIOImpl.class));
        return gpio != null;
    }

    public SaturationThreshold getFeatureControllerSaturationThreshold(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (SaturationThreshold)((Object)usbSpectrometer.getFeatureController(SaturationThresholdImpl.class));
    }

    public boolean isFeatureSupportedSaturationThreshold(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        SaturationThreshold saturationThreshold = (SaturationThreshold)((Object)usbSpectrometer.getFeatureController(SaturationThresholdImpl.class));
        return saturationThreshold != null;
    }

    public SPIBus getFeatureControllerSPIBus(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (SPIBus)((Object)usbSpectrometer.getFeatureController(SPIBusImpl.class));
    }

    public boolean isFeatureSupportedSPIBus(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        SPIBus spiBus = (SPIBus)((Object)usbSpectrometer.getFeatureController(SPIBusImpl.class));
        return spiBus != null;
    }

    public SingleStrobe getFeatureControllerSingleStrobe(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (SingleStrobe)((Object)usbSpectrometer.getFeatureController(SingleStrobeImpl.class));
    }

    public boolean isFeatureSupportedSingleStrobe(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        SingleStrobe singleStrobe = (SingleStrobe)((Object)usbSpectrometer.getFeatureController(SingleStrobeImpl.class));
        return singleStrobe != null;
    }

    public ContinuousStrobe getFeatureControllerContinuousStrobe(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (ContinuousStrobe)((Object)usbSpectrometer.getFeatureController(ContinuousStrobeImpl.class));
    }

    public boolean isFeatureSupportedContinuousStrobe(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        ContinuousStrobe continuousStrobe = (ContinuousStrobe)((Object)usbSpectrometer.getFeatureController(ContinuousStrobeImpl.class));
        return continuousStrobe != null;
    }

    public CurrentOut getFeatureControllerCurrentOut(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (CurrentOut)((Object)usbSpectrometer.getFeatureController(CurrentOutImpl_LS450.class));
    }

    public boolean isFeatureSupportedCurrentOut(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        CurrentOut currentOut = (CurrentOut)((Object)usbSpectrometer.getFeatureController(CurrentOutImpl_LS450.class));
        return currentOut != null;
    }

    public BoardTemperature getFeatureControllerBoardTemperature(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (BoardTemperature)((Object)usbSpectrometer.getFeatureController(BoardTemperatureImpl.class));
    }

    public boolean isFeatureSupportedBoardTemperature(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        BoardTemperature boardTemperature = (BoardTemperature)((Object)usbSpectrometer.getFeatureController(BoardTemperatureImpl.class));
        return boardTemperature != null;
    }

    public DetectorTemperature getFeatureControllerDetectorTemperature(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (DetectorTemperature)((Object)usbSpectrometer.getFeatureController(DetectorTemperatureImpl.class));
    }

    public boolean isFeatureSupportedDetectorTemperature(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        DetectorTemperature detectorTemperature = (DetectorTemperature)((Object)usbSpectrometer.getFeatureController(DetectorTemperatureImpl.class));
        return detectorTemperature != null;
    }

    public AnalogIn getFeatureControllerAnalogIn(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (AnalogIn)((Object)usbSpectrometer.getFeatureController(AnalogInImpl.class));
    }

    public boolean isFeatureSupportedAnalogIn(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        AnalogIn analogIn = (AnalogIn)((Object)usbSpectrometer.getFeatureController(AnalogInImpl.class));
        return analogIn != null;
    }

    public AnalogOut getFeatureControllerAnalogOut(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (AnalogOut)((Object)usbSpectrometer.getFeatureController(AnalogOutImpl.class));
    }

    public boolean isFeatureSupportedAnalogOut(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        AnalogOut analogOut = (AnalogOut)((Object)usbSpectrometer.getFeatureController(AnalogOutImpl.class));
        return analogOut != null;
    }

    public ExternalTriggerDelay getFeatureControllerExternalTriggerDelay(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (ExternalTriggerDelay)((Object)usbSpectrometer.getFeatureController(ExternalTriggerDelayImpl.class));
    }

    public boolean isFeatureSupportedExternalTriggerDelay(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        ExternalTriggerDelay externalTriggerDelay = (ExternalTriggerDelay)((Object)usbSpectrometer.getFeatureController(ExternalTriggerDelayImpl.class));
        return externalTriggerDelay != null;
    }

    public I2CBus getFeatureControllerI2CBus(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (I2CBus)((Object)usbSpectrometer.getFeatureController(I2CBusImpl.class));
    }

    public boolean isFeatureSupportedI2CBus(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        I2CBus i2cbus = (I2CBus)((Object)usbSpectrometer.getFeatureController(I2CBusImpl.class));
        return i2cbus != null;
    }

    public HighGainMode getFeatureControllerHighGainMode(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (HighGainMode)((Object)usbSpectrometer.getFeatureController(HighGainModeImpl.class));
    }

    public boolean isFeatureSupportedHighGainMode(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        HighGainMode featureController = (HighGainMode)((Object)usbSpectrometer.getFeatureController(HighGainModeImpl.class));
        return featureController != null;
    }

    public IrradianceCalibrationFactor getFeatureControllerIrradianceCalibrationFactor(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (IrradianceCalibrationFactor)((Object)usbSpectrometer.getFeatureController(IrradianceCalibrationFactorImpl.class));
    }

    public boolean isFeatureSupportedIrradianceCalibrationFactor(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        IrradianceCalibrationFactor irradianceCalibrationFactor = (IrradianceCalibrationFactor)((Object)usbSpectrometer.getFeatureController(IrradianceCalibrationFactorImpl.class));
        return irradianceCalibrationFactor != null;
    }

    public LS450_Functions getFeatureControllerLS450(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (LS450_Functions)((Object)usbSpectrometer.getFeatureController(LS450_FunctionsImpl.class));
    }

    public boolean isFeatureSupportedLS450(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        LS450_Functions ls450Functions = (LS450_Functions)((Object)usbSpectrometer.getFeatureController(LS450_FunctionsImpl.class));
        if (ls450Functions == null) {
            return false;
        }
        PlugInProviderImpl pluginProvider = (PlugInProviderImpl)usbSpectrometer.getFeatureController(PlugInProviderImpl.class);
        if (pluginProvider == null) {
            return false;
        }
        try {
            SpectrometerPlugIn[] spectrometerPluginArray = pluginProvider.getPlugIns();
            for (int jj = 0; jj < spectrometerPluginArray.length; ++jj) {
                if (spectrometerPluginArray[jj].getName().compareTo("USB-LS-450") != 0) continue;
                return true;
            }
        }
        catch (IOException exception) {
            System.out.println(exception);
            return false;
        }
        return false;
    }

    public UV_VIS_LightSource getFeatureController_UV_VIS_LightSource(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        PlugInProviderImpl pluginProvider = (PlugInProviderImpl)usbSpectrometer.getFeatureController(PlugInProviderImpl.class);
        if (pluginProvider == null) {
            return null;
        }
        try {
            SpectrometerPlugIn[] spectrometerPluginArray = pluginProvider.getPlugIns();
            for (int jj = 0; jj < spectrometerPluginArray.length; ++jj) {
                if (spectrometerPluginArray[jj].getName().compareTo("USB-ISS-UV") != 0) continue;
                return (UV_VIS_LightSource)((Object)spectrometerPluginArray[jj]);
            }
        }
        catch (IOException exception) {
            System.out.println(exception);
            return null;
        }
        return null;
    }

    public boolean isFeatureSupported_UV_VIS_LightSource(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        PlugInProviderImpl pluginProvider = (PlugInProviderImpl)usbSpectrometer.getFeatureController(PlugInProviderImpl.class);
        if (pluginProvider == null) {
            return false;
        }
        try {
            SpectrometerPlugIn[] spectrometerPluginArray = pluginProvider.getPlugIns();
            for (int jj = 0; jj < spectrometerPluginArray.length; ++jj) {
                if (spectrometerPluginArray[jj].getName().compareTo("USB-ISS-UV") != 0) continue;
                return true;
            }
        }
        catch (IOException exception) {
            System.out.println(exception);
            return false;
        }
        return false;
    }

    public NonlinearityCorrectionProvider getFeatureControllerNonlinearityCorrectionProvider(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (NonlinearityCorrectionProvider)((Object)usbSpectrometer.getFeatureController(NonlinearityCorrectionImpl.class));
    }

    public boolean isFeatureSupportedNonlinearityCorrectionProvider(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        NonlinearityCorrectionProvider nonlinearityCorrectionProvider = (NonlinearityCorrectionProvider)((Object)usbSpectrometer.getFeatureController(NonlinearityCorrectionImpl.class));
        return nonlinearityCorrectionProvider != null;
    }

    public StrayLightCorrection getFeatureControllerStrayLightCorrection(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (StrayLightCorrection)((Object)usbSpectrometer.getFeatureController(StrayLightCorrectionImpl.class));
    }

    public boolean isFeatureSupportedStrayLightCorrection(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        StrayLightCorrection strayLightCorrection = (StrayLightCorrection)((Object)usbSpectrometer.getFeatureController(StrayLightCorrectionImpl.class));
        return strayLightCorrection != null;
    }

    public Version getFeatureControllerVersion(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        Version version = (Version)((Object)usbSpectrometer.getFeatureController(VersionImpl.class));
        try {
            String fv = version.getFirmwareVersion();
        }
        catch (Exception ee) {
            // empty catch block
        }
        return version;
    }

    public boolean isFeatureSupportedVersion(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        Version version = (Version)((Object)usbSpectrometer.getFeatureController(VersionImpl.class));
        return version != null;
    }

    public WavelengthCalibrationProvider getFeatureControllerWavelengthCalibrationProvider(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (WavelengthCalibrationProvider)((Object)usbSpectrometer.getFeatureController(WavelengthCalibrationImpl.class));
    }

    public boolean isFeatureSupportedWavelengthCalibrationProvider(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        WavelengthCalibrationProvider wavelengthCalibrationProvider = (WavelengthCalibrationProvider)((Object)usbSpectrometer.getFeatureController(WavelengthCalibrationImpl.class));
        return wavelengthCalibrationProvider != null;
    }

    public ThermoElectric getFeatureControllerThermoElectric(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (ThermoElectric)((Object)usbSpectrometer.getFeatureController(ThermoElectricImpl.class));
    }

    public boolean isFeatureSupportedThermoElectric(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        ThermoElectric thermoElectric = (ThermoElectric)((Object)usbSpectrometer.getFeatureController(ThermoElectricImpl.class));
        return thermoElectric != null;
    }

    public Indy getFeatureControllerIndy(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (Indy)((Object)usbSpectrometer.getFeatureController(IndyImpl.class));
    }

    public boolean isFeatureSupportedIndy(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        Indy indy = (Indy)((Object)usbSpectrometer.getFeatureController(IndyImpl.class));
        return indy != null;
    }

    public InternalTrigger getFeatureControllerInternalTrigger(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        return (InternalTrigger)((Object)usbSpectrometer.getFeatureController(InternalTriggerImpl_Jaz.class));
    }

    public boolean isFeatureSupportedInternalTrigger(int spectrometerIndex) {
        USBSpectrometer usbSpectrometer = (USBSpectrometer)((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer();
        InternalTrigger internalTrigger = (InternalTrigger)((Object)usbSpectrometer.getFeatureController(InternalTriggerImpl_Jaz.class));
        return internalTrigger != null;
    }

    public void setAutoToggleStrobeLampEnable(int spectrometerIndex, boolean enable) {
        this.setAutoToggleStrobeLampEnable(spectrometerIndex, 0, enable);
    }

    public void setAutoToggleStrobeLampEnable(int spectrometerIndex, int channelIndex, boolean enable) {
        ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex).setAutoToggleStrobeLampEnable(enable);
    }

    public void highSpdAcq_AllocateBuffer(int spectrometerIndex, int numberOfSpectra) {
        this.numberOfSpectraAcquired = 0;
        this.stopCollectingSpectra = false;
        int numberOfPixels = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfPixels();
        int numberOfDarkPixels = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectrometer().getNumberOfDarkPixels();
        this.spectrumBuffer = new Spectrum[numberOfSpectra];
        this.isSaturatedBuffer = new boolean[numberOfSpectra];
        this.timeStampBuffer = new HighResTimeStamp[numberOfSpectra];
        for (int index = 0; index < numberOfSpectra; ++index) {
            this.spectrumBuffer[index] = new Spectrum(numberOfPixels, numberOfDarkPixels);
            this.isSaturatedBuffer[index] = false;
            this.timeStampBuffer[index] = null;
        }
    }

    public void highSpdAcq_StartAcquisition(int spectrometerIndex) {
        this.highSpdAcq_StartAcquisition(spectrometerIndex, 0);
    }

    public void highSpdAcq_StartAcquisition(int spectrometerIndex, int channelIndex) {
        this.numberOfSpectraAcquired = 0;
        int maximumNumberOfSpectraToAcquire = this.spectrumBuffer.length;
        SpectralProcessor spectralProcessor = ((SpectrometerAssembly)this.spectrometerAssemblyCollection.get(spectrometerIndex)).getSpectralProcessor(channelIndex);
        this.stopCollectingSpectra = false;
        try {
            for (int loopCounter = 0; loopCounter < maximumNumberOfSpectraToAcquire && !this.stopCollectingSpectra; ++loopCounter) {
                spectralProcessor.getSpectrum(this.spectrumBuffer[loopCounter]);
                this.timeStampBuffer[loopCounter] = new HighResTimeStamp();
                this.isSaturatedBuffer[loopCounter] = this.spectrumBuffer[loopCounter].isSaturated();
                ++this.numberOfSpectraAcquired;
            }
        }
        catch (IOException ee) {
            this.numberOfSpectraAcquired = 0;
            this.lastException = ee;
            return;
        }
    }

    public void highSpdAcq_StopAcquisition() {
        this.stopCollectingSpectra = true;
    }

    public int highSpdAcq_GetNumberOfSpectraAcquired() {
        return this.numberOfSpectraAcquired;
    }

    public double[] highSpdAcq_GetSpectrum(int spectrumNumber) {
        if (spectrumNumber >= this.numberOfSpectraAcquired) {
            return null;
        }
        if (this.spectrumBuffer == null) {
            return null;
        }
        return this.spectrumBuffer[spectrumNumber].getSpectrum();
    }

    public boolean highSpdAcq_IsSaturated(int spectrumNumber) {
        if (spectrumNumber >= this.numberOfSpectraAcquired) {
            return true;
        }
        if (this.isSaturatedBuffer == null) {
            return true;
        }
        return this.isSaturatedBuffer[spectrumNumber];
    }

    public HighResTimeStamp highSpdAcq_GetTimeStamp(int spectrumNumber) {
        if (spectrumNumber >= this.numberOfSpectraAcquired) {
            return null;
        }
        if (this.timeStampBuffer == null) {
            return null;
        }
        return this.timeStampBuffer[spectrumNumber];
    }

    public static void mainOBSOLETE() {
        Wrapper wrapper = new Wrapper();
        int numberOfSpectrometers = wrapper.openAllSpectrometers();
        System.out.println("Number of spectrometers detected = " + numberOfSpectrometers);
        if (numberOfSpectrometers == 0) {
            System.out.println("No attached spectrometers, exiting.");
            return;
        }
        int spectrometerIndex = 0;
        wrapper.getSerialNumber(spectrometerIndex);
        int numberOfChannels = wrapper.getWrapperExtensions().getNumberOfChannels(spectrometerIndex);
        System.out.println("number of channels = " + numberOfChannels);
        System.out.println("number of enabled channels = " + wrapper.getWrapperExtensions().getNumberOfEnabledChannels(spectrometerIndex));
    }
}

