/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.constants;

import java.util.ResourceBundle;

public class ErrorCode {
    private int errorCode = 0;
    private int ignoreCode = 0;
    public static final int ERROR_CODE_NORMAL = 1;
    public static final int ERROR_CODE_INTERLOCK = 2;
    public static final int ERROR_CODE_GATED_MODE = 4;
    public static final int ERROR_TRIGGER_MODE = 8;
    public static final int ERROR_CODE_DEEPWELL_MODE = 16;
    private static String __extern__ = "__extern__\n<init>,(I)V\nsetErrorCode,(IZ)V\ngetErrorCodes,()I\nisCodeIgnored,(I)Z\nsetCodeIgnored,(IZ)V\nisErrorCodeSet,(I)Z\ngetAllErrorResponses,()[Ljava/lang/String;\ngetErrorResponse,(I)Ljava/lang/String;\ngetIngoreResponse,()Ljava/lang/String;\ngetErrorCount,()I\n";

    public ErrorCode(int newCode) {
        this.errorCode = newCode;
    }

    public void setErrorCode(int code, boolean on) {
        this.errorCode = on ? (this.errorCode |= code) : (this.errorCode &= ~code);
    }

    public int getErrorCodes() {
        return this.errorCode;
    }

    public boolean isCodeIgnored(int code) {
        return (this.ignoreCode & code) == code;
    }

    public void setCodeIgnored(int code, boolean ignore) {
        switch (code) {
            case 1: {
                code = 2;
                break;
            }
            case 2: {
                code = 4;
                break;
            }
            case 3: {
                code = 8;
                break;
            }
            case 16: {
                code = 16;
            }
        }
        this.ignoreCode = ignore ? (this.ignoreCode |= code) : (this.ignoreCode &= ~code);
    }

    public boolean isErrorCodeSet(int code) {
        return (this.errorCode & code) == code;
    }

    public String[] getAllErrorResponses() {
        String[] responses = new String[this.getErrorCount()];
        int i = 0;
        if ((this.errorCode & 2) == 2) {
            responses[i] = ResourceBundle.getBundle("com/oceanoptics/omnidriver/constants/Bundle").getString("ERROR_INTERLOCK");
            ++i;
        }
        if ((this.errorCode & 4) == 4) {
            responses[i] = ResourceBundle.getBundle("com/oceanoptics/omnidriver/constants/Bundle").getString("ERROR_GATED_MODE");
            ++i;
        }
        if ((this.errorCode & 8) == 8) {
            responses[i] = ResourceBundle.getBundle("com/oceanoptics/omnidriver/constants/Bundle").getString("ERROR_TRIGGER_MODE");
            ++i;
        }
        if ((this.errorCode & 0x10) == 16) {
            responses[i] = ResourceBundle.getBundle("com/oceanoptics/omnidriver/constants/Bundle").getString("ERROR_DEEPWELL_MODE");
            ++i;
        }
        return responses;
    }

    public String getErrorResponse(int code) {
        if ((code & 2) == 2) {
            return ResourceBundle.getBundle("com/oceanoptics/omnidriver/constants/Bundle").getString("ERROR_INTERLOCK");
        }
        if ((code & 4) == 4) {
            return ResourceBundle.getBundle("com/oceanoptics/omnidriver/constants/Bundle").getString("ERROR_GATED_MODE");
        }
        if ((code & 8) == 8) {
            return ResourceBundle.getBundle("com/oceanoptics/omnidriver/constants/Bundle").getString("ERROR_TRIGGER_MODE");
        }
        if ((code & 0x10) == 16) {
            return ResourceBundle.getBundle("com/oceanoptics/omnidriver/constants/Bundle").getString("ERROR_DEEPWELL_MODE");
        }
        return null;
    }

    public String getIngoreResponse() {
        return ResourceBundle.getBundle("com/oceanoptics/omnidriver/constants/Bundle").getString("ERROR_IGNORE");
    }

    public int getErrorCount() {
        int count = 0;
        if ((this.errorCode & 2) == 2) {
            ++count;
        }
        if ((this.errorCode & 4) == 4) {
            ++count;
        }
        if ((this.errorCode & 8) == 8) {
            ++count;
        }
        if ((this.errorCode & 0x10) == 16) {
            ++count;
        }
        return count;
    }
}

