/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.advancedintegrationclock;

import com.oceanoptics.omnidriver.features.FPGAImpl;
import com.oceanoptics.omnidriver.features.advancedintegrationclock.AdvancedIntegrationClock;
import com.oceanoptics.omnidriver.interfaces.MasterClockDivisorListener;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import java.io.IOException;

public class AdvancedIntegrationClockImpl
extends FPGAImpl
implements AdvancedIntegrationClock,
MasterClockDivisorListener {
    private final long MAX_INTEGRATION_TIME = 64000000L;
    private final long MIN_INTEGRATION_TIME = 1L;
    private long advancedIntegrationTimeIncrement = 1L;
    private Long delay = null;
    private Long baseClock = null;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetIntegrationClockTimer,()I\ngetIntegrationTimeBaseClock,()I\ngetIntegrationTime,()Ljava/lang/Long;\nsetAdvancedIntegrationTime,(J)V\ngetAdvancedIntegrationTimeMinimum,()J\ngetAdvancedIntegrationTimeMaximum,()J\ngetAdvancedIntegrationTimeIncrement,()J\nmasterClockChanged,(J)V\n";

    public AdvancedIntegrationClockImpl(USBInterface usbInt) throws IOException {
        super(usbInt);
        this.init();
    }

    private void init() throws IOException {
        this.delay = new Long(this.getFPGA((byte)24));
        this.baseClock = new Long(this.getFPGA((byte)16));
    }

    public int getIntegrationClockTimer() throws IOException {
        this.logger.fine("Integration clock timer: 24");
        return this.getFPGA((byte)24);
    }

    public int getIntegrationTimeBaseClock() throws IOException {
        this.logger.fine("Integration time base clock: 16");
        return this.getFPGA((byte)16);
    }

    public Long getIntegrationTime() {
        if (null == this.delay || null == this.baseClock) {
            return null;
        }
        return new Long(this.delay * (this.baseClock + 1L) / 48L);
    }

    public void setAdvancedIntegrationTime(long delayMicros) throws IOException {
        int timerValue = 48;
        int baseClockValue = 0;
        int bits = (int)Math.round(Math.log(delayMicros) / Math.log(2.0));
        if (bits < 20) {
            timerValue = (int)((long)timerValue * (delayMicros % 1024L));
            baseClockValue = (int)(delayMicros / 1024L);
            this.advancedIntegrationTimeIncrement = 1L;
        } else if (bits <= 26) {
            timerValue = 48000;
            baseClockValue = (int)(delayMicros / 1000L);
            this.advancedIntegrationTimeIncrement = 1000L;
        } else {
            throw new IllegalArgumentException("Input integration time too large (" + delayMicros + " > 64000000)");
        }
        this.setFPGA((byte)24, timerValue);
        this.setFPGA((byte)16, baseClockValue);
        this.delay = new Long(timerValue);
        this.baseClock = new Long(baseClockValue);
    }

    public long getAdvancedIntegrationTimeMinimum() {
        return this.MIN_INTEGRATION_TIME;
    }

    public long getAdvancedIntegrationTimeMaximum() {
        return this.MAX_INTEGRATION_TIME;
    }

    public long getAdvancedIntegrationTimeIncrement() {
        return this.advancedIntegrationTimeIncrement;
    }

    public void masterClockChanged(long newValue) {
    }
}

