/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.advancedversion;

import com.oceanoptics.omnidriver.features.FPGAImpl;
import com.oceanoptics.omnidriver.features.advancedversion.AdvancedVersion;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class AdvancedVersionImpl
extends FPGAImpl
implements AdvancedVersion {
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetFPGAFirmwareVersion,()Ljava/lang/String;\ngetPSOCVersion,()Ljava/lang/String;\n";

    public AdvancedVersionImpl(USBInterface usbInt) {
        super(usbInt);
    }

    public String getFPGAFirmwareVersion() throws IOException {
        int v = this.getFPGA((byte)4);
        byte lo = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)v));
        byte hi = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)v));
        String version = this.makeVersionString(lo, hi);
        this.logger.fine("FPGA Firmware: " + version);
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPSOCVersion() throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            byte[] byArray2 = this.in;
            synchronized (this.in) {
                String version = "invalid";
                this.out[0] = 105;
                this.out[1] = 16;
                this.out[2] = 2;
                this.out[3] = 1;
                this.out[4] = 3;
                this.usb.bulkOut(this.lowSpeedInEndPoint, this.out, 5);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.logger.severe("PSoOC read error.");
                    e.printStackTrace();
                }
                this.out[0] = 104;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 2);
                version = this.makeVersionString(this.in[0], this.in[1]);
                this.logger.fine("PSoC Version: " + version);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return version;
            }
        }
    }

    private String makeVersionString(byte lo, byte hi) {
        String version = "invalid";
        this.logger.finest("Making version string.");
        String low = Integer.toHexString(lo);
        String high = Integer.toHexString(hi);
        try {
            version = high.substring(0, 1) + "." + high.substring(1, high.length()) + low.substring(0, 1) + "." + low.substring(1, low.length());
        }
        catch (NumberFormatException ne) {
            version = high + low;
        }
        return version;
    }
}

