/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.analogout;

import com.oceanoptics.omnidriver.features.analogout.AnalogOutImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.spam.numericalmethods.NumericalMethods;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class AnalogOutImpl_PSOC
extends AnalogOutImpl {
    private Integer lastCounts = null;
    private int MIN_COUNTS = 0;
    private int MAX_COUNTS = 510;
    private int COUNTS_STEP = 1;
    protected String featurePath = "analogout.AnalogOutPanel";
    private static final short DATA_OUT = 1;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    public USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
    public USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    private double COUNTS_PER_VOLT = (double)this.MAX_COUNTS / 5.0;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\nsetDACCounts,(II)V\nanalogOutCountsToVolts,(I)D\ngetDACCounts,(I)Ljava/lang/Integer;\ngetDACMinimum,()I\ngetDACMaximum,()I\ngetDACIncrement,()I\nisDACPresent,()Z\ngetDACPins,()I\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public AnalogOutImpl_PSOC(USBInterface usbInt) {
        super(usbInt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDACCounts(int counts, int channel) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.out[0] = 105;
            this.out[1] = 16;
            this.out[2] = 2;
            this.out[3] = 3;
            this.out[4] = 2;
            this.out[5] = ByteRoutines.getHighByte((short)((short)counts));
            this.out[6] = ByteRoutines.getLowByte((short)((short)counts));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 7);
            this.lastCounts = new Integer(counts);
            this.logger.fine("Wrote" + counts + " to the PSoC.");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public double analogOutCountsToVolts(int counts) {
        NumericalMethods nm = new NumericalMethods();
        double[] Xsamples = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 50.0, 60.0, 75.0, 90.0, 100.0, 125.0, 150.0, 175.0, 200.0, 225.0, 250.0, 275.0, 300.0, 350.0, 400.0, 450.0, 465.0, 475.0, 480.0, 482.0, 483.0, 485.0, 487.0, 488.0, 489.0, 490.0, 491.0, 492.0, 511.0};
        double[] Ysamples = new double[]{0.039, 0.04, 0.044, 0.053, 0.064, 0.075, 0.122, 0.178, 0.225, 0.272, 0.327, 0.375, 0.422, 0.525, 0.627, 0.775, 0.925, 1.028, 1.28, 1.53, 1.783, 2.025, 2.279, 2.53, 2.791, 3.044, 3.547, 4.042, 4.546, 4.699, 4.807, 4.863, 4.891, 4.906, 4.943, 4.973, 5.008, 5.1, 5.173, 5.176, 5.176, 5.176};
        double[] value = nm.cubicSpline(Xsamples, Ysamples, new double[]{counts});
        return value[0];
    }

    public Integer getDACCounts(int channel) {
        return this.lastCounts;
    }

    public int getDACMinimum() {
        return this.MIN_COUNTS;
    }

    public int getDACMaximum() {
        return this.MAX_COUNTS;
    }

    public int getDACIncrement() {
        return this.COUNTS_STEP;
    }

    public boolean isDACPresent() throws IOException {
        return true;
    }

    public int getDACPins() {
        return 1;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

