/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.badpixelremoval;

import com.oceanoptics.omnidriver.features.badpixelremoval.BadPixelRemovalImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.USBSpectrometer;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class BadPixelRemovalImpl_Dragon
extends BadPixelRemovalImpl {
    protected static final short DATA_OUT = 2;
    protected static final short LOW_SPEED_DATA_IN = 135;
    protected static final short MAX_PACKET_SIZE = 64;
    protected static final int MAX_ALLOWED_NUMBER_OF_BAD_PIXELS = 128;
    USBSpectrometer _spectrometer;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/USBSpectrometer;I)V\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;I)V\ngetBadPixelsFromSpectrometer,()[I\nsetBadPixelsToSpectrometer,()V\n";

    public BadPixelRemovalImpl_Dragon(USBInterface usbInt, USBSpectrometer spectrometer, int numPixels) {
        super(usbInt, numPixels);
        this.initialize(spectrometer);
    }

    public BadPixelRemovalImpl_Dragon(USBInterface usbInt, int numPixels) {
        super(usbInt, numPixels);
        this.initialize(null);
    }

    private void initialize(USBSpectrometer spectrometer) {
        this._spectrometer = spectrometer;
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 135, 2, 64, 0);
        try {
            this.badPixels = this.getBadPixelsFromSpectrometer();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private int[] getBadPixelsFromDevice() {
        String strBadPixels;
        byte[] inarray = new byte[256];
        try {
            byte[] byArray = this.in;
            // MONITORENTER : this.in
            byte[] byArray2 = this.out;
            // MONITORENTER : this.out
            this.out[0] = 5;
            this.out[1] = 17;
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
            this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 64);
            strBadPixels = "";
            for (int ii = 2; this.in[ii] != 0 && ii < 17; ++ii) {
                strBadPixels = strBadPixels + (char)this.in[ii];
            }
            // MONITOREXIT : byArray2
            // MONITOREXIT : byArray
            for (int i = 0; i < 4; ++i) {
                byArray2 = this.in;
                // MONITORENTER : this.in
                byte[] ii = this.out;
                // MONITORENTER : this.out
                this.out[0] = 109;
                this.out[1] = (byte)(i * 64);
                this.out[2] = 0;
                try {
                    Thread.sleep(200L);
                }
                catch (Exception ee) {
                    // empty catch block
                }
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
                try {
                    Thread.sleep(200L);
                }
                catch (Exception ee) {
                    // empty catch block
                }
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 64);
                System.arraycopy(this.in, 0, inarray, 64 * i, 64);
                // MONITOREXIT : ii
                // MONITOREXIT : byArray2
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        int[] pix = null;
        try {
            int numBadPixels = Integer.parseInt(strBadPixels);
            if (numBadPixels <= 0) return pix;
            pix = new int[Integer.parseInt(strBadPixels)];
            int i = 0;
            while (i < numBadPixels) {
                pix[i] = ByteRoutines.makeDWord((byte)0, (byte)0, (byte)inarray[2 * i + 1], (byte)inarray[2 * i]);
                ++i;
            }
            return pix;
        }
        catch (NumberFormatException nfe) {
            return new int[0];
        }
    }

    public int[] getBadPixelsFromSpectrometer() throws IOException {
        this.badPixels = this.getBadPixelsFromDevice();
        if (this.badPixels == null) {
            this.numberOfBadPixels = 0;
            return null;
        }
        this.numberOfBadPixels = this.badPixels.length;
        if (this.numberOfBadPixels > 128) {
            this.numberOfBadPixels = 0;
            this.badPixels = null;
            System.err.println("Dragon: Invalid number of pixels.");
            this.logger.finest("Dragon: Invalid number of pixels.");
            return null;
        }
        return this.badPixels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBadPixelsToSpectrometer() throws IOException {
        byte[] outputBytes = new byte[256];
        if (this.numberOfBadPixels > 128) {
            return;
        }
        byte[] byArray = this.out;
        synchronized (this.out) {
            int index;
            String strNumberOfBadPixels = Integer.toString(this.numberOfBadPixels);
            byte[] byteArrayForm = strNumberOfBadPixels.getBytes();
            for (index = 0; index < 17; ++index) {
                this.out[index] = 0;
            }
            this.out[0] = 6;
            this.out[1] = 17;
            for (index = 0; index < byteArrayForm.length; ++index) {
                this.out[index + 2] = byteArrayForm[index];
            }
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 17);
            if (this.numberOfBadPixels == 0) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return;
            }
            for (index = 0; index < outputBytes.length; ++index) {
                outputBytes[index] = 0;
            }
            for (index = 0; index < this.numberOfBadPixels; ++index) {
                outputBytes[index * 2] = ByteRoutines.getLowByte((short)((short)this.badPixels[index]));
                outputBytes[index * 2 + 1] = ByteRoutines.getHighByte((short)((short)this.badPixels[index]));
            }
            for (index = 0; index < 8; ++index) {
                this.out[0] = 110;
                this.out[1] = (byte)(index * 32);
                this.out[2] = 0;
                this.out[3] = 32;
                for (int mm = 0; mm < 32; ++mm) {
                    this.out[mm + 4] = outputBytes[index * 32 + mm];
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception ee) {
                    // empty catch block
                }
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 36);
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return;
        }
    }
}

