/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.boardtemperature;

import com.oceanoptics.omnidriver.features.boardtemperature.BoardTemperatureImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class BoardTemperatureImpl_QE65000
extends BoardTemperatureImpl {
    private static final short DATA_OUT = 1;
    private static final short LOW_SPEED_DATA_IN = 129;
    private static final short MAX_PACKET_SIZE = 512;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\ngetBoardTemperatureCelsius,()D\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public BoardTemperatureImpl_QE65000(USBInterface usbInt) {
        super(usbInt);
        this.dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
        this.lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBoardTemperatureCelsius() throws IOException {
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                double value = -1.0;
                this.out[0] = 108;
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 1);
                this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 6);
                if (this.in[0] != 8) {
                    this.logger.warning("Invalid temperature response");
                    throw new IOException("Invalid temperature response");
                }
                value = ByteRoutines.makeWord((byte)this.in[2], (byte)this.in[1]);
                this.logger.fine("Board Temperature: " + (value *= 0.003906));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return value;
            }
        }
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

