/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.errorprovider;

import com.oceanoptics.omnidriver.constants.ErrorCode;
import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.errorprovider.DeepWellErrorProvider;
import com.oceanoptics.omnidriver.interfaces.AcquisitionPropertiesListener;
import com.oceanoptics.omnidriver.interfaces.OmniDriverDispatchListener;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.adc1000usb.ADC1000USB;
import java.util.ArrayList;

public class DeepWellErrorProviderImpl
extends USBFeature {
    private Spectrometer spectrometer;
    private int deepWellMinIntegrationTime;
    private ErrorCode errorCode;
    private int lastIntegrationTime = -1;
    private boolean ignore;
    protected transient ArrayList dispatchListenerList;
    protected transient ArrayList acquisitionPropertiesListenerList;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\ncheckIntegrationTime,(I)V\nisInDeepWellMode,()Z\nsetIgnore,(Z)V\naddOmniDriverDispatchListener,(Lcom/oceanoptics/omnidriver/interfaces/OmniDriverDispatchListener;)V\nremoveOmniDriverDispatchListener,(Lcom/oceanoptics/omnidriver/interfaces/OmniDriverDispatchListener;)V\naddAcquisitionPropertiesListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionPropertiesListener;)V\nremoveAcquisitionPropertiesListener,(Lcom/oceanoptics/omnidriver/interfaces/AcquisitionPropertiesListener;)V\nfireAcquisitionPropertiesListener,()V\n";

    public DeepWellErrorProviderImpl(USBInterface usbInt, Spectrometer spectrometer) {
        super(usbInt);
        this.spectrometer = spectrometer;
        this.ignore = true;
        this.errorCode = new ErrorCode(16);
        this.errorCode.setCodeIgnored(16, true);
        this.deepWellMinIntegrationTime = ((DeepWellErrorProvider)((Object)spectrometer)).getDeepWellMinimumIntegrationTime();
    }

    public void checkIntegrationTime(int intTime) {
        if (this.isInDeepWellMode()) {
            if (intTime < this.deepWellMinIntegrationTime) {
                if (this.errorCode != null) {
                    this.errorCode.setErrorCode(16, true);
                } else {
                    this.errorCode = new ErrorCode(16);
                }
                if (!this.errorCode.isCodeIgnored(16) || intTime != this.lastIntegrationTime && !this.ignore) {
                    this.fireOmniDriverDispatchListener(this.errorCode, 16);
                    this.ignore = true;
                }
            } else {
                this.ignore = false;
            }
            this.lastIntegrationTime = intTime;
        }
    }

    public boolean isInDeepWellMode() {
        return ((ADC1000USB)this.spectrometer).isDeepWell();
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
        int temp = this.errorCode.getErrorCodes();
        this.errorCode.setCodeIgnored(16, ignore);
    }

    public void addOmniDriverDispatchListener(OmniDriverDispatchListener listener) {
        if (this.dispatchListenerList == null) {
            this.dispatchListenerList = new ArrayList();
        }
        this.dispatchListenerList.add(listener);
    }

    public void removeOmniDriverDispatchListener(OmniDriverDispatchListener listener) {
        if (this.dispatchListenerList != null) {
            this.dispatchListenerList.remove(listener);
        }
    }

    protected synchronized void fireOmniDriverDispatchListener(ErrorCode errorCode, int error) {
        if (this.dispatchListenerList != null) {
            for (int i = 0; i < this.dispatchListenerList.size(); ++i) {
                ((OmniDriverDispatchListener)this.dispatchListenerList.get(i)).dispatchError(errorCode, error);
            }
        }
    }

    public void addAcquisitionPropertiesListener(AcquisitionPropertiesListener listener) {
        if (this.acquisitionPropertiesListenerList == null) {
            this.acquisitionPropertiesListenerList = new ArrayList();
        }
        this.acquisitionPropertiesListenerList.add(listener);
    }

    public void removeAcquisitionPropertiesListener(AcquisitionPropertiesListener listener) {
        if (this.acquisitionPropertiesListenerList != null) {
            this.acquisitionPropertiesListenerList.remove(listener);
        }
    }

    public synchronized void fireAcquisitionPropertiesListener() {
        if (this.acquisitionPropertiesListenerList != null) {
            for (int i = 0; i < this.acquisitionPropertiesListenerList.size(); ++i) {
                ((AcquisitionPropertiesListener)this.acquisitionPropertiesListenerList.get(i)).acquisitionPropertiesChange();
            }
        }
    }
}

