/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.errorprovider;

import com.oceanoptics.omnidriver.constants.ErrorCode;
import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.errorprovider.GatingErrorProvider;
import com.oceanoptics.omnidriver.interfaces.OmniDriverDispatchListener;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import java.util.ArrayList;

public class GatingErrorProviderImpl
extends USBFeature {
    private Spectrometer spectrometer;
    private int gatingModeIntegrationTime;
    private ErrorCode errorCode;
    private int lastIntegrationTime = -1;
    private boolean ignore;
    protected transient ArrayList dispatchListenerList;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\ncheckIntegrationTime,(I)V\ncheckTriggerNotification,(I)V\nisInGatedMode,()Z\naddOmniDriverDispatchListener,(Lcom/oceanoptics/omnidriver/interfaces/OmniDriverDispatchListener;)V\nremoveOmniDriverDispatchListener,(Lcom/oceanoptics/omnidriver/interfaces/OmniDriverDispatchListener;)V\n";

    public GatingErrorProviderImpl(USBInterface usbInt, Spectrometer spectrometer) {
        super(usbInt);
        this.spectrometer = spectrometer;
        this.gatingModeIntegrationTime = ((GatingErrorProvider)((Object)spectrometer)).getGatingModeIntegrationTime();
    }

    public void checkIntegrationTime(int intTime) {
        if (intTime < this.gatingModeIntegrationTime) {
            if (this.errorCode != null) {
                this.errorCode.setErrorCode(4, true);
            } else {
                this.errorCode = new ErrorCode(4);
            }
            if (!this.errorCode.isCodeIgnored(4) || intTime != this.lastIntegrationTime && !this.ignore) {
                this.fireOmniDriverDispatchListener(this.errorCode, 4);
                this.ignore = true;
            }
        } else {
            this.ignore = false;
        }
        this.lastIntegrationTime = intTime;
    }

    public void checkTriggerNotification(int mode) {
        if (mode == 2 || mode == 3) {
            if (this.errorCode != null) {
                this.errorCode.setErrorCode(8, true);
            } else {
                this.errorCode = new ErrorCode(8);
            }
            if (!this.errorCode.isCodeIgnored(8)) {
                this.fireOmniDriverDispatchListener(this.errorCode, 8);
            }
        }
    }

    public boolean isInGatedMode() {
        return this.spectrometer.getActualIntegrationTime() < this.gatingModeIntegrationTime;
    }

    public void addOmniDriverDispatchListener(OmniDriverDispatchListener listener) {
        if (this.dispatchListenerList == null) {
            this.dispatchListenerList = new ArrayList();
        }
        this.dispatchListenerList.add(listener);
    }

    public void removeOmniDriverDispatchListener(OmniDriverDispatchListener listener) {
        if (this.dispatchListenerList != null) {
            this.dispatchListenerList.remove(listener);
        }
    }

    protected synchronized void fireOmniDriverDispatchListener(ErrorCode errorCode, int error) {
        if (this.dispatchListenerList != null) {
            for (int i = 0; i < this.dispatchListenerList.size(); ++i) {
                ((OmniDriverDispatchListener)this.dispatchListenerList.get(i)).dispatchError(errorCode, error);
            }
        }
    }
}

