/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.externaltriggerdelay;

import com.oceanoptics.omnidriver.features.externaltriggerdelay.ExternalTriggerDelayImpl;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.sts.STS;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class ExternalTriggerDelayImpl_STS
extends ExternalTriggerDelayImpl {
    private static final int DELAY_MAX_USEC = 335500;
    private static final int DELAY_MIN_USEC = 0;
    private static final int DELAY_INCREMENT_USEC = 1;
    private static final float USEC_PER_COUNT = 1.0f;
    protected STS spectrometer;
    private Integer triggerDelay = null;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/spectrometer/sts/STS;Lcom/oceanoptics/omnidriver/interfaces/USBInterface;)V\nsetExternalTriggerDelay,(I)V\ngetExternalTriggerDelay,()Ljava/lang/Integer;\ntriggerDelayCountsToMicroseconds,(I)D\ngetExternalTriggerDelayMinimum,()I\ngetExternalTriggerDelayMaximum,()I\ngetExternalTriggerDelayIncrement,()I\n";

    public ExternalTriggerDelayImpl_STS(STS sts, USBInterface usbInt) {
        super(usbInt);
        this.spectrometer = sts;
    }

    public void setExternalTriggerDelay(int counts) throws IOException {
        byte[] data = new byte[]{ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)counts)), ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)counts)), ByteRoutines.getLowByte((short)ByteRoutines.getHighWord((int)counts)), ByteRoutines.getHighByte((short)ByteRoutines.getHighWord((int)counts))};
        boolean success = this.spectrometer.sendCommandToDevice(0x110510, data);
        if (!success) {
            throw new IOException("Failed to set external trigger delay.");
        }
    }

    public Integer getExternalTriggerDelay() {
        return this.triggerDelay;
    }

    public double triggerDelayCountsToMicroseconds(int counts) {
        return (float)counts / 1.0f;
    }

    public int getExternalTriggerDelayMinimum() {
        return 0;
    }

    public int getExternalTriggerDelayMaximum() {
        return 335500;
    }

    public int getExternalTriggerDelayIncrement() {
        return 1;
    }
}

