/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.flgated;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.flgated.FlGatedGUIProvider;
import com.oceanoptics.omnidriver.features.flgated.GateDelayListener;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.usb2000.USB2000;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.util.ArrayList;

public class FlGatedImpl
extends USBFeature
implements FlGatedGUIProvider {
    protected String featurePath = "flgated.FlGatedPanel";
    private final int GATE_MIN = 3;
    private final int GATE_MAX = 511;
    private final int GATE_STEP = 1;
    USB2000 spectrometer;
    private transient ArrayList gateDelayListenerList;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/usb2000/USB2000;)V\ngetGateIncrement,()I\ngetGateMaximum,()I\ngetGateMinimum,()I\nsetGateFrequency,(I)V\ngetGateFrequency,()I\naddGateDelayListener,(Lcom/oceanoptics/omnidriver/features/flgated/GateDelayListener;)V\nremoveGateDelayListener,(Lcom/oceanoptics/omnidriver/features/flgated/GateDelayListener;)V\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public FlGatedImpl(USBInterface usbInt, USB2000 spectrometer) throws IOException {
        super(usbInt);
        this.spectrometer = spectrometer;
    }

    public int getGateIncrement() {
        return 1;
    }

    public int getGateMaximum() {
        return 511;
    }

    public int getGateMinimum() {
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGateFrequency(int freq) throws IOException {
        byte[] byArray = this.out;
        synchronized (this.out) {
            if (freq < 5) {
                freq = 5;
            }
            if (freq > 514) {
                freq = 514;
            }
            System.out.println("Setting Gate Delay to: " + freq);
            this.out[0] = 14;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)freq));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)freq));
            this.usb.bulkOut(this.spectrometer.getEndpoint(0), this.out, 3);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireGateDelayListener(freq);
            return;
        }
    }

    public int getGateFrequency() {
        return this.spectrometer.getGateFrequency();
    }

    public synchronized void addGateDelayListener(GateDelayListener listener) {
        if (this.gateDelayListenerList == null) {
            this.gateDelayListenerList = new ArrayList();
        }
        this.gateDelayListenerList.add(listener);
    }

    public synchronized void removeGateDelayListener(GateDelayListener listener) {
        if (this.gateDelayListenerList != null) {
            this.gateDelayListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireGateDelayListener(int event) {
        ArrayList list;
        FlGatedImpl flGatedImpl = this;
        synchronized (flGatedImpl) {
            if (this.gateDelayListenerList == null) {
                return;
            }
            list = (ArrayList)this.gateDelayListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((GateDelayListener)list.get(i)).gateDelayValueChanged(event);
        }
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

