/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.gpio;

import com.oceanoptics.omnidriver.features.gpio.GPIOGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;
import java.net.Socket;
import java.util.BitSet;

public abstract class GPIOImpl_Jaz
implements GPIOGUIProvider {
    protected String featurePath = "gpio.GPIOPanel";
    protected String panelPath = "com.oceanoptics.omnidriver.guisupport.features";
    private static final int NUMBER_GPIO_PINS = 4;
    private static final byte GPIO_MUX_REGISTER = 104;
    private static final byte GPIO_OUTPUT_ENABLE_REGISTER = 105;
    private static final byte GPIO_DATA_REGISTER = 106;
    protected byte[] in;
    protected byte[] out;
    protected short bitmask = 0;
    private static String __extern__ = "__extern__\ngetTotalGPIOBits,()I\ngetNumberOfPins,()I\ngetFeatureGUIClassnames,()[Ljava/lang/String;\ngetValueBits,()Ljava/util/BitSet;\ngetValueBit,(I)I\nsetValueAllBits,(Ljava/util/BitSet;)V\nsetValueBitmask,(S)V\nsetValueBit,(IZ)V\ngetDirectionBits,()Ljava/util/BitSet;\nsetDirectionAllBits,(Ljava/util/BitSet;)V\nsetDirectionBitmask,(S)V\nsetDirectionBit,(IZ)V\ngetMuxBits,()Ljava/util/BitSet;\nsetMuxAllBits,(Ljava/util/BitSet;)V\nsetMuxBitmask,(S)V\nsetMuxBit,(IZ)V\n";

    protected GPIOImpl_Jaz() {
        for (int i = 0; i < 4; ++i) {
            this.bitmask = (short)(this.bitmask | 1 << i);
        }
    }

    protected short formatGPIO(short gpio) {
        gpio = (short)(gpio >> 2);
        return (short)(gpio & this.bitmask);
    }

    private static BitSet createBitSet(short bits, int length) {
        BitSet bs = new BitSet(length);
        for (int i = 0; i < length; ++i) {
            bs.set(i, (bits & 1 << i) > 0);
        }
        return bs;
    }

    private static short bitSetToShort(BitSet bs) {
        short retval = 0;
        if (bs.size() > 16) {
            throw new IllegalArgumentException("BitSet too large for 16 bit field (" + bs.size() + " > 16)");
        }
        for (int i = 0; i < bs.size(); ++i) {
            if (!bs.get(i)) continue;
            retval = (short)(retval | 1 << i);
        }
        return retval;
    }

    public int getTotalGPIOBits() {
        return 4;
    }

    public int getNumberOfPins() {
        return 4;
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }

    protected abstract void writeGPIORegister(byte var1, short var2) throws IOException;

    protected abstract short readGPIORegister(byte var1) throws IOException;

    public BitSet getValueBits() throws IOException {
        short bits = this.readGPIORegister((byte)106);
        return GPIOImpl_Jaz.createBitSet(bits, 4);
    }

    private void writeBits(byte dest, short value) throws IOException {
        if (value > 15 || value < 0) {
            throw new IllegalArgumentException("GPIO register must be between 0-15");
        }
        this.writeGPIORegister(dest, this.formatGPIO(value));
    }

    private void writeBit(int bit, boolean value, byte register) throws IOException {
        short vector = this.readGPIORegister(register);
        vector = false == value ? (short)(vector & ~(1 << bit)) : (short)(vector | 1 << bit);
        this.writeGPIORegister(register, vector);
    }

    public int getValueBit(int bitNumber) throws IOException {
        BitSet bitset = this.getValueBits();
        return bitset.get(bitNumber) ? 1 : 0;
    }

    public void setValueAllBits(BitSet bitSet) throws IOException {
        short value = GPIOImpl_Jaz.bitSetToShort(bitSet);
        this.writeBits((byte)106, this.formatGPIO(value));
    }

    public void setValueBitmask(short value) throws IOException {
        this.writeBits((byte)106, this.formatGPIO(value));
    }

    public void setValueBit(int bit, boolean value) throws IOException {
        this.writeBit(bit, value, (byte)106);
    }

    public BitSet getDirectionBits() throws IOException {
        short bits = this.readGPIORegister((byte)105);
        return GPIOImpl_Jaz.createBitSet(bits, 4);
    }

    public void setDirectionAllBits(BitSet bitSet) throws IOException {
        short value = GPIOImpl_Jaz.bitSetToShort(bitSet);
        this.writeBits((byte)105, this.formatGPIO(value));
    }

    public void setDirectionBitmask(short value) throws IOException {
        this.writeBits((byte)105, this.formatGPIO(value));
    }

    public void setDirectionBit(int bit, boolean value) throws IOException {
        this.writeBit(bit, value, (byte)105);
    }

    public BitSet getMuxBits() throws IOException {
        short bits = this.readGPIORegister((byte)104);
        return GPIOImpl_Jaz.createBitSet(bits, 4);
    }

    public void setMuxAllBits(BitSet bitSet) throws IOException {
        short value = GPIOImpl_Jaz.bitSetToShort(bitSet);
        this.writeBits((byte)104, this.formatGPIO(value));
    }

    public void setMuxBitmask(short value) throws IOException {
        this.writeBits((byte)104, this.formatGPIO(value));
    }

    public void setMuxBit(int bit, boolean value) throws IOException {
        this.writeBit(bit, value, (byte)104);
    }

    public static class Network
    extends GPIOImpl_Jaz {
        private Socket socket;

        public Network(Socket sock, byte[] inputBuffer, byte[] outputBuffer) {
            this.socket = sock;
            this.in = inputBuffer;
            this.out = outputBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeGPIORegister(byte addr, short word) throws IOException {
            byte[] byArray = this.out;
            synchronized (this.out) {
                for (int i = 0; i < 20; ++i) {
                    this.out[i] = 0;
                }
                word = (short)(word << 2);
                this.out[0] = -57;
                this.out[1] = addr;
                this.out[2] = ByteRoutines.getHighByte((short)word);
                this.out[3] = ByteRoutines.getLowByte((short)word);
                this.socket.getOutputStream().write(this.out, 0, 17);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected short readGPIORegister(byte addr) throws IOException {
            byte[] byArray = this.in;
            synchronized (this.in) {
                byte[] byArray2 = this.out;
                synchronized (this.out) {
                    for (int i = 0; i < 20; ++i) {
                        this.out[i] = 0;
                    }
                    this.out[0] = -58;
                    this.out[1] = addr;
                    this.socket.getOutputStream().write(this.out, 0, 2);
                    this.socket.getInputStream().read(this.in, 0, 17);
                    short word = ByteRoutines.makeWord((byte)this.in[2], (byte)this.in[3]);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.formatGPIO(word);
                }
            }
        }
    }

    public static class USB
    extends GPIOImpl_Jaz {
        private USBInterface usb;
        private static final short DATA_OUT = 1;
        private static final short LOW_SPEED_DATA_IN = 129;
        private static final short MAX_PACKET_SIZE = 512;
        private USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 1, 2, 512, 0);
        private USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 512, 0);

        public USB(USBInterface usbInt) {
            this.usb = usbInt;
            this.in = this.usb.getInputBuffer();
            this.out = this.usb.getOutputBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeGPIORegister(byte addr, short word) throws IOException {
            byte[] byArray = this.out;
            synchronized (this.out) {
                for (int i = 0; i < 20; ++i) {
                    this.out[i] = 0;
                }
                word = (short)(word << 2);
                this.out[0] = -57;
                this.out[1] = addr;
                this.out[2] = ByteRoutines.getHighByte((short)word);
                this.out[3] = ByteRoutines.getLowByte((short)word);
                this.usb.bulkOut(this.dataOutEndPoint, this.out, 17);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected short readGPIORegister(byte addr) throws IOException {
            byte[] byArray = this.in;
            synchronized (this.in) {
                byte[] byArray2 = this.out;
                synchronized (this.out) {
                    for (int i = 0; i < 20; ++i) {
                        this.out[i] = 0;
                    }
                    this.out[0] = -58;
                    this.out[1] = addr;
                    this.usb.bulkOut(this.dataOutEndPoint, this.out, 2);
                    this.usb.bulkIn(this.lowSpeedInEndPoint, this.in, 17);
                    short word = ByteRoutines.makeWord((byte)this.in[2], (byte)this.in[3]);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.formatGPIO(word);
                }
            }
        }
    }
}

