/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.highgainmode;

import com.oceanoptics.omnidriver.features.USBFeature;
import com.oceanoptics.omnidriver.features.highgainmode.HighGainModeGUIProvider;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.Spectrometer;
import com.oceanoptics.omnidriver.spectrometer.nirquest.NIRQuest;
import com.oceanoptics.omnidriver.spectrometer.s8378Prototype.S8378;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import com.oceanoptics.utilities.ByteRoutines;
import java.io.IOException;

public class HighGainModeImpl
extends USBFeature
implements HighGainModeGUIProvider {
    private static final short DATA_OUT = 2;
    private static final short LOW_SPEED_DATA_IN = 135;
    private static final short MAX_PACKET_SIZE = 64;
    public USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 2, 2, 64, 0);
    public USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 135, 2, 64, 0);
    protected String featurePath = "highgainmode.HighGainModePanel";
    protected Spectrometer spec;
    private static String __extern__ = "__extern__\n<init>,(Lcom/oceanoptics/omnidriver/interfaces/USBInterface;Lcom/oceanoptics/omnidriver/spectrometer/Spectrometer;)V\nsetHighGain,(Z)V\nsetHighGainDefault,(Z)V\ngetHighGainDefault,()Z\nhasHighGainDefault,()Z\ngetFeatureGUIClassnames,()[Ljava/lang/String;\n";

    public HighGainModeImpl(USBInterface usb, Spectrometer spec) {
        super(usb);
        this.spec = spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHighGain(boolean gain) throws IOException {
        if (this.spec instanceof S8378) {
            ((S8378)this.spec).setHighGain(gain);
        }
        if (this.spec instanceof NIRQuest) {
            ((NIRQuest)this.spec).setHighGain(gain);
            return;
        }
        byte[] byArray = this.out;
        synchronized (this.out) {
            int byteOn = gain ? 1 : 0;
            this.out[0] = 12;
            this.out[1] = ByteRoutines.getLowByte((short)ByteRoutines.getLowWord((int)byteOn));
            this.out[2] = ByteRoutines.getHighByte((short)ByteRoutines.getLowWord((int)byteOn));
            this.usb.bulkOut(this.dataOutEndPoint, this.out, 3);
            this.logger.fine("InGaAs detector gain mode set to (0:Low, 1:High): " + byteOn);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setHighGainDefault(boolean gain) throws IOException {
        if (this.spec instanceof S8378) {
            return;
        }
        if (gain) {
            this.spec.setInfo(17, "enabled");
        } else {
            this.spec.setInfo(17, "disabled");
        }
    }

    public boolean getHighGainDefault() throws IOException {
        if (this.spec instanceof S8378) {
            return false;
        }
        String result = this.spec.getInfo(17);
        if (result.equals("enabled")) {
            return true;
        }
        if (result.equals("disabled")) {
            return false;
        }
        System.out.println("No Default value for High Gain Mode enable found, defaulting to 'disabled'.");
        return false;
    }

    public boolean hasHighGainDefault() {
        return !(this.spec instanceof S8378);
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{this.panelPath + "." + this.featurePath};
    }
}

