/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.indy;

import com.oceanoptics.omnidriver.spectrometer.jaz.DispatchProtocolMessage;
import com.oceanoptics.utilities.ByteRoutines;

public class Indy420TxSetCalibration
extends DispatchProtocolMessage {
    private static String __extern__ = "__extern__\n<init>,()V\ngetModuleIndex,()I\ngetCountsAt4mA,()I\ngetCountsAt20mA,()I\nsetModuleIndex,(I)V\nsetCountsAt4mA,(I)V\nsetCountsAt20mA,(I)V\n";

    public Indy420TxSetCalibration() {
        this.setPayload(new byte[40]);
        this.setMessageType(5060L);
    }

    public int getModuleIndex() {
        return this.payload[0];
    }

    public int getCountsAt4mA() {
        short retval = ByteRoutines.makeWord((byte)this.payload[5], (byte)this.payload[4]);
        return retval;
    }

    public int getCountsAt20mA() {
        short retval = ByteRoutines.makeWord((byte)this.payload[7], (byte)this.payload[6]);
        return retval;
    }

    public void setModuleIndex(int moduleIndex) {
        this.payload[0] = (byte)moduleIndex;
    }

    public void setCountsAt4mA(int counts) {
        this.payload[4] = (byte)(counts & 0xFF);
        this.payload[5] = (byte)(counts >> 8 & 0xFF);
    }

    public void setCountsAt20mA(int counts) {
        this.payload[6] = (byte)(counts & 0xFF);
        this.payload[7] = (byte)(counts >> 8 & 0xFF);
    }
}

