/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.indy;

import com.oceanoptics.omnidriver.features.indy.Indy420TxCalResponse;
import com.oceanoptics.omnidriver.features.indy.Indy420TxSetCalibration;
import com.oceanoptics.omnidriver.features.indy.Indy420TxSetEnable;
import com.oceanoptics.omnidriver.features.indy.Indy420TxStatusResponse;
import com.oceanoptics.omnidriver.features.indy.IndyCurrentSample;
import com.oceanoptics.omnidriver.features.indy.IndyExcitationSetEnable;
import com.oceanoptics.omnidriver.features.indy.IndyExcitationSetVoltage;
import com.oceanoptics.omnidriver.features.indy.IndyExcitationStatusResponse;
import com.oceanoptics.omnidriver.features.indy.IndyFixedInfoResponse;
import com.oceanoptics.omnidriver.features.indy.IndyGPIOSetConfigRequest;
import com.oceanoptics.omnidriver.features.indy.IndyGPIOSetValueRequest;
import com.oceanoptics.omnidriver.features.indy.IndyGPIOStatusResponse;
import com.oceanoptics.omnidriver.features.indy.IndyGUIProvider;
import com.oceanoptics.omnidriver.features.indy.IndyGetVOutResponse;
import com.oceanoptics.omnidriver.features.indy.IndyModuleCountResponse;
import com.oceanoptics.omnidriver.features.indy.IndySample420Response;
import com.oceanoptics.omnidriver.features.indy.IndySampleVResponse;
import com.oceanoptics.omnidriver.features.indy.IndySet420TxCountsRequest;
import com.oceanoptics.omnidriver.features.indy.IndySet420TxMilliampsRequest;
import com.oceanoptics.omnidriver.features.indy.IndySetVOutCountsRequest;
import com.oceanoptics.omnidriver.features.indy.IndySetVOutVoltsRequest;
import com.oceanoptics.omnidriver.features.indy.IndyVoltageSample;
import com.oceanoptics.omnidriver.interfaces.USBInterface;
import com.oceanoptics.omnidriver.spectrometer.jaz.DispatchProtocolMessage;
import com.oceanoptics.uniusb.USBEndpointDescriptor;
import java.io.IOException;
import java.net.Socket;

public abstract class IndyImpl
implements IndyGUIProvider {
    protected IndyFixedInfo[] indyModules = new IndyFixedInfo[0];
    private static final int MAX_V_DAC_COUNTS = 65535;
    private static final int MAX_420_DAC_COUNTS = 10000;
    protected final byte[] in;
    protected final byte[] out;
    private static String __extern__ = "__extern__\ngetCurrentOutputCalibration4mA,(II)I\ngetCurrentOutputCalibration20mA,(II)I\ngetCurrentOutputEnables,(I)[Z\ngetCurrentOutputEnergized,(I)[Z\ngetCurrentOutputMaximumCounts,(II)I\ngetCurrentOutputs,(I)[Lcom/oceanoptics/omnidriver/features/indy/IndyCurrentSample;\ngetExcitationEnable,(II)Z\ngetExcitationVoltage,(II)F\ngetExcitationVoltageOptions,(II)[F\ngetFeatureGUIClassnames,()[Ljava/lang/String;\ngetIndyGPIOInputValues,(I)I\ngetIndyGPIOOutputValues,(I)I\ngetIndyGPIOOutputEnables,(I)I\ngetNumberOfCurrentInputs,(I)I\ngetNumberOfCurrentOutputs,(I)I\ngetNumberOfIndyGPIO,(I)I\ngetNumberOfIndyModules,()I\ngetNumberOfVoltageInputs,(I)I\ngetNumberOfVoltageOutputs,(I)I\ngetVoltageOutputMaximumCounts,(II)I\ngetVoltageOutputs,(I)[Lcom/oceanoptics/omnidriver/features/indy/IndyVoltageSample;\nsampleCurrentInputs,(I)[Lcom/oceanoptics/omnidriver/features/indy/IndyCurrentSample;\nsampleVoltageInputs,(I)[Lcom/oceanoptics/omnidriver/features/indy/IndyVoltageSample;\nsetCurrentOutputCalibration4mA,(III)V\nsetCurrentOutputCalibration20mA,(III)V\nsetCurrentOutputCounts,(III)V\nsetCurrentOutputEnable,(IIZ)V\nsetCurrentOutputMilliamps,(IIF)V\nsetExcitationEnable,(IIZ)V\nsetExcitationVoltage,(IIF)V\nsetIndyGPIOConfiguration,(IIII)V\nsetIndyGPIOOutputValues,(III)V\nsetVoltageOutputCounts,(III)V\nsetVoltageOutputVolts,(IIF)V\n";

    IndyImpl(byte[] input, byte[] output, Object context) {
        this.in = input;
        this.out = output;
        this.setContext(context);
        try {
            this.getModuleInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.indyModules = new IndyFixedInfo[0];
        }
    }

    protected abstract void sendMessage(byte[] var1) throws IOException;

    protected abstract byte[] getMessage(int var1) throws IOException;

    protected abstract void setContext(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getModuleInfo() throws IOException {
        DispatchProtocolMessage request = new DispatchProtocolMessage();
        request.setTo(5000L);
        request.setMessageType(5000L);
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] data;
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.sendMessage(request.toByteStream());
                data = this.getMessage(68);
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
            {
                try {
                    IndyModuleCountResponse response = new IndyModuleCountResponse(data);
                    this.indyModules = new IndyFixedInfo[response.getNumberOfModules()];
                }
                catch (IllegalArgumentException iae) {
                    this.indyModules = new IndyFixedInfo[0];
                    iae.printStackTrace();
                }
                for (int i = 0; i < this.indyModules.length; ++i) {
                    this.indyModules[i] = this.getFixedInfo(i);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndyFixedInfo getFixedInfo(int moduleIndex) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        DispatchProtocolMessage request = new DispatchProtocolMessage();
        request.setTo(5000L);
        request.setMessageType(5001L);
        byte[] payload = new byte[36];
        payload[0] = (byte)moduleIndex;
        request.setPayload(payload);
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] data;
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.sendMessage(request.toByteStream());
                data = this.getMessage(88);
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
            {
                IndyFixedInfoResponse response = new IndyFixedInfoResponse(data);
                IndyFixedInfo retval = new IndyFixedInfo(response.getModuleIndex(), response.getNumberOfGPIO(), response.getNumberOfVoltageIn(), response.getNumberOfVoltageOut(), response.getNumberOfCurrentIn(), response.getNumberOfCurrentOut(), new String(response.getSerialNumber(), "US-ASCII"));
                return retval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Indy420Calibration get420Calibration(int moduleIndex, int channel) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        DispatchProtocolMessage request = new DispatchProtocolMessage();
        request.setTo(5000L);
        request.setMessageType(5061L);
        byte[] payload = new byte[36];
        payload[0] = (byte)moduleIndex;
        request.setPayload(payload);
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] data;
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.sendMessage(request.toByteStream());
                data = this.getMessage(72);
                // ** MonitorExit[var7_6] (shouldn't be in output)
            }
            {
                Indy420TxCalResponse response = new Indy420TxCalResponse(data);
                Indy420Calibration retval = new Indy420Calibration(response.getCountsAt4mA(), response.getCountsAt20mA());
                return retval;
            }
        }
    }

    public int getCurrentOutputCalibration4mA(int moduleIndex, int channel) throws IOException {
        Indy420Calibration cal = this.get420Calibration(moduleIndex, channel);
        return cal.getCountsAt4mA();
    }

    public int getCurrentOutputCalibration20mA(int moduleIndex, int channel) throws IOException {
        Indy420Calibration cal = this.get420Calibration(moduleIndex, channel);
        return cal.getCountsAt20mA();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Indy420TxStatus get420TxStatus(int moduleIndex) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        DispatchProtocolMessage request = new DispatchProtocolMessage();
        request.setTo(5000L);
        request.setMessageType(5032L);
        byte[] payload = new byte[36];
        payload[0] = (byte)moduleIndex;
        request.setPayload(payload);
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] data;
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.sendMessage(request.toByteStream());
                data = this.getMessage(76);
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
            {
                Indy420TxStatusResponse response = new Indy420TxStatusResponse(data);
                Indy420TxStatus status = new Indy420TxStatus(response.getModuleIndex(), response.isEnergized(), response.getCounts(), response.getMilliamps(), response.isEnabled());
                return status;
            }
        }
    }

    public boolean[] getCurrentOutputEnables(int moduleIndex) throws IOException {
        Indy420TxStatus status = this.get420TxStatus(moduleIndex);
        boolean[] retval = new boolean[]{status.isEnabled()};
        return retval;
    }

    public boolean[] getCurrentOutputEnergized(int moduleIndex) throws IOException {
        Indy420TxStatus status = this.get420TxStatus(moduleIndex);
        boolean[] retval = new boolean[]{status.isEnergized()};
        return retval;
    }

    public int getCurrentOutputMaximumCounts(int moduleIndex, int channel) {
        return 10000;
    }

    public IndyCurrentSample[] getCurrentOutputs(int moduleIndex) throws IOException {
        Indy420TxStatus status = this.get420TxStatus(moduleIndex);
        IndyCurrentSample[] retval = new IndyCurrentSample[]{new IndyCurrentSample(0, status.getCounts(), status.getMilliamps())};
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndyExcitationStatus getExcitationStatus(int moduleIndex) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        DispatchProtocolMessage request = new DispatchProtocolMessage();
        request.setTo(5000L);
        request.setMessageType(5041L);
        byte[] payload = new byte[36];
        payload[0] = (byte)moduleIndex;
        request.setPayload(payload);
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] data;
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.sendMessage(request.toByteStream());
                data = this.getMessage(68);
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
            {
                IndyExcitationStatusResponse response = new IndyExcitationStatusResponse(data);
                IndyExcitationStatus retval = new IndyExcitationStatus(response.isEnabled(), response.getVoltage());
                return retval;
            }
        }
    }

    public boolean getExcitationEnable(int moduleIndex, int channel) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        IndyExcitationStatus status = this.getExcitationStatus(moduleIndex);
        return status.isEnabled();
    }

    public float getExcitationVoltage(int moduleIndex, int channel) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        IndyExcitationStatus status = this.getExcitationStatus(moduleIndex);
        return status.getVoltage();
    }

    public float[] getExcitationVoltageOptions(int moduleIndex, int channel) {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        return new float[]{10.0f, 20.0f};
    }

    public String[] getFeatureGUIClassnames() {
        return new String[]{"com.oceanoptics.omnidriver.guisupport.features.indy.IndyPanel"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndyGPIOStatus getGPIOStatus(int moduleIndex) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        DispatchProtocolMessage request = new DispatchProtocolMessage();
        request.setTo(5000L);
        request.setMessageType(5010L);
        byte[] payload = new byte[36];
        payload[0] = (byte)moduleIndex;
        request.setPayload(payload);
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] data;
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.sendMessage(request.toByteStream());
                data = this.getMessage(88);
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
            {
                IndyGPIOStatusResponse response = new IndyGPIOStatusResponse(data);
                IndyGPIOStatus retval = new IndyGPIOStatus(response.getInputValueVector(), response.getOutputValueVector(), response.getOutputEnableVector());
                return retval;
            }
        }
    }

    public int getIndyGPIOInputValues(int moduleIndex) throws IOException {
        IndyGPIOStatus status = this.getGPIOStatus(moduleIndex);
        return status.getInputValueVector();
    }

    public int getIndyGPIOOutputValues(int moduleIndex) throws IOException {
        IndyGPIOStatus status = this.getGPIOStatus(moduleIndex);
        return status.getOutputValueVector();
    }

    public int getIndyGPIOOutputEnables(int moduleIndex) throws IOException {
        IndyGPIOStatus status = this.getGPIOStatus(moduleIndex);
        return status.getOutputEnableVector();
    }

    public int getNumberOfCurrentInputs(int moduleIndex) {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        return this.indyModules[moduleIndex].getNumberOfAnalogCurrentIn();
    }

    public int getNumberOfCurrentOutputs(int moduleIndex) {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        return this.indyModules[moduleIndex].getNumberOfAnalogCurrentOut();
    }

    public int getNumberOfIndyGPIO(int moduleIndex) {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        return this.indyModules[moduleIndex].getNumberOfGPIO();
    }

    public int getNumberOfIndyModules() {
        return this.indyModules.length;
    }

    public int getNumberOfVoltageInputs(int moduleIndex) {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        return this.indyModules[moduleIndex].getNumberOfAnalogVIn();
    }

    public int getNumberOfVoltageOutputs(int moduleIndex) {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        return this.indyModules[moduleIndex].getNumberOfAnalogVOut();
    }

    public int getVoltageOutputMaximumCounts(int moduleIndex, int channel) {
        return 65535;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndyVoltageSample[] getVoltageOutputs(int moduleIndex) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        DispatchProtocolMessage request = new DispatchProtocolMessage();
        request.setTo(5000L);
        request.setMessageType(5023L);
        byte[] payload = new byte[36];
        payload[0] = (byte)moduleIndex;
        request.setPayload(payload);
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] data;
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.sendMessage(request.toByteStream());
                data = this.getMessage(100);
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
            {
                IndyGetVOutResponse response = new IndyGetVOutResponse(data);
                IndyVoltageSample[] outputs = response.getOutputs();
                return outputs;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndyCurrentSample[] sampleCurrentInputs(int moduleIndex) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        DispatchProtocolMessage request = new DispatchProtocolMessage();
        request.setTo(5000L);
        request.setMessageType(5040L);
        byte[] payload = new byte[36];
        payload[0] = (byte)moduleIndex;
        request.setPayload(payload);
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] data;
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.sendMessage(request.toByteStream());
                data = this.getMessage(80);
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
            {
                IndySample420Response response = new IndySample420Response(data);
                return response.getSamples();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndyVoltageSample[] sampleVoltageInputs(int moduleIndex) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        DispatchProtocolMessage request = new DispatchProtocolMessage();
        request.setTo(5000L);
        request.setMessageType(5020L);
        byte[] payload = new byte[36];
        payload[0] = (byte)moduleIndex;
        request.setPayload(payload);
        byte[] byArray = this.in;
        synchronized (this.in) {
            byte[] data;
            byte[] byArray2 = this.out;
            synchronized (this.out) {
                this.sendMessage(request.toByteStream());
                data = this.getMessage(164);
                // ** MonitorExit[var6_5] (shouldn't be in output)
            }
            {
                IndySampleVResponse response = new IndySampleVResponse(data);
                IndyVoltageSample[] samples = response.getSamples();
                return samples;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentOutputCalibration4mA(int moduleIndex, int channel, int counts) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        if (channel < 0 || channel >= this.getNumberOfCurrentOutputs(moduleIndex)) {
            throw new IllegalArgumentException("Invalid channel " + channel);
        }
        if (counts < 0 || counts > this.getCurrentOutputMaximumCounts(moduleIndex, channel)) {
            throw new IllegalArgumentException("Counts out of bounds at " + counts);
        }
        int counts20mA = this.getCurrentOutputCalibration20mA(moduleIndex, channel);
        if (counts20mA <= counts) {
            throw new IllegalArgumentException("20mA setpoint must be higher than for 4mA.");
        }
        Indy420TxSetCalibration request = new Indy420TxSetCalibration();
        request.setTo(5000L);
        request.setModuleIndex(moduleIndex);
        request.setCountsAt4mA(counts);
        request.setCountsAt20mA(counts20mA);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.sendMessage(request.toByteStream());
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentOutputCalibration20mA(int moduleIndex, int channel, int counts) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        if (channel < 0 || channel >= this.getNumberOfCurrentOutputs(moduleIndex)) {
            throw new IllegalArgumentException("Invalid channel " + channel);
        }
        if (counts < 0 || counts > this.getCurrentOutputMaximumCounts(moduleIndex, channel)) {
            throw new IllegalArgumentException("Counts out of bounds at " + counts);
        }
        int counts4mA = this.getCurrentOutputCalibration4mA(moduleIndex, channel);
        if (counts4mA >= counts) {
            throw new IllegalArgumentException("4mA setpoint must be less than that for 20mA.");
        }
        Indy420TxSetCalibration request = new Indy420TxSetCalibration();
        request.setTo(5000L);
        request.setModuleIndex(moduleIndex);
        request.setCountsAt4mA(counts4mA);
        request.setCountsAt20mA(counts);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.sendMessage(request.toByteStream());
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentOutputCounts(int moduleIndex, int channel, int counts) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        if (counts < 0 || counts > this.getCurrentOutputMaximumCounts(moduleIndex, channel)) {
            throw new IllegalArgumentException("Counts out of bounds at " + counts);
        }
        IndySet420TxCountsRequest request = new IndySet420TxCountsRequest();
        request.setTo(5000L);
        request.setModuleIndex(moduleIndex);
        request.setCounts(counts);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.sendMessage(request.toByteStream());
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentOutputEnable(int moduleIndex, int channel, boolean enabled) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        Indy420TxSetEnable request = new Indy420TxSetEnable();
        request.setTo(5000L);
        request.setModuleIndex(moduleIndex);
        request.setEnabled(enabled);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.sendMessage(request.toByteStream());
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentOutputMilliamps(int moduleIndex, int channel, float milliamps) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        if (milliamps < 4.0f || milliamps > 20.0f) {
            throw new IllegalArgumentException("Invalid current value " + milliamps);
        }
        IndySet420TxMilliampsRequest request = new IndySet420TxMilliampsRequest();
        request.setTo(5000L);
        request.setModuleIndex(moduleIndex);
        request.setMilliamps(milliamps);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.sendMessage(request.toByteStream());
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExcitationEnable(int moduleIndex, int channel, boolean enabled) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        IndyExcitationSetEnable request = new IndyExcitationSetEnable();
        request.setTo(5000L);
        request.setModuleIndex(moduleIndex);
        request.setEnabled(enabled);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.sendMessage(request.toByteStream());
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExcitationVoltage(int moduleIndex, int channel, float volts) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        IndyExcitationSetVoltage request = new IndyExcitationSetVoltage();
        request.setTo(5000L);
        request.setModuleIndex(moduleIndex);
        request.setVoltage(volts);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.sendMessage(request.toByteStream());
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndyGPIOConfiguration(int moduleIndex, int outputValueVector, int enableVector, int mask) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        IndyGPIOSetConfigRequest request = new IndyGPIOSetConfigRequest();
        request.setTo(5000L);
        request.setModuleIndex(moduleIndex);
        request.setOutputValueVector(outputValueVector);
        request.setOutputEnableVector(enableVector);
        request.setMask(mask);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.sendMessage(request.toByteStream());
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndyGPIOOutputValues(int moduleIndex, int valueVector, int mask) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        IndyGPIOSetValueRequest request = new IndyGPIOSetValueRequest();
        request.setTo(5000L);
        request.setModuleIndex(moduleIndex);
        request.setOutputValueVector(valueVector);
        request.setMask(mask);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.sendMessage(request.toByteStream());
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoltageOutputCounts(int moduleIndex, int channel, int counts) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        if (channel < 0 || channel >= this.indyModules[moduleIndex].getNumberOfAnalogVOut()) {
            throw new IllegalArgumentException("Invalid channel index " + channel);
        }
        if (counts < 0 || counts > this.getVoltageOutputMaximumCounts(moduleIndex, channel)) {
            throw new IllegalArgumentException("Counts out of bounds at " + counts);
        }
        IndySetVOutCountsRequest request = new IndySetVOutCountsRequest();
        request.setTo(5000L);
        request.setModuleIndex(moduleIndex);
        request.setChannel(channel);
        request.setCounts(counts);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.sendMessage(request.toByteStream());
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoltageOutputVolts(int moduleIndex, int channel, float volts) throws IOException {
        if (moduleIndex < 0 || moduleIndex >= this.indyModules.length) {
            throw new IllegalArgumentException("Invalid module index " + moduleIndex);
        }
        IndySetVOutVoltsRequest request = new IndySetVOutVoltsRequest();
        request.setTo(5000L);
        request.setModuleIndex(moduleIndex);
        request.setChannel(channel);
        request.setVolts(volts);
        byte[] byArray = this.out;
        synchronized (this.out) {
            this.sendMessage(request.toByteStream());
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    protected static class Indy420Calibration {
        protected final int countsAt4mA;
        protected final int countsAt20mA;

        public Indy420Calibration(int counts4mA, int counts20mA) {
            this.countsAt4mA = counts4mA;
            this.countsAt20mA = counts20mA;
        }

        public int getCountsAt4mA() {
            return this.countsAt4mA;
        }

        public int getCountsAt20mA() {
            return this.countsAt20mA;
        }
    }

    protected static class Indy420TxStatus {
        protected final int moduleIndex;
        protected final boolean energized;
        protected final int counts;
        protected final float milliamps;
        protected final boolean enabled;

        public Indy420TxStatus(int index, boolean energized, int counts, float mA, boolean enabled) {
            this.moduleIndex = index;
            this.energized = energized;
            this.counts = counts;
            this.milliamps = mA;
            this.enabled = enabled;
        }

        public int getCounts() {
            return this.counts;
        }

        public float getMilliamps() {
            return this.milliamps;
        }

        public int getModuleIndex() {
            return this.moduleIndex;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isEnergized() {
            return this.energized;
        }
    }

    protected static class IndyExcitationStatus {
        protected final boolean enabled;
        protected final float voltage;

        public IndyExcitationStatus(boolean en, float v) {
            this.enabled = en;
            this.voltage = v;
        }

        public float getVoltage() {
            return this.voltage;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    protected static class IndyGPIOStatus {
        protected final int inputValueVector;
        protected final int outputValueVector;
        protected final int outputEnableVector;

        public IndyGPIOStatus(int inputs, int outputs, int enables) {
            this.inputValueVector = inputs;
            this.outputValueVector = outputs;
            this.outputEnableVector = enables;
        }

        public int getInputValueVector() {
            return this.inputValueVector;
        }

        public int getOutputEnableVector() {
            return this.outputEnableVector;
        }

        public int getOutputValueVector() {
            return this.outputValueVector;
        }
    }

    protected static class IndyFixedInfo {
        private final int moduleIndex;
        private final int numberOfGPIO;
        private final int numberOfAnalogVIn;
        private final int numberOfAnalogVOut;
        private final int numberOfAnalogCurrentIn;
        private final int numberOfAnalogCurrentOut;
        private final String serialNumber;

        public IndyFixedInfo(int index, int gpio, int vin, int vout, int iin, int iout, String sn) {
            this.moduleIndex = index;
            this.numberOfGPIO = gpio;
            this.numberOfAnalogVIn = vin;
            this.numberOfAnalogVOut = vout;
            this.numberOfAnalogCurrentIn = iin;
            this.numberOfAnalogCurrentOut = iout;
            this.serialNumber = new String(sn);
        }

        public int getModuleIndex() {
            return this.moduleIndex;
        }

        public int getNumberOfAnalogCurrentIn() {
            return this.numberOfAnalogCurrentIn;
        }

        public int getNumberOfAnalogCurrentOut() {
            return this.numberOfAnalogCurrentOut;
        }

        public int getNumberOfAnalogVIn() {
            return this.numberOfAnalogVIn;
        }

        public int getNumberOfAnalogVOut() {
            return this.numberOfAnalogVOut;
        }

        public int getNumberOfGPIO() {
            return this.numberOfGPIO;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }
    }

    public static class USB
    extends IndyImpl {
        private USBInterface usb;
        private static final short DATA_OUT = 8;
        private static final short LOW_SPEED_DATA_IN = 129;
        private static final short MAX_PACKET_SIZE = 100;
        private static USBEndpointDescriptor dataOutEndPoint = new USBEndpointDescriptor(7, 5, 8, 2, 100, 0);
        private static USBEndpointDescriptor lowSpeedInEndPoint = new USBEndpointDescriptor(7, 5, 129, 2, 100, 0);

        public USB(USBInterface usbInt) {
            super(usbInt.getInputBuffer(), usbInt.getOutputBuffer(), usbInt);
        }

        protected void setContext(Object o) {
            this.usb = (USBInterface)o;
        }

        protected byte[] getMessage(int length) throws IOException {
            byte[] retval = new byte[length];
            int bytesCopied = 0;
            while (bytesCopied < length) {
                int bytesToRead = Math.min(length - bytesCopied, 64);
                this.usb.bulkIn(lowSpeedInEndPoint, this.in, bytesToRead);
                for (int i = 0; i < bytesToRead; ++i) {
                    retval[bytesCopied] = this.in[i];
                    ++bytesCopied;
                }
            }
            return retval;
        }

        protected void sendMessage(byte[] message) throws IOException {
            this.out[0] = 16;
            this.out[1] = (byte)message.length;
            for (int i = 0; i < message.length; ++i) {
                this.out[i + 2] = message[i];
            }
            this.usb.bulkOut(dataOutEndPoint, this.out, message.length + 2);
        }
    }

    public static class Network
    extends IndyImpl {
        private Socket socket;

        public Network(Socket sock, byte[] inputBuffer, byte[] outputBuffer) {
            super(inputBuffer, outputBuffer, sock);
        }

        protected void setContext(Object o) {
            this.socket = (Socket)o;
        }

        protected byte[] getMessage(int length) throws IOException {
            this.socket.getInputStream().read(this.in, 0, length);
            return this.in;
        }

        protected void sendMessage(byte[] message) throws IOException {
            this.socket.getOutputStream().write(message, 0, message.length);
        }
    }
}

