/*
 * Decompiled with CFR 0.152.
 */
package com.oceanoptics.omnidriver.features.indy;

import com.oceanoptics.omnidriver.spectrometer.jaz.DispatchProtocolMessage;
import com.oceanoptics.utilities.ByteRoutines;

public class IndySet420TxMilliampsRequest
extends DispatchProtocolMessage {
    private static String __extern__ = "__extern__\n<init>,()V\ngetModuleIndex,()I\ngetMilliamps,()F\nsetModuleIndex,(I)V\nsetMilliamps,(F)V\n";

    public IndySet420TxMilliampsRequest() {
        this.setPayload(new byte[40]);
        this.setMessageType(5031L);
    }

    public int getModuleIndex() {
        return this.payload[0];
    }

    public float getMilliamps() {
        int temp = ByteRoutines.makeDWord((byte)this.payload[7], (byte)this.payload[6], (byte)this.payload[5], (byte)this.payload[4]);
        float retval = Float.intBitsToFloat(temp);
        return retval;
    }

    public void setModuleIndex(int moduleIndex) {
        this.payload[0] = (byte)moduleIndex;
    }

    public void setMilliamps(float mA) {
        int temp = Float.floatToRawIntBits(mA);
        this.payload[4] = (byte)(temp & 0xFF);
        this.payload[5] = (byte)(temp >> 8 & 0xFF);
        this.payload[6] = (byte)(temp >> 16 & 0xFF);
        this.payload[7] = (byte)(temp >> 24 & 0xFF);
    }
}

